/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.item.TFItems;

public class BlockTFHugeStalk
extends Block {
    private IIcon topIcon;

    protected BlockTFHugeStalk() {
        super(Material.wood);
        this.setHardness(1.25f);
        this.setResistance(7.0f);
        this.setBlockTextureName("TwilightForest:huge_stalk");
        this.setStepSound(soundTypeGrass);
        this.setCreativeTab(TFItems.creativeTab);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        super.registerBlockIcons(par1IconRegister);
        this.topIcon = par1IconRegister.registerIcon(this.getTextureName() + "_top");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.topIcon;
        }
        return this.blockIcon;
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void breakBlock(World world, int x, int y, int z, Block myBlock, int meta) {
        int radius = 4;
        int rad1 = radius + 1;
        if (world.checkChunksExist(x - rad1, y - rad1, z - rad1, x + rad1, y + rad1, z + rad1)) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        Block block = world.getBlock(x + dx, y + dy, z + dz);
                        if (!block.isLeaves((IBlockAccess)world, x + dx, y + dy, z + dz)) continue;
                        block.beginLeavesDecay(world, x + dx, y + dy, z + dz);
                    }
                }
            }
        }
    }
}

