/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public class BlockTFLeaves
extends BlockLeaves {
    int oakColor = 4764952;
    int canopyColor = 6330464;
    int mangroveColor = 8431445;
    public static final String[] unlocalizedNameArray = new String[]{"twilightoak", "canopy", "mangrove", "rainboak"};

    protected BlockTFLeaves() {
        this.setHardness(0.2f);
        this.setLightOpacity(2);
        this.setStepSound(Block.soundTypeGrass);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public int getBlockColor() {
        double var1 = 0.5;
        double var3 = 1.0;
        return ColorizerFoliage.getFoliageColor((double)var1, (double)var3);
    }

    public int getRenderColor(int par1) {
        return (par1 & 3) == 1 ? this.canopyColor : ((par1 & 3) == 2 ? this.mangroveColor : this.oakColor);
    }

    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int var9 = -1; var9 <= 1; ++var9) {
            for (int var10 = -1; var10 <= 1; ++var10) {
                int var11 = world.getBiomeGenForCoords(x + var10, z + var9).getBiomeFoliageColor(x, y, z);
                red += (var11 & 0xFF0000) >> 16;
                green += (var11 & 0xFF00) >> 8;
                blue += var11 & 0xFF;
            }
        }
        int normalColor = (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
        switch (meta & 3) {
            case 1: {
                return ((normalColor & 0xFEFEFE) + 4627046) / 2;
            }
            case 2: {
                return ((normalColor & 0xFEFEFE) + 12641940) / 2;
            }
            case 3: {
                red = x * 32 + y * 16;
                if ((red & 0x100) != 0) {
                    red = 255 - (red & 0xFF);
                }
                red &= 0xFF;
                blue = y * 32 + z * 16;
                if ((blue & 0x100) != 0) {
                    blue = 255 - (blue & 0xFF);
                }
                blue ^= 0xFF;
                green = x * 16 + z * 32;
                if ((green & 0x100) != 0) {
                    green = 255 - (green & 0xFF);
                }
                return red << 16 | blue << 8 | (green &= 0xFF);
            }
        }
        return normalColor;
    }

    public boolean isOpaqueCube() {
        return Blocks.leaves.isOpaqueCube();
    }

    public IIcon getIcon(int i, int j) {
        return Blocks.leaves.getIcon(i, (j & 3) == 3 ? 0 : j);
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return Blocks.leaves.shouldSideBeRendered(world, x, y, z, side);
    }

    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack(item, 1, 0));
        itemList.add(new ItemStack(item, 1, 1));
        itemList.add(new ItemStack(item, 1, 2));
        itemList.add(new ItemStack(item, 1, 3));
    }

    public int quantityDropped(Random rand) {
        return rand.nextInt(40) == 0 ? 1 : 0;
    }

    public Item getItemDropped(int meta, Random rand, int par3) {
        return Item.getItemFromBlock((Block)TFBlocks.sapling);
    }

    public int damageDropped(int par1) {
        int leafType = par1 & 3;
        return leafType;
    }

    public void dropBlockAsItemWithChance(World world, int x, int y, int z, int meta, float par6, int par7) {
        if (!world.isRemote) {
            int chance = 40;
            if ((meta & 3) == 2) {
                chance = 20;
            }
            if (world.rand.nextInt(chance) == 0) {
                Item item = this.getItemDropped(meta, world.rand, par7);
                this.dropBlockAsItem(world, x, y, z, new ItemStack(item, 1, this.getSaplingMeta(meta)));
            }
        }
    }

    public int getSaplingMeta(int leafMeta) {
        int leafType = leafMeta & 3;
        return leafType == 3 ? 9 : leafType;
    }

    public String[] func_150125_e() {
        return unlocalizedNameArray;
    }
}

