/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import twilightforest.TFGenericPacketHandler;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.block.TFBlocks;
import twilightforest.item.ItemTFOreMagnet;
import twilightforest.item.TFItems;

public class BlockTFMagicLogSpecial
extends BlockTFMagicLog {
    protected BlockTFMagicLogSpecial() {
        this.setCreativeTab(TFItems.creativeTab);
    }

    public int tickRate(World world) {
        return 20;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate(world));
    }

    @Override
    public Item getItemDropped(int par1, Random rand, int par3) {
        return Item.getItemFromBlock((Block)TFBlocks.magicLog);
    }

    @Override
    public IIcon getIcon(int side, int meta) {
        int orient = meta & 0xC;
        int woodType = meta & 3;
        if (orient == 12) {
            switch (woodType) {
                default: {
                    return side == 1 || side == 0 ? SPR_TIMETOP : SPR_TIMECLOCKOFF;
                }
                case 1: {
                    return side == 1 || side == 0 ? SPR_TRANSTOP : SPR_TRANSHEARTOFF;
                }
                case 2: {
                    return side == 1 || side == 0 ? SPR_MINETOP : SPR_MINEGEMOFF;
                }
                case 3: 
            }
            return side == 1 || side == 0 ? SPR_SORTTOP : SPR_SORTEYEOFF;
        }
        switch (woodType) {
            default: {
                return orient == 0 && (side == 1 || side == 0) ? SPR_TIMETOP : (orient == 4 && (side == 5 || side == 4) ? SPR_TIMETOP : (orient == 8 && (side == 2 || side == 3) ? SPR_TIMETOP : SPR_TIMECLOCK));
            }
            case 1: {
                return orient == 0 && (side == 1 || side == 0) ? SPR_TRANSTOP : (orient == 4 && (side == 5 || side == 4) ? SPR_TRANSTOP : (orient == 8 && (side == 2 || side == 3) ? SPR_TRANSTOP : SPR_TRANSHEART));
            }
            case 2: {
                return orient == 0 && (side == 1 || side == 0) ? SPR_MINETOP : (orient == 4 && (side == 5 || side == 4) ? SPR_MINETOP : (orient == 8 && (side == 2 || side == 3) ? SPR_MINETOP : SPR_MINEGEM));
            }
            case 3: 
        }
        return orient == 0 && (side == 1 || side == 0) ? SPR_SORTTOP : (orient == 4 && (side == 5 || side == 4) ? SPR_SORTTOP : (orient == 8 && (side == 2 || side == 3) ? SPR_SORTTOP : SPR_SORTEYE));
    }

    public void updateTick(World world, int x, int y, int z, Random rand) {
        int meta = world.getBlockMetadata(x, y, z);
        if ((meta & 0xC) == 12) {
            return;
        }
        if (!world.isRemote) {
            switch (meta & 3) {
                case 0: {
                    world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.1f, 0.5f);
                    this.doTreeOfTimeEffect(world, x, y, z, rand);
                    break;
                }
                case 1: {
                    this.doTreeOfTransformationEffect(world, x, y, z, rand);
                    break;
                }
                case 2: {
                    this.doMinersTreeEffect(world, x, y, z, rand);
                    break;
                }
                case 3: {
                    this.doSortingTreeEffect(world, x, y, z, rand);
                }
            }
        }
        world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate(world));
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        int meta = world.getBlockMetadata(x, y, z);
        int orient = meta & 0xC;
        int woodType = meta & 3;
        if (orient == 0) {
            world.setBlockMetadataWithNotify(x, y, z, woodType | 0xC, 3);
            return true;
        }
        if (orient == 12) {
            world.setBlockMetadataWithNotify(x, y, z, woodType | 0, 3);
            world.scheduleBlockUpdate(x, y, z, (Block)this, this.tickRate(world));
            return true;
        }
        return false;
    }

    private void doTreeOfTimeEffect(World world, int x, int y, int z, Random rand) {
        int numticks = 24 * this.tickRate(world);
        int successes = 0;
        for (int i = 0; i < numticks; ++i) {
            int dz;
            int dy;
            int dx = rand.nextInt(32) - 16;
            Block thereID = world.getBlock(x + dx, y + (dy = rand.nextInt(32) - 16), z + (dz = rand.nextInt(32) - 16));
            if (thereID == Blocks.air || !thereID.getTickRandomly()) continue;
            world.scheduleBlockUpdate(x + dx, y + dy, z + dz, thereID, 20);
            thereID.updateTick(world, x + dx, y + dy, z + dz, rand);
            ++successes;
        }
    }

    private void doTreeOfTransformationEffect(World world, int x, int y, int z, Random rand) {
        for (int i = 0; i < 1; ++i) {
            BiomeGenBase biomeAt;
            int dx = rand.nextInt(32) - 16;
            int dz = rand.nextInt(32) - 16;
            world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "note.harp", 0.1f, rand.nextFloat() * 2.0f);
            if (!(Math.sqrt(dx * dx + dz * dz) < 16.0) || (biomeAt = world.getBiomeGenForCoords(x + dx, z + dz)) == TFBiomeBase.enchantedForest) continue;
            Chunk chunkAt = world.getChunkFromBlockCoords(x + dx, z + dz);
            chunkAt.getBiomeArray()[(z + dz & 0xF) << 4 | x + dx & 0xF] = (byte)TFBiomeBase.enchantedForest.biomeID;
            world.markBlockForUpdate(x + dx, y, z + dz);
            if (!(world instanceof WorldServer)) continue;
            this.sendChangedBiome(world, x + dx, z + dz, chunkAt);
        }
    }

    private void sendChangedBiome(World world, int x, int z, Chunk chunkAt) {
        FMLProxyPacket message = TFGenericPacketHandler.makeBiomeChangePacket(x, z, (byte)TFBiomeBase.enchantedForest.biomeID);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.provider.dimensionId, (double)x, 128.0, (double)z, 128.0);
        TwilightForestMod.genericChannel.sendToAllAround(message, targetPoint);
    }

    private void doMinersTreeEffect(World world, int x, int y, int z, Random rand) {
        int dz;
        int dy;
        int dx = rand.nextInt(64) - 32;
        int moved = ItemTFOreMagnet.doMagnet(world, x, y, z, x + dx, y + (dy = rand.nextInt(64) - 32), z + (dz = rand.nextInt(64) - 32));
        if (moved > 0) {
            world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.endermen.portal", 0.1f, 1.0f);
        }
    }

    private void doSortingTreeEffect(World world, int x, int y, int z, Random rand) {
        int slotNum;
        IInventory chest2;
        int i;
        int XSEARCH = 16;
        int YSEARCH = 16;
        int ZSEARCH = 16;
        ArrayList<IInventory> chests = new ArrayList<IInventory>();
        int itemCount = 0;
        for (int sx = x - XSEARCH; sx < x + XSEARCH; ++sx) {
            for (int sy = y - YSEARCH; sy < y + YSEARCH; ++sy) {
                for (int sz = z - ZSEARCH; sz < z + ZSEARCH; ++sz) {
                    IInventory thisChest;
                    if (world.getBlock(sx, sy, sz) != Blocks.chest || (thisChest = Blocks.chest.func_149951_m(world, sx, sy, sz)) == null || this.checkIfChestsContains(chests, (IInventory)world.getTileEntity(sx, sy, sz))) continue;
                    int itemsInChest = 0;
                    for (i = 0; i < thisChest.getSizeInventory(); ++i) {
                        if (thisChest.getStackInSlot(i) == null) continue;
                        ++itemsInChest;
                        ++itemCount;
                    }
                    if (itemsInChest <= 0) continue;
                    chests.add(thisChest);
                }
            }
        }
        ItemStack beingSorted = null;
        int sortedChestNum = -1;
        int sortedSlotNum = -1;
        if (itemCount > 0) {
            int itemNumber = rand.nextInt(itemCount);
            int currentNumber = 0;
            for (i = 0; i < chests.size(); ++i) {
                chest2 = (IInventory)chests.get(i);
                for (slotNum = 0; slotNum < chest2.getSizeInventory(); ++slotNum) {
                    ItemStack currentItem = chest2.getStackInSlot(slotNum);
                    if (currentItem == null || currentNumber++ != itemNumber) continue;
                    beingSorted = currentItem;
                    sortedChestNum = i;
                    sortedSlotNum = slotNum;
                }
            }
        }
        if (beingSorted != null) {
            int matchChestNum = -1;
            int matchCount = 0;
            for (int chestNum = 0; chestNum < chests.size(); ++chestNum) {
                chest2 = (IInventory)chests.get(chestNum);
                int currentChestMatches = 0;
                for (int slotNum2 = 0; slotNum2 < chest2.getSizeInventory(); ++slotNum2) {
                    ItemStack currentItem = chest2.getStackInSlot(slotNum2);
                    if (currentItem == null || !this.isSortingMatch(beingSorted, currentItem)) continue;
                    currentChestMatches += currentItem.stackSize;
                }
                if (currentChestMatches <= matchCount) continue;
                matchCount = currentChestMatches;
                matchChestNum = chestNum;
            }
            if (matchChestNum >= 0 && matchChestNum != sortedChestNum) {
                IInventory moveChest = (IInventory)chests.get(matchChestNum);
                IInventory oldChest = (IInventory)chests.get(sortedChestNum);
                int moveSlot = this.getEmptySlotIn(moveChest);
                if (moveSlot >= 0) {
                    oldChest.setInventorySlotContents(sortedSlotNum, null);
                    moveChest.setInventorySlotContents(moveSlot, beingSorted);
                }
            }
            if (beingSorted.stackSize < beingSorted.getMaxStackSize()) {
                for (IInventory chest2 : chests) {
                    for (slotNum = 0; slotNum < chest2.getSizeInventory(); ++slotNum) {
                        ItemStack currentItem = chest2.getStackInSlot(slotNum);
                        if (currentItem == null || currentItem == beingSorted || !beingSorted.isItemEqual(currentItem) || currentItem.stackSize > beingSorted.getMaxStackSize() - beingSorted.stackSize) continue;
                        chest2.setInventorySlotContents(slotNum, null);
                        beingSorted.stackSize += currentItem.stackSize;
                        currentItem.stackSize = 0;
                    }
                }
            }
        }
    }

    private boolean isSortingMatch(ItemStack beingSorted, ItemStack currentItem) {
        return this.getCreativeTab(currentItem.getItem()).equals(this.getCreativeTab(beingSorted.getItem()));
    }

    private Object getCreativeTab(Item item) {
        try {
            return ObfuscationReflectionHelper.getPrivateValue(Item.class, (Object)item, (int)0);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean checkIfChestsContains(ArrayList<IInventory> chests, IInventory testChest) {
        for (IInventory chest : chests) {
            if (chest.equals(testChest)) {
                return true;
            }
            if (!(chest instanceof InventoryLargeChest) || !((InventoryLargeChest)chest).isPartOfLargeChest(testChest)) continue;
            return true;
        }
        return false;
    }

    private int getEmptySlotIn(IInventory chest) {
        for (int i = 0; i < chest.getSizeInventory(); ++i) {
            if (chest.getStackInSlot(i) != null) continue;
            return i;
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 15;
    }

    @Override
    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack(item, 1, 0));
        itemList.add(new ItemStack(item, 1, 1));
        itemList.add(new ItemStack(item, 1, 2));
        itemList.add(new ItemStack(item, 1, 3));
    }
}

