/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import twilightforest.item.ItemTFMazebreakerPick;
import twilightforest.item.TFItems;

public class BlockTFMazestone
extends Block {
    private static IIcon TEX_PLAIN;
    private static IIcon TEX_BRICK;
    private static IIcon TEX_PILLAR;
    private static IIcon TEX_DECO;
    private static IIcon TEX_CRACKED;
    private static IIcon TEX_MOSSY;
    private static IIcon TEX_MOSAIC;
    private static IIcon TEX_BORDER;

    public BlockTFMazestone() {
        super(Material.rock);
        this.setHardness(100.0f);
        this.setResistance(5.0f);
        this.setStepSound(Block.soundTypeStone);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public IIcon getIcon(int side, int meta) {
        switch (meta) {
            default: {
                return TEX_PLAIN;
            }
            case 1: {
                return TEX_BRICK;
            }
            case 2: {
                return side > 1 ? TEX_PILLAR : TEX_PLAIN;
            }
            case 3: {
                return side > 1 ? TEX_DECO : TEX_BRICK;
            }
            case 4: {
                return TEX_CRACKED;
            }
            case 5: {
                return TEX_MOSSY;
            }
            case 6: {
                return side > 1 ? TEX_BRICK : TEX_MOSAIC;
            }
            case 7: 
        }
        return side > 1 ? TEX_BRICK : TEX_BORDER;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        TEX_PLAIN = par1IconRegister.registerIcon("TwilightForest:mazestone_plain");
        TEX_BRICK = par1IconRegister.registerIcon("TwilightForest:mazestone_brick");
        TEX_PILLAR = par1IconRegister.registerIcon("TwilightForest:mazestone_pillar");
        TEX_DECO = par1IconRegister.registerIcon("TwilightForest:mazestone_decorative");
        TEX_CRACKED = par1IconRegister.registerIcon("TwilightForest:mazestone_cracked");
        TEX_MOSSY = par1IconRegister.registerIcon("TwilightForest:mazestone_mossy");
        TEX_MOSAIC = par1IconRegister.registerIcon("TwilightForest:mazestone_mosaic");
        TEX_BORDER = par1IconRegister.registerIcon("TwilightForest:mazestone_border");
    }

    public void harvestBlock(World world, EntityPlayer entityplayer, int x, int y, int z, int meta) {
        ItemStack cei = entityplayer.getCurrentEquippedItem();
        if (cei != null && cei.getItem() instanceof ItemTool && !(cei.getItem() instanceof ItemTFMazebreakerPick)) {
            cei.damageItem(16, (EntityLivingBase)entityplayer);
        }
        super.harvestBlock(world, entityplayer, x, y, z, meta);
    }

    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 1));
        par3List.add(new ItemStack(par1, 1, 2));
        par3List.add(new ItemStack(par1, 1, 3));
        par3List.add(new ItemStack(par1, 1, 4));
        par3List.add(new ItemStack(par1, 1, 5));
        par3List.add(new ItemStack(par1, 1, 6));
        par3List.add(new ItemStack(par1, 1, 7));
    }

    public int damageDropped(int meta) {
        return meta;
    }
}

