/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public class BlockTFPlant
extends BlockBush
implements IShearable {
    boolean[] isGrassColor = new boolean[]{false, false, false, false, true, true, false, false, true, false, true, false, false, false, false, false};
    int[] lightValue = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 8, 0, 0};
    private IIcon[] icons;
    private String[] iconNames = new String[]{null, null, null, "mosspatch", "mayapple", "cloverpatch", null, null, "fiddlehead", "mushgloom", null, null, null, "torchberry", "rootstrand", null};
    public static IIcon mayappleSide;
    public static final int META_MOSSPATCH = 3;
    public static final int META_MAYAPPLE = 4;
    public static final int META_CLOVERPATCH = 5;
    public static final int META_FIDDLEHEAD = 8;
    public static final int META_MUSHGLOOM = 9;
    public static final int META_FORESTGRASS = 10;
    public static final int META_DEADBUSH = 11;
    public static final int META_TORCHBERRY = 13;
    public static final int META_ROOT_STRAND = 14;

    protected BlockTFPlant() {
        super(Material.plants);
        this.setTickRandomly(true);
        float var3 = 0.4f;
        this.setBlockBounds(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, 0.8f, 0.5f + var3);
        this.setHardness(0.0f);
        this.setStepSound(Block.soundTypeGrass);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public IIcon getIcon(int side, int metadata) {
        return this.icons[metadata];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.icons = new IIcon[this.iconNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            if (this.iconNames[i] == null) continue;
            this.icons[i] = par1IconRegister.registerIcon("TwilightForest:" + this.iconNames[i]);
        }
        this.icons[10] = Blocks.tallgrass.getIcon(2, 1);
        this.icons[11] = Blocks.deadbush.getBlockTextureFromSide(2);
        mayappleSide = par1IconRegister.registerIcon("TwilightForest:mayapple_side");
    }

    public int getBlockColor() {
        double var1 = 0.5;
        double var3 = 1.0;
        return ColorizerGrass.getGrassColor((double)var1, (double)var3);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        world.scheduleBlockUpdate(i, j, k, (Block)this, world.rand.nextInt(50) + 20);
    }

    public boolean canReplace(World par1World, int x, int y, int z, int par5, ItemStack par6ItemStack) {
        Block blockAt = par1World.getBlock(x, y, z);
        return (blockAt == Blocks.air || blockAt.getMaterial().isReplaceable()) && this.canBlockStay(par1World, x, y, z, par6ItemStack.getItemDamage());
    }

    public boolean canBlockStay(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        return this.canBlockStay(world, x, y, z, meta);
    }

    public boolean canBlockStay(World world, int x, int y, int z, int meta) {
        Block soil = world.getBlock(x, y - 1, z);
        switch (meta) {
            case 13: 
            case 14: {
                return BlockTFPlant.canPlaceRootBelow(world, x, y + 1, z);
            }
            case 0: 
            case 10: 
            case 11: {
                return soil != null && soil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
            }
            case 3: 
            case 9: {
                return soil != null && soil.isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.UP);
            }
        }
        return (world.getFullBlockLightValue(x, y, z) >= 3 || world.canBlockSeeTheSky(x, y, z)) && soil != null && soil.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        int meta = par1IBlockAccess.getBlockMetadata(x, y, z);
        if (meta == 3) {
            long seed = (long)x * 3129871L ^ (long)y * 116129781L ^ (long)z;
            seed = seed * seed * 42317861L + seed * 11L;
            int xOff0 = (int)(seed >> 12 & 3L);
            int xOff1 = (int)(seed >> 15 & 3L);
            int zOff0 = (int)(seed >> 18 & 3L);
            int zOff1 = (int)(seed >> 21 & 3L);
            boolean xConnect0 = par1IBlockAccess.getBlock(x + 1, y, z) == this && par1IBlockAccess.getBlockMetadata(x + 1, y, z) == 3;
            boolean xConnect1 = par1IBlockAccess.getBlock(x - 1, y, z) == this && par1IBlockAccess.getBlockMetadata(x - 1, y, z) == 3;
            boolean zConnect0 = par1IBlockAccess.getBlock(x, y, z + 1) == this && par1IBlockAccess.getBlockMetadata(x, y, z + 1) == 3;
            boolean zConnect1 = par1IBlockAccess.getBlock(x, y, z - 1) == this && par1IBlockAccess.getBlockMetadata(x, y, z - 1) == 3;
            this.setBlockBounds(xConnect1 ? 0.0f : (1.0f + (float)xOff1) / 16.0f, 0.0f, zConnect1 ? 0.0f : (1.0f + (float)zOff1) / 16.0f, xConnect0 ? 1.0f : (15.0f - (float)xOff0) / 16.0f, 0.0625f, zConnect0 ? 1.0f : (15.0f - (float)zOff0) / 16.0f);
        } else if (meta == 5) {
            long seed = (long)x * 3129871L ^ (long)y * 116129781L ^ (long)z;
            seed = seed * seed * 42317861L + seed * 11L;
            int xOff0 = (int)(seed >> 12 & 3L);
            int xOff1 = (int)(seed >> 15 & 3L);
            int zOff0 = (int)(seed >> 18 & 3L);
            int zOff1 = (int)(seed >> 21 & 3L);
            int yOff0 = (int)(seed >> 24 & 1L);
            int yOff1 = (int)(seed >> 27 & 1L);
            boolean xConnect0 = par1IBlockAccess.getBlock(x + 1, y, z) == this && par1IBlockAccess.getBlockMetadata(x + 1, y, z) == 5;
            boolean xConnect1 = par1IBlockAccess.getBlock(x - 1, y, z) == this && par1IBlockAccess.getBlockMetadata(x - 1, y, z) == 5;
            boolean zConnect0 = par1IBlockAccess.getBlock(x, y, z + 1) == this && par1IBlockAccess.getBlockMetadata(x, y, z + 1) == 5;
            boolean zConnect1 = par1IBlockAccess.getBlock(x, y, z - 1) == this && par1IBlockAccess.getBlockMetadata(x, y, z - 1) == 5;
            this.setBlockBounds(xConnect1 ? 0.0f : (1.0f + (float)xOff1) / 16.0f, 0.0f, zConnect1 ? 0.0f : (1.0f + (float)zOff1) / 16.0f, xConnect0 ? 1.0f : (15.0f - (float)xOff0) / 16.0f, (1.0f + (float)yOff0 + (float)yOff1) / 16.0f, zConnect0 ? 1.0f : (15.0f - (float)zOff0) / 16.0f);
        } else if (meta == 4) {
            this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.8125f, 0.375f, 0.8125f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public int getRenderColor(int par1) {
        return this.isGrassColor[par1] ? ColorizerFoliage.getFoliageColorBasic() : 0xFFFFFF;
    }

    public int colorMultiplier(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        return this.isGrassColor[meta] ? world.getBiomeGenForCoords(x, z).getBiomeGrassColor(x, y, z) : 0xFFFFFF;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int x, int y, int z) {
        par1World.getBlockMetadata(x, y, z);
        return null;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return TwilightForestMod.proxy.getPlantBlockRenderID();
    }

    public void updateTick(World world, int x, int y, int z, Random random) {
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        return this.lightValue[meta];
    }

    public static boolean canPlaceRootBelow(World world, int x, int y, int z) {
        Block blockID = world.getBlock(x, y, z);
        if (blockID != null && (blockID.getMaterial() == Material.ground || blockID.getMaterial() == Material.grass)) {
            return true;
        }
        int blockMeta = world.getBlockMetadata(x, y, z);
        return blockID == TFBlocks.plant && blockMeta == 14 || blockID == TFBlocks.root && blockMeta == 0;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        switch (meta) {
            case 13: {
                ret.add(new ItemStack(TFItems.torchberries));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            default: {
                ret.add(new ItemStack((Block)this, 1, meta));
            }
        }
        return ret;
    }

    public int damageDropped(int par1) {
        return par1;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, world.getBlockMetadata(x, y, z)));
        return ret;
    }

    public void harvestBlock(World world, EntityPlayer player, int x, int y, int z, int meta) {
        if (world.isRemote || player.getCurrentEquippedItem() == null || player.getCurrentEquippedItem().getItem() != Items.shears) {
            super.harvestBlock(world, player, x, y, z, meta);
        }
    }

    public void getSubBlocks(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack((Block)this, 1, 3));
        itemList.add(new ItemStack((Block)this, 1, 4));
        itemList.add(new ItemStack((Block)this, 1, 8));
        itemList.add(new ItemStack((Block)this, 1, 9));
        itemList.add(new ItemStack((Block)this, 1, 10));
        itemList.add(new ItemStack((Block)this, 1, 11));
        itemList.add(new ItemStack((Block)this, 1, 13));
        itemList.add(new ItemStack((Block)this, 1, 14));
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        switch (meta) {
            case 3: 
            case 9: {
                return EnumPlantType.Cave;
            }
        }
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        super.randomDisplayTick(world, x, y, z, random);
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 3 && random.nextInt(10) == 0) {
            world.spawnParticle("townaura", (double)((float)x + random.nextFloat()), (double)((float)y + 0.1f), (double)((float)z + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }
}

