/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.block.BlockTFTowerDevice;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public class BlockTFTowerTranslucent
extends Block {
    public static final int META_REAPPEARING_INACTIVE = 0;
    public static final int META_REAPPEARING_ACTIVE = 1;
    public static final int META_BUILT_INACTIVE = 2;
    public static final int META_BUILT_ACTIVE = 3;
    public static final int META_REVERTER_REPLACEMENT = 4;
    public static final int META_REACTOR_DEBRIS = 5;
    public static final int META_FAKE_GOLD = 6;
    public static final int META_FAKE_DIAMOND = 7;
    public static IIcon TEX_REAPPEARING_INACTIVE;
    public static IIcon TEX_REAPPEARING_ACTIVE;
    public static IIcon TEX_BUILT_INACTIVE;
    public static IIcon TEX_BUILT_ACTIVE;
    public static IIcon TEX_REVERTER_REPLACEMENT;
    private static Random sideRNG;

    public BlockTFTowerTranslucent() {
        super(Material.glass);
        this.setHardness(50.0f);
        this.setResistance(2000.0f);
        this.setStepSound(Block.soundTypeMetal);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int tickRate() {
        return 15;
    }

    public Item getItemDropped(int par1, Random par2Random, int par3) {
        return null;
    }

    protected boolean canSilkHarvest() {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int par2, int par3, int par4) {
        int meta = par1World.getBlockMetadata(par2, par3, par4) & 7;
        if (meta == 0 || meta == 1) {
            return null;
        }
        this.setBlockBoundsBasedOnState((IBlockAccess)par1World, par2, par3, par4);
        return super.getCollisionBoundingBoxFromPool(par1World, par2, par3, par4);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int meta = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        if (meta == 0 || meta == 1) {
            this.setBlockBounds(0.375f, 0.375f, 0.375f, 0.625f, 0.625f, 0.625f);
        }
        if (meta == 5) {
            this.setBlockBounds(sideRNG.nextFloat() * 0.4f, sideRNG.nextFloat() * 0.4f, sideRNG.nextFloat() * 0.4f, 1.0f - sideRNG.nextFloat() * 0.4f, 1.0f - sideRNG.nextFloat() * 0.4f, 1.0f - sideRNG.nextFloat() * 0.4f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 4 || meta == 5) {
            return 0.3f;
        }
        return super.getBlockHardness(world, x, y, z);
    }

    public boolean getBlocksMovement(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        int meta = par1IBlockAccess.getBlockMetadata(par2, par3, par4);
        switch (meta) {
            default: {
                return false;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
        }
        return true;
    }

    public IIcon getIcon(int side, int meta) {
        switch (meta) {
            default: {
                return TEX_REAPPEARING_INACTIVE;
            }
            case 1: {
                return TEX_REAPPEARING_ACTIVE;
            }
            case 2: {
                return TEX_BUILT_INACTIVE;
            }
            case 3: {
                return TEX_BUILT_ACTIVE;
            }
            case 4: {
                return TEX_REVERTER_REPLACEMENT;
            }
            case 5: {
                BlockPortal toMimic = sideRNG.nextBoolean() ? (sideRNG.nextBoolean() ? Blocks.portal : Blocks.netherrack) : (sideRNG.nextBoolean() ? Blocks.bedrock : Blocks.obsidian);
                return toMimic.getIcon(side, meta);
            }
            case 6: {
                return Blocks.gold_block.getIcon(side, meta);
            }
            case 7: 
        }
        return Blocks.diamond_block.getIcon(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        TEX_REAPPEARING_INACTIVE = par1IconRegister.registerIcon("TwilightForest:towerdev_reappearing_trace_off");
        TEX_REAPPEARING_ACTIVE = par1IconRegister.registerIcon("TwilightForest:towerdev_reappearing_trace_on");
        TEX_BUILT_INACTIVE = par1IconRegister.registerIcon("TwilightForest:towerdev_built_off");
        TEX_BUILT_ACTIVE = par1IconRegister.registerIcon("TwilightForest:towerdev_built_on");
        TEX_REVERTER_REPLACEMENT = par1IconRegister.registerIcon("TwilightForest:towerdev_antibuilt");
    }

    public void updateTick(World par1World, int x, int y, int z, Random par5Random) {
        if (!par1World.isRemote) {
            int meta = par1World.getBlockMetadata(x, y, z);
            if (meta == 3) {
                par1World.setBlock(x, y, z, Blocks.air, 0, 3);
                par1World.notifyBlocksOfNeighborChange(x, y, z, (Block)this);
                par1World.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.pop", 0.3f, 0.5f);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x - 1, y, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x + 1, y, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y + 1, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y - 1, z);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z + 1);
                BlockTFTowerDevice.checkAndActivateVanishBlock(par1World, x, y, z - 1);
            }
            if (meta == 1) {
                par1World.setBlock(x, y, z, TFBlocks.towerDevice, 0, 3);
                par1World.notifyBlocksOfNeighborChange(x, y, z, (Block)this);
                par1World.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.5f);
            } else if (meta == 0) {
                BlockTFTowerDevice.changeToActiveVanishBlock(par1World, x, y, z, 1);
            }
        }
    }

    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
    }

    static {
        sideRNG = new Random();
    }
}

