/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;

public class BlockTFTrophyPedestal
extends Block {
    private IIcon sprTopActive;
    private IIcon sprTop;
    private IIcon sprBottom;
    private IIcon sprNagaActive;
    private IIcon sprNaga;
    private IIcon sprLichActive;
    private IIcon sprLich;
    private IIcon sprHydraActive;
    private IIcon sprHydra;
    private IIcon sprUrghastActive;
    private IIcon sprUrghast;

    public BlockTFTrophyPedestal() {
        super(Material.rock);
        this.setHardness(2.0f);
        this.setResistance(2000.0f);
        this.setStepSound(Block.soundTypeStone);
        this.setCreativeTab(TFItems.creativeTab);
    }

    public IIcon getIcon(int side, int meta) {
        if (side == 1) {
            return meta > 7 ? this.sprTopActive : this.sprTop;
        }
        if (side >= 2 && side <= 5) {
            int rotate = meta & 3;
            int rotatedSide = (side - 2 + rotate) % 4;
            switch (rotatedSide) {
                case 0: {
                    return meta > 7 ? this.sprNagaActive : this.sprNaga;
                }
                case 1: {
                    return meta > 7 ? this.sprLichActive : this.sprLich;
                }
                case 2: {
                    return meta > 7 ? this.sprHydraActive : this.sprHydra;
                }
                case 3: {
                    return meta > 7 ? this.sprUrghastActive : this.sprUrghast;
                }
            }
        }
        return this.sprTop;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister) {
        this.sprTopActive = par1IconRegister.registerIcon("TwilightForest:pedestal_top_active");
        this.sprTop = par1IconRegister.registerIcon("TwilightForest:pedestal_top");
        this.sprBottom = par1IconRegister.registerIcon("TwilightForest:pedestal_top");
        this.sprNagaActive = par1IconRegister.registerIcon("TwilightForest:pedestal_naga_active");
        this.sprNaga = par1IconRegister.registerIcon("TwilightForest:pedestal_naga");
        this.sprLichActive = par1IconRegister.registerIcon("TwilightForest:pedestal_lich_active");
        this.sprLich = par1IconRegister.registerIcon("TwilightForest:pedestal_lich");
        this.sprHydraActive = par1IconRegister.registerIcon("TwilightForest:pedestal_hydra_active");
        this.sprHydra = par1IconRegister.registerIcon("TwilightForest:pedestal_hydra");
        this.sprUrghastActive = par1IconRegister.registerIcon("TwilightForest:pedestal_urghast_active");
        this.sprUrghast = par1IconRegister.registerIcon("TwilightForest:pedestal_urghast");
    }

    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
        par3List.add(new ItemStack(par1, 1, 15));
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public int getRenderType() {
        return TwilightForestMod.proxy.getPedestalBlockRenderID();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public void onNeighborBlockChange(World par1World, int x, int y, int z, Block myBlockID) {
        int meta = par1World.getBlockMetadata(x, y, z);
        if (!par1World.isRemote && meta > 0 && this.isTrophyOnTop(par1World, x, y, z)) {
            par1World.scheduleBlockUpdate(x, y, z, (Block)this, 1);
        }
    }

    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int facing = MathHelper.floor_double((double)((double)(par5EntityLivingBase.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        int latent = par6ItemStack.getItemDamage() & 8;
        if (facing == 0) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 0 | latent, 2);
        }
        if (facing == 1) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 1 | latent, 2);
        }
        if (facing == 2) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 3 | latent, 2);
        }
        if (facing == 3) {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 2 | latent, 2);
        }
    }

    private boolean isTrophyOnTop(World world, int x, int y, int z) {
        return world.getBlock(x, y + 1, z) == TFBlocks.trophy;
    }

    public void updateTick(World world, int x, int y, int z, Random par5Random) {
        if (!world.isRemote) {
            int meta = world.getBlockMetadata(x, y, z);
            if (this.isTrophyOnTop(world, x, y, z)) {
                if (meta > 7) {
                    if (world.getGameRules().getGameRuleBooleanValue("tfEnforcedProgression")) {
                        if (this.areNearbyPlayersEligible(world, x, y, z)) {
                            this.doPedestalEffect(world, x, y, z, meta);
                        }
                        this.warnIneligiblePlayers(world, x, y, z);
                    } else {
                        this.doPedestalEffect(world, x, y, z, meta);
                    }
                }
                this.rewardNearbyPlayers(world, x, y, z);
            }
        }
    }

    private void warnIneligiblePlayers(World world, int x, int y, int z) {
        List nearbyPlayers = world.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).expand(16.0, 16.0, 16.0));
        for (EntityPlayer player : nearbyPlayers) {
            if (this.isPlayerEligible(player)) continue;
            player.addChatMessage((IChatComponent)new ChatComponentText("You are unworthy."));
        }
    }

    private boolean areNearbyPlayersEligible(World world, int x, int y, int z) {
        boolean isEligible = false;
        List nearbyPlayers = world.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).expand(16.0, 16.0, 16.0));
        for (EntityPlayer player : nearbyPlayers) {
            isEligible |= this.isPlayerEligible(player);
        }
        return isEligible;
    }

    private boolean isPlayerEligible(EntityPlayer player) {
        if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).func_147099_x() != null) {
            StatisticsFile stats = ((EntityPlayerMP)player).func_147099_x();
            return stats.hasAchievementUnlocked(TFAchievementPage.twilightProgressTrophyPedestal.parentAchievement);
        }
        if (player instanceof EntityClientPlayerMP && ((EntityClientPlayerMP)player).getStatFileWriter() != null) {
            StatFileWriter stats = ((EntityClientPlayerMP)player).getStatFileWriter();
            return stats.hasAchievementUnlocked(TFAchievementPage.twilightProgressTrophyPedestal.parentAchievement);
        }
        return false;
    }

    private void doPedestalEffect(World world, int x, int y, int z, int meta) {
        this.removeNearbyShields(world, x, y, z);
        world.setBlockMetadataWithNotify(x, y, z, meta & 7, 2);
        world.playSoundEffect((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.zombie.infect", 4.0f, 0.1f);
    }

    private void rewardNearbyPlayers(World world, int x, int y, int z) {
        List nearbyPlayers = world.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).expand(16.0, 16.0, 16.0));
        for (EntityPlayer player : nearbyPlayers) {
            player.triggerAchievement((StatBase)TFAchievementPage.twilightProgressTrophyPedestal);
        }
    }

    protected void removeNearbyShields(World world, int x, int y, int z) {
        for (int sx = -5; sx <= 5; ++sx) {
            for (int sy = -5; sy <= 5; ++sy) {
                for (int sz = -5; sz <= 5; ++sz) {
                    Block blockAt = world.getBlock(x + sx, y + sy, z + sz);
                    int metaAt = world.getBlockMetadata(x + sx, y + sy, z + sz);
                    if (blockAt != TFBlocks.shield || metaAt != 15) continue;
                    world.setBlock(x + sx, y + sy, z + sz, Blocks.air, 0, 2);
                    world.playAuxSFX(2001, x + sx, y + sy, z + sz, Block.getIdFromBlock((Block)blockAt) + (metaAt << 12));
                }
            }
        }
    }

    public int tickRate(World world) {
        return 10;
    }

    public float getPlayerRelativeBlockHardness(EntityPlayer par1EntityPlayer, World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta > 0) {
            return -1.0f;
        }
        return super.getPlayerRelativeBlockHardness(par1EntityPlayer, world, x, y, z);
    }
}

