/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import twilightforest.inventory.ContainerTFUncrafting;

public class GuiTFGoblinCrafting
extends GuiContainer {
    private static final ResourceLocation textureLoc = new ResourceLocation("twilightforest:textures/gui/guigoblintinkering.png");

    public GuiTFGoblinCrafting(InventoryPlayer inventory, World world, int x, int y, int z) {
        super((Container)new ContainerTFUncrafting(inventory, world, x, y, z));
    }

    protected void drawGuiContainerForegroundLayer(int var1, int var2) {
        this.fontRendererObj.drawString("Uncrafting Table", 8, 6, 0x404040);
        this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 8, this.ySize - 96 + 2, 0x404040);
    }

    protected void drawGuiContainerBackgroundLayer(float var1, int var2, int var3) {
        int color;
        String cost;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(textureLoc);
        int frameX = (this.width - this.xSize) / 2;
        int frameY = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(frameX, frameY, 0, 0, this.xSize, this.ySize);
        ContainerTFUncrafting tfContainer = (ContainerTFUncrafting)this.inventorySlots;
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        for (int i = 0; i < 9; ++i) {
            Slot uncrafting = tfContainer.getSlot(2 + i);
            Slot assembly = tfContainer.getSlot(11 + i);
            if (uncrafting.getStack() == null) continue;
            this.drawSlotAsBackground(uncrafting, assembly);
        }
        GL11.glPopMatrix();
        FontRenderer fontRendererObj = this.mc.fontRenderer;
        RenderHelper.disableStandardItemLighting();
        int costVal = tfContainer.getUncraftingCost();
        if (costVal > 0) {
            cost = String.valueOf(costVal);
            if (this.mc.thePlayer.experienceLevel < costVal && !this.mc.thePlayer.capabilities.isCreativeMode) {
                color = 0xA00000;
                fontRendererObj.drawStringWithShadow(cost, frameX + 48 - fontRendererObj.getStringWidth(cost), frameY + 38, color);
            } else {
                color = 8453920;
                fontRendererObj.drawStringWithShadow(cost, frameX + 48 - fontRendererObj.getStringWidth(cost), frameY + 38, color);
            }
        }
        if ((costVal = tfContainer.getRecraftingCost()) > 0) {
            cost = String.valueOf(costVal);
            if (this.mc.thePlayer.experienceLevel < costVal && !this.mc.thePlayer.capabilities.isCreativeMode) {
                color = 0xA00000;
                fontRendererObj.drawStringWithShadow(cost, frameX + 130 - fontRendererObj.getStringWidth(cost), frameY + 38, color);
            } else {
                color = 8453920;
                fontRendererObj.drawStringWithShadow(cost, frameX + 130 - fontRendererObj.getStringWidth(cost), frameY + 38, color);
            }
        }
    }

    private void drawSlotAsBackground(Slot backgroundSlot, Slot appearSlot) {
        int screenX = appearSlot.xDisplayPosition;
        int screenY = appearSlot.yDisplayPosition;
        ItemStack itemStackToRender = backgroundSlot.getStack();
        this.zLevel = 50.0f;
        GuiTFGoblinCrafting.itemRender.zLevel = 50.0f;
        itemRender.renderItemIntoGUI(this.fontRendererObj, this.mc.renderEngine, itemStackToRender, screenX, screenY);
        itemRender.renderItemOverlayIntoGUI(this.fontRendererObj, this.mc.renderEngine, itemStackToRender, screenX, screenY);
        boolean itemBroken = false;
        if (backgroundSlot.getHasStack() && backgroundSlot.getStack().stackSize == 0) {
            itemBroken = true;
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        Gui.drawRect((int)screenX, (int)screenY, (int)(screenX + 16), (int)(screenY + 16), (int)(itemBroken ? -2130736245 : -1618244725));
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GuiTFGoblinCrafting.itemRender.zLevel = 0.0f;
        this.zLevel = 0.0f;
    }
}

