/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import twilightforest.entity.boss.EntityTFLich;

public class ModelTFLich
extends ModelBiped {
    ModelRenderer collar;
    ModelRenderer cloak;
    ModelRenderer shieldBelt;
    boolean renderPass = false;

    public ModelTFLich() {
        this.textureWidth = 64;
        this.textureHeight = 64;
        this.bipedBody = new ModelRenderer((ModelBase)this, 8, 16);
        this.bipedBody.addBox(-4.0f, 0.0f, -2.0f, 8, 24, 4);
        this.bipedBody.setRotationPoint(0.0f, -4.0f, 0.0f);
        this.bipedBody.setTextureSize(64, 64);
        this.bipedRightArm = new ModelRenderer((ModelBase)this, 0, 16);
        this.bipedRightArm.addBox(-2.0f, -2.0f, -1.0f, 2, 12, 2);
        this.bipedRightArm.setTextureSize(64, 64);
        this.bipedRightArm.setRotationPoint(-5.0f, -2.0f, 0.0f);
        this.bipedLeftArm = new ModelRenderer((ModelBase)this, 0, 16);
        this.bipedLeftArm.mirror = true;
        this.bipedLeftArm.addBox(-2.0f, -2.0f, -1.0f, 2, 12, 2);
        this.bipedLeftArm.setRotationPoint(5.0f, -2.0f, 0.0f);
        this.bipedLeftArm.setTextureSize(64, 64);
        this.bipedHeadwear = new ModelRenderer((ModelBase)this, 32, 0);
        this.bipedHeadwear.addBox(-4.0f, -12.0f, -4.0f, 8, 8, 8, 0.5f);
        this.bipedHeadwear.setRotationPoint(0.0f, -4.0f, 0.0f);
        this.bipedHeadwear.setTextureSize(64, 64);
        this.bipedHead = new ModelRenderer((ModelBase)this, 0, 0);
        this.bipedHead.addBox(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.bipedHead.setRotationPoint(0.0f, -4.0f, 0.0f);
        this.bipedHead.setTextureSize(64, 64);
        this.bipedRightLeg = new ModelRenderer((ModelBase)this, 0, 16);
        this.bipedRightLeg.addBox(-1.0f, 0.0f, -1.0f, 2, 12, 2);
        this.bipedRightLeg.setRotationPoint(-2.0f, 9.5f, 0.0f);
        this.bipedRightLeg.setTextureSize(64, 64);
        this.bipedLeftLeg = new ModelRenderer((ModelBase)this, 0, 16);
        this.bipedLeftLeg.addBox(-1.0f, 0.0f, -1.0f, 2, 12, 2);
        this.bipedLeftLeg.setRotationPoint(2.0f, 9.5f, 0.0f);
        this.bipedLeftLeg.setTextureSize(64, 64);
        this.bipedLeftLeg.mirror = true;
        this.collar = new ModelRenderer((ModelBase)this, 32, 16);
        this.collar.addBox(-6.0f, 0.0f, 0.0f, 12, 12, 1);
        this.collar.setRotationPoint(0.0f, -3.0f, -1.0f);
        this.collar.setTextureSize(64, 64);
        this.setRotation(this.collar, 2.164208f, 0.0f, 0.0f);
        this.cloak = new ModelRenderer((ModelBase)this, 0, 44);
        this.cloak.addBox(-6.0f, 0.0f, 0.0f, 12, 19, 1);
        this.cloak.setRotationPoint(0.0f, -4.0f, 2.5f);
        this.cloak.setTextureSize(64, 64);
        this.setRotation(this.cloak, 0.0f, 0.0f, 0.0f);
        this.shieldBelt = new ModelRenderer((ModelBase)this);
        this.shieldBelt.setRotationPoint(0.0f, 0.0f, 0.0f);
    }

    public ModelTFLich(boolean specialRenderModel) {
        this();
        this.renderPass = specialRenderModel;
    }

    public void render(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        EntityTFLich lich = (EntityTFLich)entity;
        if (!this.renderPass) {
            if (!lich.isShadowClone()) {
                super.render(entity, f, f1, f2, f3, f4, f5 * 1.125f);
                this.collar.render(f5 * 1.125f);
                this.cloak.render(f5 * 1.125f);
            }
        } else if (lich.isShadowClone()) {
            super.render(entity, f, f1, f2, f3, f4, f5 * 1.125f);
        } else if (lich.getShieldStrength() > 0) {
            this.shieldBelt.render(f5 * 1.125f);
        }
    }

    public void setLivingAnimations(EntityLivingBase par1EntityLiving, float par2, float par3, float time) {
        EntityTFLich lich = (EntityTFLich)par1EntityLiving;
        int shields = lich.getShieldStrength();
        if (!lich.isShadowClone() && shields > 0) {
            if (this.shieldBelt.childModels == null || this.shieldBelt.childModels.size() != shields) {
                if (this.shieldBelt.childModels != null) {
                    this.shieldBelt.childModels.clear();
                }
                for (int i = 0; i < shields; ++i) {
                    Vec3 vec = Vec3.createVectorHelper((double)11.0, (double)0.0, (double)0.0);
                    float rotateY = (float)i * (360.0f / (float)shields) * 3.141593f / 180.0f;
                    vec.rotateAroundY(rotateY);
                    ModelRenderer shield = new ModelRenderer((ModelBase)this, 26, 40);
                    shield.addBox(0.5f, -6.0f, -6.0f, 1, 12, 12);
                    shield.setRotationPoint((float)vec.xCoord, (float)vec.yCoord, (float)vec.zCoord);
                    shield.setTextureSize(64, 64);
                    shield.rotateAngleY = rotateY;
                    this.shieldBelt.addChild(shield);
                }
            }
            this.shieldBelt.rotateAngleY = ((float)lich.ticksExisted + time) / 5.0f;
            this.shieldBelt.rotateAngleX = MathHelper.sin((float)(((float)lich.ticksExisted + time) / 5.0f)) / 4.0f;
            this.shieldBelt.rotateAngleZ = MathHelper.cos((float)(((float)lich.ticksExisted + time) / 5.0f)) / 4.0f;
        }
    }

    public void setRotationAngles(float f, float f1, float f2, float f3, float f4, float f5, Entity entity) {
        this.aimedBow = false;
        super.setRotationAngles(f, f1, f2, f3, f4, f5, entity);
        float ogSin = MathHelper.sin((float)(this.onGround * 3.141593f));
        float otherSin = MathHelper.sin((float)((1.0f - (1.0f - this.onGround) * (1.0f - this.onGround)) * 3.141593f));
        this.bipedRightArm.rotateAngleZ = 0.0f;
        this.bipedLeftArm.rotateAngleZ = 0.5f;
        this.bipedRightArm.rotateAngleY = -(0.1f - ogSin * 0.6f);
        this.bipedLeftArm.rotateAngleY = 0.1f - ogSin * 0.6f;
        this.bipedRightArm.rotateAngleX = -1.570796f;
        this.bipedLeftArm.rotateAngleX = -3.141593f;
        this.bipedRightArm.rotateAngleX -= ogSin * 1.2f - otherSin * 0.4f;
        this.bipedLeftArm.rotateAngleX -= ogSin * 1.2f - otherSin * 0.4f;
        this.bipedRightArm.rotateAngleZ += MathHelper.cos((float)(f2 * 0.26f)) * 0.15f + 0.05f;
        this.bipedLeftArm.rotateAngleZ -= MathHelper.cos((float)(f2 * 0.26f)) * 0.15f + 0.05f;
        this.bipedRightArm.rotateAngleX += MathHelper.sin((float)(f2 * 0.167f)) * 0.15f;
        this.bipedLeftArm.rotateAngleX -= MathHelper.sin((float)(f2 * 0.167f)) * 0.15f;
        this.bipedHead.rotationPointY = -4.0f;
        this.bipedHeadwear.rotationPointY = -4.0f;
        this.bipedRightLeg.rotationPointY = 9.5f;
        this.bipedLeftLeg.rotationPointY = 9.5f;
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.rotateAngleX = x;
        model.rotateAngleY = y;
        model.rotateAngleZ = z;
    }
}

