/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public class EntityTFGhastTrapFX
extends EntityFX {
    float reddustParticleScale;
    private double originX;
    private double originY;
    private double originZ;

    public EntityTFGhastTrapFX(World par1World, double par2, double par4, double par6, double par8, double par9, double par10) {
        this(par1World, par2, par4, par6, 3.0f, par8, par9, par10);
    }

    public EntityTFGhastTrapFX(World par1World, double x, double y, double z, float scale, double mx, double my, double mz) {
        super(par1World, x + mx, y + my, z + mz, mx, my, mz);
        this.motionX = mx;
        this.motionY = my;
        this.motionZ = mz;
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        float f4 = (float)Math.random() * 0.4f;
        this.particleGreen = ((float)(Math.random() * (double)0.2f) + 0.8f) * f4;
        this.particleBlue = ((float)(Math.random() * (double)0.2f) + 0.8f) * f4;
        this.particleRed = 1.0f;
        this.particleScale *= 0.75f;
        this.particleScale *= scale;
        this.reddustParticleScale = this.particleScale;
        this.particleMaxAge = (int)(10.0 / (Math.random() * 0.8 + 0.2));
        this.noClip = false;
    }

    public void renderParticle(Tessellator par1Tessellator, float par2, float par3, float par4, float par5, float par6, float par7) {
        float f6 = ((float)this.particleAge + par2) / (float)this.particleMaxAge * 32.0f;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.particleScale = this.reddustParticleScale * f6;
        super.renderParticle(par1Tessellator, par2, par3, par4, par5, par6, par7);
    }

    public void onUpdate() {
        this.setParticleTextureIndex(7 - this.particleAge * 8 / this.particleMaxAge);
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        float proportion = (float)this.particleAge / (float)this.particleMaxAge;
        proportion = 1.0f - proportion;
        this.posX = this.originX + this.motionX * (double)proportion;
        this.posY = this.originY + this.motionY * (double)proportion;
        this.posZ = this.originZ + this.motionZ * (double)proportion;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setDead();
        }
    }
}

