/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;
import twilightforest.world.TFWorld;

public class TFSkyRenderer
extends IRenderHandler {
    private int starGLCallList = GLAllocation.generateDisplayLists((int)3);
    private int glSkyList;
    private int glSkyList2;

    @SideOnly(value=Side.CLIENT)
    public TFSkyRenderer() {
        int var10;
        int var9;
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.renderStars();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator var5 = Tessellator.instance;
        this.glSkyList = this.starGLCallList + 1;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int var7 = 64;
        int var8 = 256 / var7 + 2;
        float var6 = 16.0f;
        for (var9 = -var7 * var8; var9 <= var7 * var8; var9 += var7) {
            for (var10 = -var7 * var8; var10 <= var7 * var8; var10 += var7) {
                var5.startDrawingQuads();
                var5.addVertex((double)(var9 + 0), (double)var6, (double)(var10 + 0));
                var5.addVertex((double)(var9 + var7), (double)var6, (double)(var10 + 0));
                var5.addVertex((double)(var9 + var7), (double)var6, (double)(var10 + var7));
                var5.addVertex((double)(var9 + 0), (double)var6, (double)(var10 + var7));
                var5.draw();
            }
        }
        GL11.glEndList();
        this.glSkyList2 = this.starGLCallList + 2;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        var6 = -16.0f;
        var5.startDrawingQuads();
        for (var9 = -var7 * var8; var9 <= var7 * var8; var9 += var7) {
            for (var10 = -var7 * var8; var10 <= var7 * var8; var10 += var7) {
                var5.addVertex((double)(var9 + var7), (double)var6, (double)(var10 + 0));
                var5.addVertex((double)(var9 + 0), (double)var6, (double)(var10 + 0));
                var5.addVertex((double)(var9 + 0), (double)var6, (double)(var10 + var7));
                var5.addVertex((double)(var9 + var7), (double)var6, (double)(var10 + var7));
            }
        }
        var5.draw();
        GL11.glEndList();
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        float var8;
        GL11.glDisable((int)3553);
        Vec3 var2 = this.getTwilightSkyColor((World)world);
        float var3 = (float)var2.xCoord;
        float var4 = (float)var2.yCoord;
        float var5 = (float)var2.zCoord;
        if (mc.gameSettings.anaglyph) {
            float var6 = (var3 * 30.0f + var4 * 59.0f + var5 * 11.0f) / 100.0f;
            float var7 = (var3 * 30.0f + var4 * 70.0f) / 100.0f;
            var8 = (var3 * 30.0f + var5 * 70.0f) / 100.0f;
            var3 = var6;
            var4 = var7;
            var5 = var8;
        }
        GL11.glColor3f((float)var3, (float)var4, (float)var5);
        Tessellator var23 = Tessellator.instance;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)var3, (float)var4, (float)var5);
        GL11.glCallList((int)this.glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.disableStandardItemLighting();
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glPushMatrix();
        var8 = 1.0f - world.getRainStrength(partialTicks);
        float var9 = 0.0f;
        float var10 = 0.0f;
        float var11 = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)var8);
        GL11.glTranslatef((float)var9, (float)var10, (float)var11);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(this.getRealCelestialAngle((World)world, partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float var12 = 30.0f;
        GL11.glDisable((int)3553);
        float var20 = 1.0f;
        if (var20 > 0.0f) {
            GL11.glColor4f((float)var20, (float)var20, (float)var20, (float)var20);
            GL11.glCallList((int)this.starGLCallList);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        double var25 = mc.thePlayer.getPosition((float)partialTicks).yCoord - (double)TFWorld.SEALEVEL;
        if (var25 < 0.0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)12.0f, (float)0.0f);
            GL11.glCallList((int)this.glSkyList2);
            GL11.glPopMatrix();
            var10 = 1.0f;
            var11 = -((float)(var25 + 65.0));
            var12 = -var10;
            var23.startDrawingQuads();
            var23.setColorRGBA_I(0, 255);
            var23.addVertex((double)(-var10), (double)var11, (double)var10);
            var23.addVertex((double)var10, (double)var11, (double)var10);
            var23.addVertex((double)var10, (double)var12, (double)var10);
            var23.addVertex((double)(-var10), (double)var12, (double)var10);
            var23.addVertex((double)(-var10), (double)var12, (double)(-var10));
            var23.addVertex((double)var10, (double)var12, (double)(-var10));
            var23.addVertex((double)var10, (double)var11, (double)(-var10));
            var23.addVertex((double)(-var10), (double)var11, (double)(-var10));
            var23.addVertex((double)var10, (double)var12, (double)(-var10));
            var23.addVertex((double)var10, (double)var12, (double)var10);
            var23.addVertex((double)var10, (double)var11, (double)var10);
            var23.addVertex((double)var10, (double)var11, (double)(-var10));
            var23.addVertex((double)(-var10), (double)var11, (double)(-var10));
            var23.addVertex((double)(-var10), (double)var11, (double)var10);
            var23.addVertex((double)(-var10), (double)var12, (double)var10);
            var23.addVertex((double)(-var10), (double)var12, (double)(-var10));
            var23.addVertex((double)(-var10), (double)var12, (double)(-var10));
            var23.addVertex((double)(-var10), (double)var12, (double)var10);
            var23.addVertex((double)var10, (double)var12, (double)var10);
            var23.addVertex((double)var10, (double)var12, (double)(-var10));
            var23.draw();
        }
        if (world.provider.isSkyColored()) {
            GL11.glColor3f((float)(var3 * 0.2f + 0.04f), (float)(var4 * 0.2f + 0.04f), (float)(var5 * 0.6f + 0.1f));
        } else {
            GL11.glColor3f((float)var3, (float)var4, (float)var5);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-((float)(var25 - 16.0))), (float)0.0f);
        GL11.glCallList((int)this.glSkyList2);
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    private float getRealCelestialAngle(World world, float partialTicks) {
        int var4 = (int)(world.getWorldTime() % 24000L);
        float var5 = ((float)var4 + partialTicks) / 24000.0f - 0.25f;
        if (var5 < 0.0f) {
            var5 += 1.0f;
        }
        if (var5 > 1.0f) {
            var5 -= 1.0f;
        }
        float var6 = var5;
        var5 = 1.0f - (float)((Math.cos((double)var5 * Math.PI) + 1.0) / 2.0);
        var5 = var6 + (var5 - var6) / 3.0f;
        return var5;
    }

    private Vec3 getTwilightSkyColor(World world) {
        return Vec3.createVectorHelper((double)0.125, (double)0.1328125, (double)0.2890625);
    }

    private void renderStars() {
        Random var1 = new Random(10842L);
        Tessellator var2 = Tessellator.instance;
        var2.startDrawingQuads();
        for (int var3 = 0; var3 < 3000; ++var3) {
            double var4 = var1.nextFloat() * 2.0f - 1.0f;
            double var6 = var1.nextFloat() * 2.0f - 1.0f;
            double var8 = var1.nextFloat() * 2.0f - 1.0f;
            double size = 0.1f + var1.nextFloat() * 0.25f;
            double var12 = var4 * var4 + var6 * var6 + var8 * var8;
            if (!(var12 < 1.0) || !(var12 > 0.01)) continue;
            var12 = 1.0 / Math.sqrt(var12);
            double var14 = (var4 *= var12) * 100.0;
            double var16 = (var6 *= var12) * 100.0;
            double var18 = (var8 *= var12) * 100.0;
            double var20 = Math.atan2(var4, var8);
            double var22 = Math.sin(var20);
            double var24 = Math.cos(var20);
            double var26 = Math.atan2(Math.sqrt(var4 * var4 + var8 * var8), var6);
            double var28 = Math.sin(var26);
            double var30 = Math.cos(var26);
            double var32 = var1.nextDouble() * Math.PI * 2.0;
            double var34 = Math.sin(var32);
            double var36 = Math.cos(var32);
            for (int var38 = 0; var38 < 4; ++var38) {
                double var39 = 0.0;
                double var41 = (double)((var38 & 2) - 1) * size;
                double var43 = (double)((var38 + 1 & 2) - 1) * size;
                double var47 = var41 * var36 - var43 * var34;
                double var49 = var43 * var36 + var41 * var34;
                double var53 = var47 * var28 + var39 * var30;
                double var55 = var39 * var28 - var47 * var30;
                double var57 = var55 * var22 - var49 * var24;
                double var61 = var49 * var22 + var55 * var24;
                var2.addVertex(var14 + var57, var16 + var53, var18 + var61);
            }
        }
        var2.draw();
    }
}

