/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.blocks;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import twilightforest.block.BlockTFCastleMagic;

public class RenderBlockTFCastleMagic
implements ISimpleBlockRenderingHandler {
    private int renderID;

    public RenderBlockTFCastleMagic(int castleMagicBlockRenderID) {
        this.renderID = castleMagicBlockRenderID;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        RenderBlockTFCastleMagic.renderInvBlock(renderer, block, metadata);
    }

    public static void renderInvBlock(RenderBlocks renderblocks, Block block, int meta) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderBlockTFCastleMagic.renderInvBlock(renderblocks, block, meta, tessellator);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        block.setBlockBoundsForItemRender();
    }

    protected static void renderInvBlock(RenderBlocks renderblocks, Block block, int meta, Tessellator tessellator) {
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderblocks.renderFaceYNeg(block, 0.0, 0.0, 0.0, block.getIcon(0, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderblocks.renderFaceYPos(block, 0.0, 0.0, 0.0, block.getIcon(1, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderblocks.renderFaceXPos(block, 0.0, 0.0, 0.0, block.getIcon(2, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderblocks.renderFaceXNeg(block, 0.0, 0.0, 0.0, block.getIcon(3, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderblocks.renderFaceZNeg(block, 0.0, 0.0, 0.0, block.getIcon(4, meta));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderblocks.renderFaceZPos(block, 0.0, 0.0, 0.0, block.getIcon(5, meta));
        tessellator.draw();
        float pixel = 0.0625f;
        IIcon icon = BlockTFCastleMagic.getMagicIconFor(meta, 0, 0);
        int color = BlockTFCastleMagic.getMagicColorFor(meta);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float grn = (float)(color >> 8 & 0xFF) / 255.0f;
        float blu = (float)(color & 0xFF) / 255.0f;
        renderblocks.enableAO = false;
        GL11.glDisable((int)2896);
        tessellator.startDrawingQuads();
        tessellator.setBrightness(0xF000F0);
        tessellator.setColorOpaque_F(red, grn, blu);
        renderblocks.renderFaceYNeg(block, 0.0, (double)(-pixel), 0.0, icon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setBrightness(0xF000F0);
        tessellator.setColorOpaque_F(red, grn, blu);
        renderblocks.renderFaceYPos(block, 0.0, (double)pixel, 0.0, icon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setBrightness(0xF000F0);
        tessellator.setColorOpaque_F(red, grn, blu);
        renderblocks.renderFaceXPos(block, (double)pixel, 0.0, 0.0, icon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setBrightness(0xF000F0);
        tessellator.setColorOpaque_F(red, grn, blu);
        renderblocks.renderFaceXNeg(block, (double)(-pixel), 0.0, 0.0, icon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setBrightness(0xF000F0);
        tessellator.setColorOpaque_F(red, grn, blu);
        renderblocks.renderFaceZNeg(block, 0.0, 0.0, (double)(-pixel), icon);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setBrightness(0xF000F0);
        tessellator.setColorOpaque_F(red, grn, blu);
        renderblocks.renderFaceZPos(block, 0.0, 0.0, (double)pixel, icon);
        tessellator.draw();
        GL11.glEnable((int)2896);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.clearOverrideBlockTexture();
        renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        renderer.renderStandardBlock(block, x, y, z);
        renderer.overrideBlockTexture = BlockTFCastleMagic.getMagicIconFor(x, y, z);
        int meta = world.getBlockMetadata(x, y, z);
        int color = BlockTFCastleMagic.getMagicColorFor(meta);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float grn = (float)(color >> 8 & 0xFF) / 255.0f;
        float blu = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.instance;
        tessellator.setBrightness(0xF000F0);
        tessellator.setColorOpaque_F(red, grn, blu);
        renderer.enableAO = false;
        float pixel = 0.0625f;
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y - 1, z, 0) && world.isAirBlock(x, y - 1, z)) {
            renderer.renderFaceYNeg(block, (double)x, (double)y - (double)pixel, (double)z, renderer.overrideBlockTexture);
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y + 1, z, 1) && world.isAirBlock(x, y + 1, z)) {
            renderer.renderFaceYPos(block, (double)x, (double)y + (double)pixel, (double)z, renderer.overrideBlockTexture);
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y, z - 1, 2) && world.isAirBlock(x, y, z - 1)) {
            renderer.renderFaceZNeg(block, (double)x, (double)y, (double)z - (double)pixel, renderer.overrideBlockTexture);
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x, y, z + 1, 3) && world.isAirBlock(x, y, z + 1)) {
            renderer.renderFaceZPos(block, (double)x, (double)y, (double)z + (double)pixel, renderer.overrideBlockTexture);
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x - 1, y, z, 4) && world.isAirBlock(x - 1, y, z)) {
            renderer.renderFaceXNeg(block, (double)x - (double)pixel, (double)y, (double)z, renderer.overrideBlockTexture);
        }
        if (renderer.renderAllFaces || block.shouldSideBeRendered(world, x + 1, y, z, 5) && world.isAirBlock(x + 1, y, z)) {
            renderer.renderFaceXPos(block, (double)x + (double)pixel, (double)y, (double)z, renderer.overrideBlockTexture);
        }
        renderer.clearOverrideBlockTexture();
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderID;
    }
}

