/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.entity.EntityTFNatureBolt;
import twilightforest.entity.ITFCharger;
import twilightforest.item.TFItems;

public class EntityTFAdherent
extends EntityMob
implements IRangedAttackMob,
ITFCharger {
    private static final int CHARGE_FLAG = 17;

    public EntityTFAdherent(World world) {
        super(world);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 60, 10.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.setSize(0.8f, 2.2f);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)0);
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.25);
    }

    protected void dropFewItems(boolean hitByPlayer, int looting) {
        if (hitByPlayer) {
            ItemStack item = new ItemStack(TFItems.metaItem, 1 + looting, 0);
            int dropCount = this.rand.nextInt(3);
            for (int i = 0; i < dropCount; ++i) {
                this.entityDropItem(item, 1.0f);
            }
        }
    }

    public void onDeath(DamageSource damageSource) {
        super.onDeath(damageSource);
        if (damageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)damageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    public void attackEntityWithRangedAttack(EntityLivingBase attackTarget, float extraDamage) {
        EntityTFNatureBolt natureBolt = new EntityTFNatureBolt(this.worldObj, (EntityLivingBase)this);
        this.worldObj.playSoundAtEntity((Entity)this, "mob.ghast.fireball", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 0.8f));
        natureBolt.setTarget(attackTarget);
        double tx = attackTarget.posX - this.posX;
        double ty = attackTarget.posY + (double)attackTarget.getEyeHeight() - 2.699999988079071 - this.posY;
        double tz = attackTarget.posZ - this.posZ;
        float heightOffset = MathHelper.sqrt_double((double)(tx * tx + tz * tz)) * 0.2f;
        natureBolt.setThrowableHeading(tx, ty + (double)heightOffset, tz, 0.6f, 6.0f);
        this.worldObj.spawnEntityInWorld((Entity)natureBolt);
    }

    @Override
    public boolean isCharging() {
        return this.dataWatcher.getWatchableObjectByte(17) != 0;
    }

    @Override
    public void setCharging(boolean flag) {
        if (flag) {
            this.dataWatcher.updateObject(17, (Object)127);
        } else {
            this.dataWatcher.updateObject(17, (Object)0);
        }
    }
}

