/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.entity.EntityTFGoblinChain;
import twilightforest.entity.EntityTFSpikeBlock;
import twilightforest.item.TFItems;

public class EntityTFBlockGoblin
extends EntityMob
implements IEntityMultiPart {
    private static final float CHAIN_SPEED = 16.0f;
    private static final int DATA_CHAINLENGTH = 17;
    private static final int DATA_CHAINPOS = 18;
    int recoilCounter;
    float chainAngle;
    public EntityTFSpikeBlock block;
    public EntityTFGoblinChain chain1;
    public EntityTFGoblinChain chain2;
    public EntityTFGoblinChain chain3;
    public Entity[] partsArray;

    public EntityTFBlockGoblin(World world) {
        super(world);
        this.setSize(0.9f, 1.4f);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTNTPrimed.class, 2.0f, (double)0.8f, 1.5));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.recoilCounter = 0;
        Entity[] entityArray = new Entity[4];
        this.block = new EntityTFSpikeBlock(this);
        entityArray[0] = this.block;
        this.chain1 = new EntityTFGoblinChain((Entity)this);
        entityArray[1] = this.chain1;
        this.chain2 = new EntityTFGoblinChain((Entity)this);
        entityArray[2] = this.chain2;
        this.chain3 = new EntityTFGoblinChain((Entity)this);
        entityArray[3] = this.chain3;
        this.partsArray = entityArray;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)0);
        this.dataWatcher.addObject(18, (Object)0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.28);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(8.0);
    }

    protected String getLivingSound() {
        return "TwilightForest:mob.redcap.redcap";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.redcap.hurt";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.redcap.die";
    }

    protected Item getDropItemId() {
        return TFItems.armorShard;
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    public double getChainYOffset() {
        return 1.5 - (double)this.getChainLength() / 4.0;
    }

    public Vec3 getChainPosition() {
        return this.getChainPosition(this.getChainAngle(), this.getChainLength());
    }

    public Vec3 getChainPosition(float angle, float distance) {
        double var1 = Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
        double var3 = Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return Vec3.createVectorHelper((double)(this.posX + var1), (double)(this.posY + this.getChainYOffset()), (double)(this.posZ + var3));
    }

    public boolean isSwingingChain() {
        return this.isSwingInProgress || this.getAttackTarget() != null && this.recoilCounter == 0;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        this.swingItem();
        return false;
    }

    public void onUpdate() {
        super.onUpdate();
        this.block.onUpdate();
        this.chain1.onUpdate();
        this.chain2.onUpdate();
        this.chain3.onUpdate();
        if (this.recoilCounter > 0) {
            --this.recoilCounter;
        }
        this.chainAngle += 16.0f;
        this.chainAngle %= 360.0f;
        if (!this.worldObj.isRemote) {
            this.dataWatcher.updateObject(17, (Object)((byte)Math.floor(this.getChainLength() * 127.0f)));
            this.dataWatcher.updateObject(18, (Object)((byte)Math.floor(this.getChainAngle() / 360.0f * 255.0f)));
        } else if (Math.abs(this.chainAngle - this.getChainAngle()) > 32.0f) {
            this.chainAngle = this.getChainAngle();
        }
        Vec3 blockPos = this.getChainPosition();
        this.block.setPosition(blockPos.xCoord, blockPos.yCoord, blockPos.zCoord);
        this.block.rotationYaw = this.getChainAngle();
        double sx = this.posX;
        double sy = this.posY + (double)this.height - 0.1;
        double sz = this.posZ;
        double ox = sx - blockPos.xCoord;
        double oy = sy - blockPos.yCoord - (double)this.block.height / 3.0;
        double oz = sz - blockPos.zCoord;
        this.chain1.setPosition(sx - ox * 0.4, sy - oy * 0.4, sz - oz * 0.4);
        this.chain2.setPosition(sx - ox * 0.5, sy - oy * 0.5, sz - oz * 0.5);
        this.chain3.setPosition(sx - ox * 0.6, sy - oy * 0.6, sz - oz * 0.6);
        if (!this.worldObj.isRemote && this.isSwingingChain()) {
            this.applyBlockCollisions(this.block);
        }
    }

    protected void applyBlockCollisions(Entity collider) {
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity(collider, collider.boundingBox.expand((double)0.2f, 0.0, (double)0.2f));
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (!entity.canBePushed()) continue;
                this.applyBlockCollision(collider, entity);
            }
        }
    }

    protected void applyBlockCollision(Entity collider, Entity collided) {
        if (collided != this) {
            boolean attackSuccess;
            collided.applyEntityCollision(collider);
            if (collided instanceof EntityLivingBase && (attackSuccess = super.attackEntityAsMob(collided))) {
                collided.motionY += (double)0.4f;
                this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
                this.recoilCounter = 40;
            }
        }
    }

    public float getChainAngle() {
        if (!this.worldObj.isRemote) {
            return this.chainAngle;
        }
        return (float)(this.dataWatcher.getWatchableObjectByte(18) & 0xFF) / 255.0f * 360.0f;
    }

    public float getChainLength() {
        if (!this.worldObj.isRemote) {
            if (this.isSwingingChain()) {
                return 0.9f;
            }
            return 0.3f;
        }
        return (float)(this.dataWatcher.getWatchableObjectByte(17) & 0xFF) / 127.0f;
    }

    public World func_82194_d() {
        return this.worldObj;
    }

    public boolean attackEntityFromPart(EntityDragonPart entitydragonpart, DamageSource damagesource, float i) {
        return false;
    }

    public Entity[] getParts() {
        return this.partsArray;
    }

    public int getTotalArmorValue() {
        int i = super.getTotalArmorValue() + 11;
        if (i > 20) {
            i = 20;
        }
        return i;
    }
}

