/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.item.TFItems;

public class EntityTFCharmEffect
extends Entity {
    private static final int DATA_OWNER = 17;
    private static final int DATA_ITEMID = 16;
    private static final double DISTANCE = 1.75;
    private EntityLivingBase orbiting;
    private double newPosX;
    private double newPosY;
    private double newPosZ;
    private double newRotationYaw;
    private double newRotationPitch;
    private int newPosRotationIncrements;
    public float offset;

    public EntityTFCharmEffect(World par1World) {
        super(par1World);
        this.setSize(0.25f, 0.25f);
        this.setItemID(TFItems.charmOfLife1);
    }

    public EntityTFCharmEffect(World par1World, EntityLivingBase par2EntityLiving, Item item) {
        super(par1World);
        this.setSize(0.25f, 0.25f);
        this.orbiting = par2EntityLiving;
        this.setItemID(item);
        Vec3 look = Vec3.createVectorHelper((double)1.75, (double)0.0, (double)0.0);
        this.setLocationAndAngles(par2EntityLiving.posX, par2EntityLiving.posY + (double)par2EntityLiving.getEyeHeight(), par2EntityLiving.posZ, par2EntityLiving.rotationYaw, par2EntityLiving.rotationPitch);
        this.posX += look.xCoord * 1.75;
        this.posZ += look.zCoord * 1.75;
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
    }

    public void onUpdate() {
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        super.onUpdate();
        if (this.newPosRotationIncrements > 0) {
            double var1 = this.posX + (this.newPosX - this.posX) / (double)this.newPosRotationIncrements;
            double var3 = this.posY + (this.newPosY - this.posY) / (double)this.newPosRotationIncrements;
            double var5 = this.posZ + (this.newPosZ - this.posZ) / (double)this.newPosRotationIncrements;
            double var7 = MathHelper.wrapAngleTo180_double((double)(this.newRotationYaw - (double)this.rotationYaw));
            this.rotationYaw = (float)((double)this.rotationYaw + var7 / (double)this.newPosRotationIncrements);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.newRotationPitch - (double)this.rotationPitch) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.setPosition(var1, var3, var5);
            this.setRotation(this.rotationYaw, this.rotationPitch);
        }
        float rotation = (float)this.ticksExisted / 5.0f + this.offset;
        if (this.orbiting == null) {
            this.orbiting = this.getOwner();
        }
        if (this.orbiting != null && !this.worldObj.isRemote) {
            this.setLocationAndAngles(this.orbiting.posX, this.orbiting.posY + (double)this.orbiting.getEyeHeight(), this.orbiting.posZ, this.orbiting.rotationYaw, this.orbiting.rotationPitch);
            Vec3 look = Vec3.createVectorHelper((double)1.75, (double)0.0, (double)0.0);
            look.rotateAroundY(rotation);
            this.posX += look.xCoord;
            this.posZ += look.zCoord;
            this.setPosition(this.posX, this.posY, this.posZ);
        }
        if (this.getItemID() > 0) {
            for (int i = 0; i < 3; ++i) {
                double dx = this.posX + 0.5 * (this.rand.nextDouble() - this.rand.nextDouble());
                double dy = this.posY + 0.5 * (this.rand.nextDouble() - this.rand.nextDouble());
                double dz = this.posZ + 0.5 * (this.rand.nextDouble() - this.rand.nextDouble());
                this.worldObj.spawnParticle("iconcrack_" + this.getItemID(), dx, dy, dz, 0.0, 0.2, 0.0);
            }
        }
        if (this.ticksExisted > 200 || this.orbiting == null || this.orbiting.isDead) {
            this.setDead();
        }
    }

    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.yOffset = 0.0f;
        this.newPosX = par1;
        this.newPosY = par3;
        this.newPosZ = par5;
        this.newRotationYaw = par7;
        this.newRotationPitch = par8;
        this.newPosRotationIncrements = par9;
    }

    protected void entityInit() {
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(17, (Object)"");
    }

    public String getOwnerName() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public void setOwner(String par1Str) {
        this.dataWatcher.updateObject(17, (Object)par1Str);
    }

    public EntityLivingBase getOwner() {
        return this.worldObj.getPlayerEntityByName(this.getOwnerName());
    }

    public int getItemID() {
        return this.dataWatcher.getWatchableObjectInt(16);
    }

    public void setItemID(Item charmOfLife1) {
    }

    protected void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setString("Owner", this.getOwnerName());
        par1NBTTagCompound.setShort("ItemID", (short)this.getItemID());
    }

    protected void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        this.setOwner(par1NBTTagCompound.getString("Owner"));
    }
}

