/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.TFGenericPacketHandler;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.item.ItemTFCubeOfAnnihilation;

public class EntityTFCubeOfAnnihilation
extends EntityThrowable {
    boolean hasHitObstacle = false;

    public EntityTFCubeOfAnnihilation(World par1World) {
        super(par1World);
        this.setSize(1.1f, 1.0f);
        this.isImmuneToFire = true;
    }

    public EntityTFCubeOfAnnihilation(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
        this.setSize(1.0f, 1.0f);
        this.isImmuneToFire = true;
    }

    public EntityTFCubeOfAnnihilation(World par1World, EntityLivingBase par2EntityLiving) {
        super(par1World, par2EntityLiving);
        this.setSize(1.0f, 1.0f);
        this.isImmuneToFire = true;
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (mop.entityHit != null && mop.entityHit instanceof EntityLivingBase && mop.entityHit.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)((EntityPlayer)this.getThrower())), 10.0f)) {
            this.ticksExisted += 60;
        }
        if (!this.worldObj.isAirBlock(mop.blockX, mop.blockY, mop.blockZ) && !this.worldObj.isRemote) {
            this.affectBlocksInAABB(this.boundingBox.expand((double)0.2f, (double)0.2f, (double)0.2f), this.getThrower());
        }
    }

    private boolean affectBlocksInAABB(AxisAlignedBB par1AxisAlignedBB, EntityLivingBase entity) {
        int minX = MathHelper.floor_double((double)par1AxisAlignedBB.minX);
        int minY = MathHelper.floor_double((double)par1AxisAlignedBB.minY);
        int minZ = MathHelper.floor_double((double)par1AxisAlignedBB.minZ);
        int maxX = MathHelper.floor_double((double)par1AxisAlignedBB.maxX);
        int maxY = MathHelper.floor_double((double)par1AxisAlignedBB.maxY);
        int maxZ = MathHelper.floor_double((double)par1AxisAlignedBB.maxZ);
        boolean hitBlock = false;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dy = minY; dy <= maxY; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    Block block = this.worldObj.getBlock(dx, dy, dz);
                    int currentMeta = this.worldObj.getBlockMetadata(dx, dy, dz);
                    if (block == Blocks.air) continue;
                    if (this.canAnnihilate(dx, dy, dz, block, currentMeta)) {
                        this.worldObj.setBlockToAir(dx, dy, dz);
                        this.worldObj.playSoundAtEntity((Entity)this, "random.fizz", 0.125f, this.rand.nextFloat() * 0.25f + 0.75f);
                        this.sendAnnihilateBlockPacket(this.worldObj, dx, dy, dz);
                    } else {
                        this.hasHitObstacle = true;
                    }
                    hitBlock = true;
                }
            }
        }
        return hitBlock;
    }

    private boolean canAnnihilate(int dx, int dy, int dz, Block block, int meta) {
        if (block == TFBlocks.deadrock || block == TFBlocks.castleBlock || block == TFBlocks.castleMagic && meta != 3 || block == TFBlocks.forceField || block == TFBlocks.thorns) {
            return true;
        }
        return block.getExplosionResistance((Entity)this) < 8.0f && block.getBlockHardness(this.worldObj, dx, dy, dz) >= 0.0f;
    }

    private void sendAnnihilateBlockPacket(World world, int x, int y, int z) {
        FMLProxyPacket message = TFGenericPacketHandler.makeAnnihilateBlockPacket(x, y, z);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.provider.dimensionId, (double)x, (double)y, (double)z, 64.0);
        TwilightForestMod.genericChannel.sendToAllAround(message, targetPoint);
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote) {
            float maxSpeed;
            List list;
            if (this.getThrower() == null) {
                this.setDead();
                return;
            }
            if (this.isReturning() && (list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0))).contains(this.getThrower()) && !this.worldObj.isRemote) {
                if (this.getThrower() instanceof EntityPlayer) {
                    ItemTFCubeOfAnnihilation.setCubeAsReturned((EntityPlayer)this.getThrower());
                }
                this.setDead();
            }
            Vec3 destPoint = Vec3.createVectorHelper((double)this.getThrower().posX, (double)(this.getThrower().posY + (double)this.getThrower().getEyeHeight()), (double)this.getThrower().posZ);
            if (!this.isReturning()) {
                Vec3 look = this.getThrower().getLookVec();
                float dist = 16.0f;
                look.xCoord *= (double)dist;
                look.yCoord *= (double)dist;
                look.zCoord *= (double)dist;
                destPoint.xCoord += look.xCoord;
                destPoint.yCoord += look.yCoord;
                destPoint.zCoord += look.zCoord;
            }
            Vec3 velocity = Vec3.createVectorHelper((double)(this.posX - destPoint.xCoord), (double)(this.posY + (double)(this.height / 2.0f) - destPoint.yCoord), (double)(this.posZ - destPoint.zCoord));
            this.motionX -= velocity.xCoord;
            this.motionY -= velocity.yCoord;
            this.motionZ -= velocity.zCoord;
            float currentSpeed = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
            if (currentSpeed > (maxSpeed = 0.5f)) {
                this.motionX /= (double)(currentSpeed / maxSpeed);
                this.motionY /= (double)(currentSpeed / maxSpeed);
                this.motionZ /= (double)(currentSpeed / maxSpeed);
            } else {
                float slow = 0.5f;
                this.motionX *= (double)slow;
                this.motionY *= (double)slow;
                this.motionZ *= (double)slow;
            }
            this.affectBlocksInAABB(this.boundingBox.expand((double)0.2f, (double)0.2f, (double)0.2f), this.getThrower());
        }
    }

    public boolean isReturning() {
        if (this.hasHitObstacle || this.getThrower() == null || !(this.getThrower() instanceof EntityPlayer)) {
            return true;
        }
        EntityPlayer player = (EntityPlayer)this.getThrower();
        return !player.isUsingItem();
    }

    protected float func_70182_d() {
        return 1.5f;
    }
}

