/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.ai.EntityAITFBreathAttack;

public class EntityTFFireBeetle
extends EntityMob
implements IBreathAttacker {
    public static final int BREATH_DURATION = 10;
    public static final int BREATH_DAMAGE = 2;

    public EntityTFFireBeetle(World world) {
        super(world);
        this.setSize(1.1f, 0.75f);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAITFBreathAttack((EntityLiving)this, 1.0f, 5.0f, 30, 0.1f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    public EntityTFFireBeetle(World world, double x, double y, double z) {
        this(world);
        this.setPosition(x, y, z);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(25.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.23);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
    }

    protected String getLivingSound() {
        return null;
    }

    protected String getHurtSound() {
        return "mob.spider.say";
    }

    protected String getDeathSound() {
        return "mob.spider.death";
    }

    protected void func_145780_a(int var1, int var2, int var3, Block var4) {
        this.worldObj.playSoundAtEntity((Entity)this, "mob.spider.step", 0.15f, 1.0f);
    }

    protected Item getDropItem() {
        return Items.gunpowder;
    }

    @Override
    public boolean isBreathing() {
        return this.dataWatcher.getWatchableObjectByte(17) != 0;
    }

    @Override
    public void setBreathing(boolean flag) {
        if (flag) {
            this.dataWatcher.updateObject(17, (Object)127);
        } else {
            this.dataWatcher.updateObject(17, (Object)0);
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.isBreathing()) {
            Vec3 look = this.getLookVec();
            double dist = 0.9;
            double px = this.posX + look.xCoord * dist;
            double py = this.posY + 0.25 + look.yCoord * dist;
            double pz = this.posZ + look.zCoord * dist;
            for (int i = 0; i < 2; ++i) {
                double dx = look.xCoord;
                double dy = look.yCoord;
                double dz = look.zCoord;
                double spread = 5.0 + this.getRNG().nextDouble() * 2.5;
                double velocity = 0.15 + this.getRNG().nextDouble() * 0.15;
                dx += this.getRNG().nextGaussian() * (double)0.0075f * spread;
                dy += this.getRNG().nextGaussian() * (double)0.0075f * spread;
                dz += this.getRNG().nextGaussian() * (double)0.0075f * spread;
                this.worldObj.spawnParticle(this.getFlameParticle(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
            this.playBreathSound();
        }
    }

    public String getFlameParticle() {
        return "flame";
    }

    public void playBreathSound() {
        this.worldObj.playSoundEffect(this.posX + 0.5, this.posY + 0.5, this.posZ + 0.5, "mob.ghast.fireball", this.rand.nextFloat() * 0.5f, this.rand.nextFloat() * 0.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float par1) {
        if (this.isBreathing()) {
            return 0xF000F0;
        }
        return super.getBrightnessForRender(par1);
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    public int getVerticalFaceSpeed() {
        return 500;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 1.1f;
    }

    public float getEyeHeight() {
        return 0.25f;
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public void doBreathAttack(Entity target) {
        if (!target.isImmuneToFire() && target.attackEntityFrom(DamageSource.inFire, 2.0f)) {
            target.setFire(10);
        }
    }
}

