/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFTowerGhast;

public class EntityTFMiniGhast
extends EntityTFTowerGhast {
    public boolean isMinion = false;

    public EntityTFMiniGhast(World par1World) {
        super(par1World);
        this.setSize(1.1f, 1.5f);
        this.aggroRange = 16.0f;
        this.stareRange = 8.0f;
        this.wanderFactor = 4.0f;
    }

    @Override
    public int getMaxSpawnedInChunk() {
        return 16;
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(this.isMinion ? 6.0 : 10.0);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
    }

    @Override
    protected boolean shouldAttackPlayer(EntityPlayer par1EntityPlayer) {
        ItemStack playerHeadArmor = par1EntityPlayer.inventory.armorInventory[3];
        if (playerHeadArmor != null && playerHeadArmor.getItem() == Item.getItemFromBlock((Block)Blocks.pumpkin)) {
            return false;
        }
        if (par1EntityPlayer.getDistanceToEntity((Entity)this) <= 3.5f && par1EntityPlayer.canEntityBeSeen((Entity)this)) {
            return true;
        }
        Vec3 var3 = par1EntityPlayer.getLook(1.0f).normalize();
        Vec3 var4 = Vec3.createVectorHelper((double)(this.posX - par1EntityPlayer.posX), (double)(this.boundingBox.minY + (double)(this.height / 2.0f) - (par1EntityPlayer.posY + (double)par1EntityPlayer.getEyeHeight())), (double)(this.posZ - par1EntityPlayer.posZ));
        double var5 = var4.lengthVector();
        double var7 = var3.dotProduct(var4 = var4.normalize());
        return var7 > 1.0 - 0.025 / var5 ? par1EntityPlayer.canEntityBeSeen((Entity)this) : false;
    }

    @Override
    protected boolean isValidLightLevel() {
        int myZ;
        int myY;
        if (this.isMinion) {
            return true;
        }
        int myX = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.getSavedLightValue(EnumSkyBlock.Sky, myX, myY = MathHelper.floor_double((double)this.boundingBox.minY), myZ = MathHelper.floor_double((double)this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        int lightLevel = this.worldObj.getBlockLightValue(myX, myY, myZ);
        if (this.worldObj.isThundering()) {
            int var5 = this.worldObj.skylightSubtracted;
            this.worldObj.skylightSubtracted = 10;
            lightLevel = this.worldObj.getBlockLightValue(myX, myY, myZ);
            this.worldObj.skylightSubtracted = var5;
        }
        return lightLevel <= this.rand.nextInt(8);
    }

    public void makeBossMinion() {
        this.wanderFactor = 0.005f;
        this.isMinion = true;
        this.setHealth(this.getMaxHealth());
    }

    protected void dropFewItems(boolean par1, int par2) {
        if (!this.isMinion) {
            super.dropFewItems(par1, par2);
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setBoolean("isMinion", this.isMinion);
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        if (nbttagcompound.getBoolean("isMinion")) {
            this.makeBossMinion();
        }
    }
}

