/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.entity.ITFCharger;
import twilightforest.entity.ai.EntityAITFChargeAttack;
import twilightforest.item.TFItems;

public class EntityTFMinotaur
extends EntityMob
implements ITFCharger {
    public EntityTFMinotaur(World par1World) {
        super(par1World);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAITFChargeAttack((EntityCreature)this, 2.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false));
        this.setCurrentItemOrArmor(0, new ItemStack(Items.golden_axe));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.25);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(7.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    @Override
    public boolean isCharging() {
        return this.dataWatcher.getWatchableObjectByte(17) != 0;
    }

    @Override
    public void setCharging(boolean flag) {
        if (flag) {
            this.dataWatcher.updateObject(17, (Object)127);
        } else {
            this.dataWatcher.updateObject(17, (Object)0);
        }
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        boolean success = super.attackEntityAsMob(par1Entity);
        if (success && this.isCharging()) {
            par1Entity.motionY += (double)0.4f;
            this.worldObj.playSoundAtEntity((Entity)this, "mob.irongolem.throw", 1.0f, 1.0f);
        }
        return success;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.isCharging()) {
            this.limbSwingAmount = (float)((double)this.limbSwingAmount + 0.6);
        }
    }

    protected String getLivingSound() {
        return "mob.cow.say";
    }

    protected String getHurtSound() {
        return "mob.cow.hurt";
    }

    protected String getDeathSound() {
        return "mob.cow.hurt";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.worldObj.playSoundAtEntity((Entity)this, "mob.cow.step", 0.15f, 0.8f);
    }

    protected float getSoundPitch() {
        return (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.7f;
    }

    protected Item getDropItem() {
        return TFItems.meefRaw;
    }

    protected void dropFewItems(boolean par1, int par2) {
        int numDrops = this.rand.nextInt(2) + this.rand.nextInt(1 + par2);
        for (int i = 0; i < numDrops; ++i) {
            if (this.isBurning()) {
                this.dropItem(TFItems.meefSteak, 1);
                continue;
            }
            this.dropItem(TFItems.meefRaw, 1);
        }
    }

    protected void dropRareDrop(int par1) {
        this.dropItem(TFItems.mazeMapFocus, 1);
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }
}

