/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFHostileWolf;

public class EntityTFMistWolf
extends EntityTFHostileWolf {
    public EntityTFMistWolf(World world) {
        super(world);
        this.setSize(1.4f, 1.9f);
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
    }

    public int getAttackStrength(Entity par1Entity) {
        return 6;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        int damage = this.getAttackStrength(par1Entity);
        if (par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)damage)) {
            float myBrightness = this.getBrightness(1.0f);
            if (par1Entity instanceof EntityLivingBase && myBrightness < 0.1f) {
                int effectDuration = 0;
                if (this.worldObj.difficultySetting != EnumDifficulty.EASY) {
                    if (this.worldObj.difficultySetting == EnumDifficulty.NORMAL) {
                        effectDuration = 7;
                    } else if (this.worldObj.difficultySetting == EnumDifficulty.HARD) {
                        effectDuration = 15;
                    }
                }
                if (effectDuration > 0) {
                    ((EntityLivingBase)par1Entity).addPotionEffect(new PotionEffect(Potion.blindness.id, effectDuration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    protected float getSoundPitch() {
        return (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.6f;
    }
}

