/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.entity.ai.EntityAITFRedcapLightTNT;
import twilightforest.entity.ai.EntityAITFRedcapShy;

public class EntityTFRedcap
extends EntityMob {
    public static ItemStack heldPick = new ItemStack(Items.iron_pickaxe, 1);
    public static ItemStack heldTNT = new ItemStack(Blocks.tnt, 1);
    public static ItemStack heldFlint = new ItemStack(Items.flint_and_steel, 1);
    private boolean shy;
    private int tntLeft = 0;

    public EntityTFRedcap(World world) {
        super(world);
        this.setSize(0.9f, 1.4f);
        this.shy = true;
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTNTPrimed.class, 2.0f, 1.0, 2.0));
        this.tasks.addTask(2, (EntityAIBase)new EntityAITFRedcapShy(this, 1.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAITFRedcapLightTNT(this, 1.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.setCurrentItemOrArmor(0, heldPick);
        this.setCurrentItemOrArmor(1, new ItemStack((Item)Items.iron_boots));
        this.equipmentDropChances[0] = 0.2f;
        this.equipmentDropChances[1] = 0.2f;
    }

    public EntityTFRedcap(World world, double x, double y, double z) {
        this(world);
        this.setPosition(x, y, z);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.28);
    }

    protected String getLivingSound() {
        return "TwilightForest:mob.redcap.redcap";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.redcap.hurt";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.redcap.die";
    }

    protected Item getDropItem() {
        return Items.coal;
    }

    public boolean isShy() {
        return this.shy && this.recentlyHit <= 0;
    }

    public int getTntLeft() {
        return this.tntLeft;
    }

    public void setTntLeft(int tntLeft) {
        this.tntLeft = tntLeft;
    }

    public ItemStack getPick() {
        return heldPick;
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("TNTLeft", this.getTntLeft());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setTntLeft(par1NBTTagCompound.getInteger("TNTLeft"));
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
            int chunkX = MathHelper.floor_double((double)this.posX) >> 4;
            int chunkZ = MathHelper.floor_double((double)this.posZ) >> 4;
            if (TFFeature.getNearestFeature(chunkX, chunkZ, this.worldObj) == TFFeature.hill1) {
                ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHill1);
            }
        }
    }
}

