/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.entity.EntityTFRedcap;
import twilightforest.entity.ai.EntityAITFRedcapPlantTNT;
import twilightforest.item.TFItems;

public class EntityTFRedcapSapper
extends EntityTFRedcap {
    public EntityTFRedcapSapper(World world) {
        super(world);
        this.tasks.addTask(4, (EntityAIBase)new EntityAITFRedcapPlantTNT(this));
        this.setTntLeft(3);
        this.setCurrentItemOrArmor(1, new ItemStack(TFItems.ironwoodBoots));
        this.setCurrentItemOrArmor(0, new ItemStack(TFItems.ironwoodPick, 1));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
    }

    public int getTotalArmorValue() {
        int var1 = super.getTotalArmorValue() + 2;
        if (var1 > 20) {
            var1 = 20;
        }
        return var1;
    }

    @Override
    public ItemStack getPick() {
        return new ItemStack(TFItems.ironwoodPick);
    }

    @Override
    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
            int chunkX = MathHelper.floor_double((double)this.posX) >> 4;
            int chunkZ = MathHelper.floor_double((double)this.posZ) >> 4;
            if (TFFeature.getNearestFeature(chunkX, chunkZ, this.worldObj) == TFFeature.hill2) {
                ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHill2);
            }
        }
    }
}

