/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.entity.ai.EntityAICubeCenterOnSymbol;
import twilightforest.entity.ai.EntityAICubeMoveToRedstoneSymbols;

public class EntityTFRovingCube
extends EntityMob {
    public boolean hasFoundSymbol = false;
    public int symbolX = 0;
    public int symbolY = 0;
    public int symbolZ = 0;

    public EntityTFRovingCube(World world) {
        super(world);
        this.setSize(1.2f, 2.1f);
        this.tasks.addTask(0, (EntityAIBase)new EntityAICubeMoveToRedstoneSymbols(this, 1.0));
        this.tasks.addTask(1, (EntityAIBase)new EntityAICubeCenterOnSymbol(this, 1.0));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(10.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)0.23f);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(5.0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        for (int i = 0; i < 3; ++i) {
            float px = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.75f;
            float py = this.getEyeHeight() - 0.25f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.75f;
            float pz = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.75f;
            TwilightForestMod.proxy.spawnParticle(this.worldObj, "annihilate", this.lastTickPosX + (double)px, this.lastTickPosY + (double)py, this.lastTickPosZ + (double)pz, 0.0, 0.0, 0.0);
        }
    }
}

