/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.entity.EntityTFNatureBolt;
import twilightforest.item.TFItems;

public class EntityTFSkeletonDruid
extends EntityMob
implements IRangedAttackMob {
    public EntityTFSkeletonDruid(World world) {
        super(world);
        this.tasks.addTask(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 60, 10.0f));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.setCurrentItemOrArmor(0, new ItemStack(Items.golden_hoe));
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.25);
    }

    protected String getLivingSound() {
        return "mob.skeleton.say";
    }

    protected String getHurtSound() {
        return "mob.skeleton.hurt";
    }

    protected String getDeathSound() {
        return "mob.skeleton.death";
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
        this.playSound("mob.skeleton.step", 0.15f, 1.0f);
    }

    protected Item getDropItem() {
        return TFItems.torchberries;
    }

    protected void dropFewItems(boolean par1, int lootingModifier) {
        int i;
        int numberOfItemsToDrop = this.rand.nextInt(3 + lootingModifier);
        for (i = 0; i < numberOfItemsToDrop; ++i) {
            this.dropItem(TFItems.torchberries, 1);
        }
        numberOfItemsToDrop = this.rand.nextInt(3 + lootingModifier);
        for (i = 0; i < numberOfItemsToDrop; ++i) {
            this.dropItem(Items.bone, 1);
        }
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    public void attackEntityWithRangedAttack(EntityLivingBase attackTarget, float extraDamage) {
        EntityTFNatureBolt natureBolt = new EntityTFNatureBolt(this.worldObj, (EntityLivingBase)this);
        this.worldObj.playSoundAtEntity((Entity)this, "mob.ghast.fireball", 1.0f, 1.0f / (this.rand.nextFloat() * 0.4f + 0.8f));
        natureBolt.setTarget(attackTarget);
        double tx = attackTarget.posX - this.posX;
        double ty = attackTarget.posY + (double)attackTarget.getEyeHeight() - 2.699999988079071 - this.posY;
        double tz = attackTarget.posZ - this.posZ;
        float heightOffset = MathHelper.sqrt_double((double)(tx * tx + tz * tz)) * 0.2f;
        natureBolt.setThrowableHeading(tx, ty + (double)heightOffset, tz, 0.6f, 6.0f);
        this.worldObj.spawnEntityInWorld((Entity)natureBolt);
    }

    protected boolean isValidLightLevel() {
        int light;
        int dz;
        int dy;
        boolean valid = false;
        int dx = MathHelper.floor_double((double)this.posX);
        valid = this.worldObj.getSavedLightValue(EnumSkyBlock.Sky, dx, dy = MathHelper.floor_double((double)this.boundingBox.minY), dz = MathHelper.floor_double((double)this.posZ)) > this.rand.nextInt(32) ? false : (light = this.worldObj.getBlockLightValue(dx, dy, dz)) <= this.rand.nextInt(12);
        return valid;
    }
}

