/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.item.TFItems;

public class EntityTFSnowGuardian
extends EntityMob {
    public EntityTFSnowGuardian(World par1World) {
        super(par1World);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.setSize(0.6f, 1.8f);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)0.23f);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(3.0);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(10.0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected String getLivingSound() {
        return "TwilightForest:mob.ice.noise";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.ice.hurt";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.ice.death";
    }

    protected float getSoundPitch() {
        return (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.8f;
    }

    protected void addRandomArmor() {
        int type = this.rand.nextInt(4);
        this.setCurrentItemOrArmor(0, new ItemStack(this.makeItemForSlot(0, type)));
        this.setCurrentItemOrArmor(3, new ItemStack(this.makeItemForSlot(3, type)));
        this.setCurrentItemOrArmor(4, new ItemStack(this.makeItemForSlot(4, type)));
    }

    protected Item makeItemForSlot(int slot, int type) {
        switch (slot) {
            default: {
                switch (type) {
                    default: {
                        return TFItems.ironwoodSword;
                    }
                    case 1: {
                        return TFItems.steeleafSword;
                    }
                    case 2: {
                        return TFItems.knightlySword;
                    }
                    case 3: 
                }
                return TFItems.knightlySword;
            }
            case 1: {
                switch (type) {
                    default: {
                        return TFItems.ironwoodBoots;
                    }
                    case 1: {
                        return TFItems.steeleafBoots;
                    }
                    case 2: {
                        return TFItems.knightlyBoots;
                    }
                    case 3: 
                }
                return TFItems.arcticBoots;
            }
            case 2: {
                switch (type) {
                    default: {
                        return TFItems.ironwoodLegs;
                    }
                    case 1: {
                        return TFItems.steeleafLegs;
                    }
                    case 2: {
                        return TFItems.knightlyLegs;
                    }
                    case 3: 
                }
                return TFItems.arcticLegs;
            }
            case 3: {
                switch (type) {
                    default: {
                        return TFItems.ironwoodPlate;
                    }
                    case 1: {
                        return TFItems.steeleafPlate;
                    }
                    case 2: {
                        return TFItems.knightlyPlate;
                    }
                    case 3: 
                }
                return TFItems.arcticPlate;
            }
            case 4: 
        }
        switch (type) {
            default: {
                return TFItems.ironwoodHelm;
            }
            case 1: {
                return TFItems.steeleafHelm;
            }
            case 2: {
                return TFItems.knightlyHelm;
            }
            case 3: 
        }
        return TFItems.arcticHelm;
    }

    protected Item getDropItem() {
        return Items.snowball;
    }

    protected void enchantEquipment() {
        super.enchantEquipment();
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData par1EntityLivingData) {
        IEntityLivingData data = super.onSpawnWithEgg(par1EntityLivingData);
        this.addRandomArmor();
        return data;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        for (int i = 0; i < 3; ++i) {
            float px = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.3f;
            float py = this.getEyeHeight() + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.5f;
            float pz = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.3f;
            TwilightForestMod.proxy.spawnParticle(this.worldObj, "snowguardian", this.lastTickPosX + (double)px, this.lastTickPosY + (double)py, this.lastTickPosZ + (double)pz, 0.0, 0.0, 0.0);
        }
    }

    public int getMaxSpawnedInChunk() {
        return 8;
    }
}

