/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightforest.TFFeature;

public class EntityTFTowerGhast
extends EntityGhast {
    private static final int AGGRO_STATUS = 16;
    protected EntityLivingBase targetedEntity;
    protected boolean isAggressive;
    protected int aggroCooldown;
    protected int explosionPower;
    protected int aggroCounter;
    protected float aggroRange;
    protected float stareRange;
    protected float wanderFactor;
    protected int inTrapCounter;
    private ChunkCoordinates homePosition = new ChunkCoordinates(0, 0, 0);
    private float maximumHomeDistance = -1.0f;

    public EntityTFTowerGhast(World par1World) {
        super(par1World);
        this.setSize(4.0f, 6.0f);
        this.aggroRange = 64.0f;
        this.stareRange = 32.0f;
        this.wanderFactor = 16.0f;
        this.inTrapCounter = 0;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
    }

    protected float getSoundVolume() {
        return 0.5f;
    }

    public int getTalkInterval() {
        return 160;
    }

    public int getMaxSpawnedInChunk() {
        return 8;
    }

    public void onUpdate() {
        super.onUpdate();
    }

    public int getAttackStatus() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    public void onLivingUpdate() {
        float var1 = this.getBrightness(1.0f);
        if (var1 > 0.5f) {
            this.entityAge += 2;
        }
        if (this.rand.nextBoolean()) {
            this.worldObj.spawnParticle("reddust", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height - 0.25, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, 0.0, 0.0, 0.0);
        }
        super.onLivingUpdate();
    }

    protected void updateEntityActionState() {
        byte newAggroStatus;
        byte currentAggroStatus;
        double targetRange;
        if (!this.worldObj.isRemote && this.worldObj.difficultySetting == EnumDifficulty.PEACEFUL) {
            this.setDead();
        }
        this.despawnEntity();
        this.checkForTowerHome();
        if (this.inTrapCounter > 0) {
            --this.inTrapCounter;
            this.targetedEntity = null;
            return;
        }
        this.prevAttackCounter = this.attackCounter;
        if (this.targetedEntity != null && this.targetedEntity.isDead) {
            this.targetedEntity = null;
        }
        if (this.targetedEntity == null) {
            this.targetedEntity = this.findPlayerInRange();
        } else if (!this.isAggressive && this.targetedEntity instanceof EntityPlayer) {
            this.checkToIncreaseAggro((EntityPlayer)this.targetedEntity);
        }
        double offsetX = this.waypointX - this.posX;
        double offsetY = this.waypointY - this.posY;
        double offsetZ = this.waypointZ - this.posZ;
        double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        if ((distanceDesired < 1.0 || distanceDesired > 3600.0) && this.wanderFactor > 0.0f) {
            this.waypointX = this.posX + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * this.wanderFactor);
            this.waypointY = this.posY + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * this.wanderFactor);
            this.waypointZ = this.posZ + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * this.wanderFactor);
        }
        if (this.targetedEntity == null && this.wanderFactor > 0.0f) {
            if (this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.rand.nextInt(20) + 20;
                distanceDesired = MathHelper.sqrt_double((double)distanceDesired);
                if (!this.isWithinHomeDistance(MathHelper.floor_double((double)this.waypointX), MathHelper.floor_double((double)this.waypointY), MathHelper.floor_double((double)this.waypointZ))) {
                    ChunkCoordinates cc = TFFeature.getNearestCenterXYZ(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posZ), this.worldObj);
                    Vec3 homeVector = Vec3.createVectorHelper((double)((double)cc.posX - this.posX), (double)((double)(cc.posY + 128) - this.posY), (double)((double)cc.posZ - this.posZ));
                    homeVector = homeVector.normalize();
                    this.waypointX = this.posX + homeVector.xCoord * 16.0 + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.waypointY = this.posY + homeVector.yCoord * 16.0 + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
                    this.waypointZ = this.posZ + homeVector.zCoord * 16.0 + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * 16.0f);
                }
                if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, distanceDesired)) {
                    this.motionX += offsetX / distanceDesired * 0.1;
                    this.motionY += offsetY / distanceDesired * 0.1;
                    this.motionZ += offsetZ / distanceDesired * 0.1;
                } else {
                    this.waypointX = this.posX;
                    this.waypointY = this.posY;
                    this.waypointZ = this.posZ;
                }
            }
        } else {
            this.motionX *= 0.75;
            this.motionY *= 0.75;
            this.motionZ *= 0.75;
        }
        double d = targetRange = this.aggroCounter > 0 || this.isAggressive ? (double)this.aggroRange : (double)this.stareRange;
        if (this.targetedEntity != null && this.targetedEntity.getDistanceSqToEntity((Entity)this) < targetRange * targetRange && this.canEntityBeSeen((Entity)this.targetedEntity)) {
            this.faceEntity((Entity)this.targetedEntity, 10.0f, this.getVerticalFaceSpeed());
            if (this.isAggressive) {
                if (this.attackCounter == 10) {
                    this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1007, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
                }
                ++this.attackCounter;
                if (this.attackCounter == 20) {
                    this.spitFireball();
                    this.attackCounter = -40;
                }
            }
        } else {
            this.isAggressive = false;
            this.targetedEntity = null;
            this.renderYawOffset = this.rotationYaw = -((float)Math.atan2(this.motionX, this.motionZ)) * 180.0f / (float)Math.PI;
            this.rotationPitch = 0.0f;
        }
        if (this.attackCounter > 0 && !this.isAggressive) {
            --this.attackCounter;
        }
        if ((currentAggroStatus = this.dataWatcher.getWatchableObjectByte(16)) != (newAggroStatus = (byte)(this.attackCounter > 10 ? 2 : (this.aggroCounter > 0 || this.isAggressive ? 1 : 0)))) {
            this.dataWatcher.updateObject(16, (Object)newAggroStatus);
        }
    }

    public int getVerticalFaceSpeed() {
        return 500;
    }

    protected void spitFireball() {
        double offsetX = this.targetedEntity.posX - this.posX;
        double offsetY = this.targetedEntity.boundingBox.minY + (double)(this.targetedEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
        double offsetZ = this.targetedEntity.posZ - this.posZ;
        this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1008, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
        EntityLargeFireball entityFireball = new EntityLargeFireball(this.worldObj, (EntityLivingBase)this, offsetX, offsetY, offsetZ);
        double shotSpawnDistance = 0.5;
        Vec3 lookVec = this.getLook(1.0f);
        entityFireball.posX = this.posX + lookVec.xCoord * shotSpawnDistance;
        entityFireball.posY = this.posY + (double)(this.height / 2.0f) + lookVec.yCoord * shotSpawnDistance;
        entityFireball.posZ = this.posZ + lookVec.zCoord * shotSpawnDistance;
        this.worldObj.spawnEntityInWorld((Entity)entityFireball);
        if (this.rand.nextInt(6) == 0) {
            this.isAggressive = false;
        }
    }

    protected EntityLivingBase findPlayerInRange() {
        float range;
        EntityPlayer closest = this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, (double)this.aggroRange);
        if (closest != null && ((range = this.getDistanceToEntity((Entity)closest)) < this.stareRange || this.shouldAttackPlayer(closest))) {
            return closest;
        }
        return null;
    }

    protected void checkToIncreaseAggro(EntityPlayer par1EntityPlayer) {
        if (this.shouldAttackPlayer(par1EntityPlayer)) {
            if (this.aggroCounter == 0) {
                this.worldObj.playSoundAtEntity((Entity)this, "mob.ghast.moan", 1.0f, 1.0f);
            }
            if (this.aggroCounter++ >= 20) {
                this.aggroCounter = 0;
                this.isAggressive = true;
            }
        } else {
            this.aggroCounter = 0;
        }
    }

    protected boolean shouldAttackPlayer(EntityPlayer par1EntityPlayer) {
        int dz;
        int dy;
        int dx = MathHelper.floor_double((double)par1EntityPlayer.posX);
        return this.worldObj.canBlockSeeTheSky(dx, dy = MathHelper.floor_double((double)par1EntityPlayer.posY), dz = MathHelper.floor_double((double)par1EntityPlayer.posZ)) && par1EntityPlayer.canEntityBeSeen((Entity)this);
    }

    protected boolean isCourseTraversable(double par1, double par3, double par5, double par7) {
        double var9 = (this.waypointX - this.posX) / par7;
        double var11 = (this.waypointY - this.posY) / par7;
        double var13 = (this.waypointZ - this.posZ) / par7;
        AxisAlignedBB var15 = this.boundingBox.copy();
        int var16 = 1;
        while ((double)var16 < par7) {
            var15.offset(var9, var11, var13);
            if (!this.worldObj.getCollidingBoundingBoxes((Entity)this, var15).isEmpty()) {
                return false;
            }
            ++var16;
        }
        return true;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        boolean wasAttacked = super.attackEntityFrom(par1DamageSource, par2);
        if (wasAttacked && par1DamageSource.getSourceOfDamage() instanceof EntityLivingBase) {
            this.targetedEntity = (EntityLivingBase)par1DamageSource.getSourceOfDamage();
            this.isAggressive = true;
            return true;
        }
        return wasAttacked;
    }

    public boolean getCanSpawnHere() {
        return this.worldObj.checkNoEntityCollision(this.boundingBox) && this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(this.boundingBox) && this.worldObj.difficultySetting != EnumDifficulty.PEACEFUL && this.isValidLightLevel();
    }

    protected boolean isValidLightLevel() {
        return true;
    }

    protected void checkForTowerHome() {
        if (!this.hasHome()) {
            int chunkZ;
            int chunkX = MathHelper.floor_double((double)this.posX) >> 4;
            TFFeature nearFeature = TFFeature.getFeatureForRegion(chunkX, chunkZ = MathHelper.floor_double((double)this.posZ) >> 4, this.worldObj);
            if (nearFeature != TFFeature.darkTower) {
                this.detachHome();
                this.entityAge += 5;
            } else {
                ChunkCoordinates cc = TFFeature.getNearestCenterXYZ(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posZ), this.worldObj);
                this.setHomeArea(cc.posX, cc.posY + 128, cc.posZ, 64);
            }
        }
    }

    public boolean isWithinHomeDistance(int x, int y, int z) {
        if (this.getMaximumHomeDistance() == -1.0f) {
            return true;
        }
        ChunkCoordinates home = this.getHomePosition();
        return y > 64 && y < 210 && home.getDistanceSquared(x, home.posY, z) < this.getMaximumHomeDistance() * this.getMaximumHomeDistance();
    }

    public void setInTrap() {
        this.inTrapCounter = 10;
    }

    public void setHomeArea(int par1, int par2, int par3, int par4) {
        this.homePosition.set(par1, par2, par3);
        this.maximumHomeDistance = par4;
    }

    public ChunkCoordinates getHomePosition() {
        return this.homePosition;
    }

    public float getMaximumHomeDistance() {
        return this.maximumHomeDistance;
    }

    public void detachHome() {
        this.maximumHomeDistance = -1.0f;
    }

    public boolean hasHome() {
        return this.maximumHomeDistance != -1.0f;
    }
}

