/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.ai.EntityAIBase;
import twilightforest.entity.EntityTFRovingCube;

public class EntityAICubeCenterOnSymbol
extends EntityAIBase {
    private EntityTFRovingCube myCube;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private double speed;

    public EntityAICubeCenterOnSymbol(EntityTFRovingCube entityTFRovingCube, double d) {
        this.myCube = entityTFRovingCube;
        this.xPosition = this.myCube.symbolX;
        this.yPosition = this.myCube.symbolY;
        this.zPosition = this.myCube.symbolZ;
        this.speed = d;
    }

    public boolean shouldExecute() {
        this.xPosition = this.myCube.symbolX;
        this.yPosition = this.myCube.symbolY;
        this.zPosition = this.myCube.symbolZ;
        if (!this.myCube.getNavigator().noPath()) {
            return false;
        }
        return this.isCloseToSymbol();
    }

    public boolean continueExecuting() {
        double dist = this.distanceFromSymbol();
        this.myCube.getMoveHelper().setMoveTo(this.xPosition + 0.5, this.yPosition, this.zPosition + 0.5, this.speed);
        return dist > (double)0.1f && this.isCourseTraversable();
    }

    private boolean isCourseTraversable() {
        return this.distanceFromSymbol() < 100.0;
    }

    private boolean isCloseToSymbol() {
        double dist = this.distanceFromSymbol();
        return dist > 0.25 && dist < 10.0;
    }

    public double distanceFromSymbol() {
        double dx = this.xPosition - this.myCube.posX + 0.5;
        double dy = this.yPosition - this.myCube.posY;
        double dz = this.zPosition - this.myCube.posZ + 0.5;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

