/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import twilightforest.entity.EntityTFRovingCube;

public class EntityAICubeMoveToRedstoneSymbols
extends EntityAIBase {
    private EntityTFRovingCube myCube;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private double speed;

    public EntityAICubeMoveToRedstoneSymbols(EntityTFRovingCube entityTFRovingCube, double d) {
        this.myCube = entityTFRovingCube;
        this.speed = d;
    }

    public boolean shouldExecute() {
        if (this.myCube.getRNG().nextInt(20) != 0) {
            return false;
        }
        Vec3 vec3 = this.searchForRedstoneSymbol(this.myCube, 16, 5);
        if (vec3 == null) {
            return false;
        }
        this.xPosition = vec3.xCoord;
        this.yPosition = vec3.yCoord;
        this.zPosition = vec3.zCoord;
        return true;
    }

    public boolean continueExecuting() {
        return !this.myCube.getNavigator().noPath();
    }

    public void startExecuting() {
        this.myCube.getNavigator().tryMoveToXYZ(this.xPosition, this.yPosition, this.zPosition, this.speed);
    }

    private Vec3 searchForRedstoneSymbol(EntityTFRovingCube myCube2, int xzRange, int yRange) {
        int curX = MathHelper.floor_double((double)myCube2.posX);
        int curY = MathHelper.floor_double((double)myCube2.posY);
        int curZ = MathHelper.floor_double((double)myCube2.posZ);
        boolean foundSymbol = false;
        for (int x = curX - xzRange; x < curX + xzRange; ++x) {
            for (int z = curZ - xzRange; z < curZ + xzRange; ++z) {
                for (int y = curY - yRange; y < curY + yRange; ++y) {
                    if (!this.isRedstoneSymbol(x, y, z)) continue;
                    this.myCube.hasFoundSymbol = true;
                    this.myCube.symbolX = x;
                    this.myCube.symbolY = y;
                    this.myCube.symbolZ = z;
                    return Vec3.createVectorHelper((double)x, (double)y, (double)z);
                }
            }
        }
        return null;
    }

    private boolean isRedstoneSymbol(int x, int y, int z) {
        if (!this.myCube.worldObj.blockExists(x, y, z) || !this.myCube.worldObj.isAirBlock(x, y, z)) {
            return false;
        }
        return this.myCube.worldObj.getBlock(x + 1, y, z) == Blocks.redstone_wire && this.myCube.worldObj.getBlock(x - 1, y, z) == Blocks.redstone_wire && this.myCube.worldObj.getBlock(x, y, z + 1) == Blocks.redstone_wire && this.myCube.worldObj.getBlock(x, y, z - 1) == Blocks.redstone_wire && this.myCube.worldObj.getBlock(x + 1, y, z + 1) == Blocks.redstone_wire && this.myCube.worldObj.getBlock(x - 1, y, z + 1) == Blocks.redstone_wire && this.myCube.worldObj.getBlock(x + 1, y, z - 1) == Blocks.redstone_wire && this.myCube.worldObj.getBlock(x - 1, y, z - 1) == Blocks.redstone_wire;
    }
}

