/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import twilightforest.entity.EntityTFRedcap;

public class EntityAITFAvoidFrontalAttack
extends EntityAIBase {
    EntityLivingBase entityTarget;
    EntityLiving me;
    float speed;
    boolean lefty;
    double xPosition;
    double yPosition;
    double zPosition;
    double minDistance = 3.0;
    double maxDistance = 6.0;

    public EntityAITFAvoidFrontalAttack(EntityTFRedcap entityTFRedcap, float moveSpeed) {
        this.me = entityTFRedcap;
        this.speed = moveSpeed;
        this.lefty = this.me.worldObj.rand.nextBoolean();
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        EntityLivingBase attackTarget = this.me.getAttackTarget();
        if (attackTarget == null || (double)attackTarget.getDistanceToEntity((Entity)this.me) > this.maxDistance || (double)attackTarget.getDistanceToEntity((Entity)this.me) < this.minDistance || !this.isTargetLookingAtMe(attackTarget)) {
            return false;
        }
        this.entityTarget = attackTarget;
        Vec3 avoidPos = this.findCirclePoint((Entity)this.me, (Entity)this.entityTarget, 5.0, this.lefty ? 1.0 : -1.0);
        if (avoidPos == null) {
            return false;
        }
        this.xPosition = avoidPos.xCoord;
        this.yPosition = avoidPos.yCoord;
        this.zPosition = avoidPos.zCoord;
        return true;
    }

    public void startExecuting() {
        this.me.getNavigator().tryMoveToXYZ(this.xPosition, this.yPosition, this.zPosition, (double)this.speed);
    }

    public boolean continueExecuting() {
        EntityLivingBase attackTarget = this.me.getAttackTarget();
        if (attackTarget == null) {
            return false;
        }
        if (!this.entityTarget.isEntityAlive()) {
            return false;
        }
        if (this.me.getNavigator().noPath()) {
            return false;
        }
        boolean shouldContinue = (double)attackTarget.getDistanceToEntity((Entity)this.me) < this.maxDistance && (double)attackTarget.getDistanceToEntity((Entity)this.me) > this.minDistance && this.isTargetLookingAtMe(attackTarget);
        return shouldContinue;
    }

    public void updateTask() {
        this.me.getLookHelper().setLookPositionWithEntity((Entity)this.entityTarget, 30.0f, 30.0f);
    }

    public void resetTask() {
        this.entityTarget = null;
        this.me.getNavigator().clearPathEntity();
    }

    protected Vec3 findCirclePoint(Entity circler, Entity toCircle, double radius, double rotation) {
        double vecx = circler.posX - toCircle.posX;
        double vecz = circler.posZ - toCircle.posZ;
        float rangle = (float)Math.atan2(vecz, vecx);
        rangle = (float)((double)rangle + rotation);
        double dx = (double)MathHelper.cos((float)rangle) * radius;
        double dz = (double)MathHelper.sin((float)rangle) * radius;
        return Vec3.createVectorHelper((double)(toCircle.posX + dx), (double)circler.boundingBox.minY, (double)(toCircle.posZ + dz));
    }

    public boolean isTargetLookingAtMe(EntityLivingBase attackTarget) {
        double dz = this.me.posZ - attackTarget.posZ;
        double dx = this.me.posX - attackTarget.posX;
        float angle = (float)(Math.atan2(dz, dx) * 180.0 / 3.1415927410125732) - 90.0f;
        float difference = MathHelper.abs((float)((attackTarget.rotationYaw - angle) % 360.0f));
        return difference < 60.0f || difference > 300.0f;
    }
}

