/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import twilightforest.entity.ITFCharger;

public class EntityAITFChargeAttack
extends EntityAIBase {
    protected static final double MIN_RANGE_SQ = 16.0;
    protected static final double MAX_RANGE_SQ = 64.0;
    protected static final int FREQ = 1;
    protected EntityCreature charger;
    protected EntityLivingBase chargeTarget;
    protected double chargeX;
    protected double chargeY;
    protected double chargeZ;
    protected float speed;
    protected int windup;
    protected boolean hasAttacked;

    public EntityAITFChargeAttack(EntityCreature entityLiving, float f) {
        this.charger = entityLiving;
        this.speed = f;
        this.windup = 0;
        this.hasAttacked = false;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        boolean canSeeTargetFromDest;
        this.chargeTarget = this.charger.getAttackTarget();
        if (this.chargeTarget == null) {
            return false;
        }
        double distance = this.charger.getDistanceSqToEntity((Entity)this.chargeTarget);
        if (distance < 16.0 || distance > 64.0) {
            return false;
        }
        if (!this.charger.onGround) {
            return false;
        }
        Vec3 chargePos = this.findChargePoint((Entity)this.charger, (Entity)this.chargeTarget, 2.1);
        boolean bl = canSeeTargetFromDest = this.chargeTarget.worldObj.rayTraceBlocks(Vec3.createVectorHelper((double)this.chargeTarget.posX, (double)(this.chargeTarget.posY + (double)this.chargeTarget.getEyeHeight()), (double)this.chargeTarget.posZ), chargePos) == null;
        if (chargePos == null || !canSeeTargetFromDest) {
            return false;
        }
        this.chargeX = chargePos.xCoord;
        this.chargeY = chargePos.yCoord;
        this.chargeZ = chargePos.zCoord;
        return this.charger.getRNG().nextInt(1) == 0;
    }

    public void startExecuting() {
        this.windup = 15 + this.charger.getRNG().nextInt(30);
    }

    public boolean continueExecuting() {
        return this.windup > 0 || !this.charger.getNavigator().noPath();
    }

    public void updateTask() {
        this.charger.getLookHelper().setLookPosition(this.chargeX, this.chargeY - 1.0, this.chargeZ, 10.0f, (float)this.charger.getVerticalFaceSpeed());
        if (this.windup > 0) {
            if (--this.windup == 0) {
                this.charger.getNavigator().tryMoveToXYZ(this.chargeX, this.chargeY, this.chargeZ, (double)this.speed);
            } else {
                this.charger.limbSwingAmount = (float)((double)this.charger.limbSwingAmount + 0.8);
                if (this.charger instanceof ITFCharger) {
                    ((ITFCharger)this.charger).setCharging(true);
                }
            }
        }
        double var1 = this.charger.width * 2.1f * this.charger.width * 2.1f;
        if (this.charger.getDistanceSq(this.chargeTarget.posX, this.chargeTarget.boundingBox.minY, this.chargeTarget.posZ) <= var1 && !this.hasAttacked) {
            this.hasAttacked = true;
            this.charger.attackEntityAsMob((Entity)this.chargeTarget);
        }
    }

    public void resetTask() {
        this.windup = 0;
        this.chargeTarget = null;
        this.hasAttacked = false;
        if (this.charger instanceof ITFCharger) {
            ((ITFCharger)this.charger).setCharging(false);
        }
    }

    protected Vec3 findChargePoint(Entity attacker, Entity target, double overshoot) {
        double vecx = target.posX - attacker.posX;
        double vecz = target.posZ - attacker.posZ;
        float rangle = (float)Math.atan2(vecz, vecx);
        double distance = MathHelper.sqrt_double((double)(vecx * vecx + vecz * vecz));
        double dx = (double)MathHelper.cos((float)rangle) * (distance + overshoot);
        double dz = (double)MathHelper.sin((float)rangle) * (distance + overshoot);
        return Vec3.createVectorHelper((double)(attacker.posX + dx), (double)target.posY, (double)(attacker.posZ + dz));
    }
}

