/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.Vec3;

public class EntityAITFFlockToSameKind
extends EntityAIBase {
    private static final double MAX_DIST = 256.0;
    private static final double MIN_DIST = 25.0;
    EntityLiving flockCreature;
    Vec3 flockPosition;
    double speed;
    private int moveTimer;

    public EntityAITFFlockToSameKind(EntityLiving par1EntityLiving, double par2) {
        this.flockCreature = par1EntityLiving;
        this.speed = par2;
    }

    public boolean shouldExecute() {
        if (this.flockCreature.getRNG().nextInt(40) != 0) {
            return false;
        }
        List flockList = this.flockCreature.worldObj.getEntitiesWithinAABB(this.flockCreature.getClass(), this.flockCreature.boundingBox.expand(16.0, 4.0, 16.0));
        int flocknum = 0;
        double flockX = 0.0;
        double flockY = 0.0;
        double flockZ = 0.0;
        for (EntityLiving flocker : flockList) {
            ++flocknum;
            flockX += flocker.posX;
            flockY += flocker.posY;
            flockZ += flocker.posZ;
        }
        if (this.flockCreature.getDistanceSq(flockX /= (double)flocknum, flockY /= (double)flocknum, flockZ /= (double)flocknum) < 25.0) {
            return false;
        }
        this.flockPosition = Vec3.createVectorHelper((double)flockX, (double)flockY, (double)flockZ);
        return true;
    }

    public boolean continueExecuting() {
        if (this.flockPosition == null) {
            return false;
        }
        double distance = this.flockCreature.getDistanceSq(this.flockPosition.xCoord, this.flockPosition.yCoord, this.flockPosition.zCoord);
        return distance >= 25.0 && distance <= 256.0;
    }

    public void startExecuting() {
        this.moveTimer = 0;
    }

    public void resetTask() {
        this.flockPosition = null;
    }

    public void updateTask() {
        if (--this.moveTimer <= 0) {
            this.moveTimer = 10;
            this.flockCreature.getNavigator().tryMoveToXYZ(this.flockPosition.xCoord, this.flockPosition.yCoord, this.flockPosition.zCoord, this.speed);
        }
    }
}

