/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import twilightforest.entity.boss.EntityTFSnowQueen;

public class EntityAITFHoverThenDrop
extends EntityAIBase {
    private static final float HOVER_HEIGHT = 6.0f;
    private static final float HOVER_RADIUS = 0.0f;
    private Class<? extends EntityLivingBase> classTarget;
    private EntityTFSnowQueen attacker;
    private double hoverPosX;
    private double hoverPosY;
    private double hoverPosZ;
    private int hoverTimer;
    private int dropTimer;
    private int maxHoverTime;
    private int maxDropTime;
    private int seekTimer;
    private int maxSeekTime;
    private double dropY;

    public EntityAITFHoverThenDrop(EntityTFSnowQueen entityTFSnowQueen, Class<EntityPlayer> class1, int hoverTime, int dropTime) {
        this.attacker = entityTFSnowQueen;
        this.classTarget = class1;
        this.setMutexBits(3);
        this.maxHoverTime = hoverTime;
        this.maxSeekTime = hoverTime;
        this.maxDropTime = dropTime;
        this.hoverTimer = 0;
    }

    public boolean shouldExecute() {
        EntityLivingBase target = this.attacker.getAttackTarget();
        if (target == null) {
            return false;
        }
        if (!target.isEntityAlive()) {
            return false;
        }
        if (this.classTarget != null && !this.classTarget.isAssignableFrom(target.getClass())) {
            return false;
        }
        return this.attacker.getCurrentPhase() == EntityTFSnowQueen.Phase.DROP;
    }

    public boolean continueExecuting() {
        EntityLivingBase target = this.attacker.getAttackTarget();
        if (target == null || !target.isEntityAlive()) {
            return false;
        }
        if (this.attacker.getCurrentPhase() != EntityTFSnowQueen.Phase.DROP) {
            return false;
        }
        if (this.seekTimer > this.maxSeekTime) {
            return false;
        }
        if (this.attacker.getDistanceSq(this.hoverPosX, this.hoverPosY, this.hoverPosZ) <= 1.0) {
            ++this.hoverTimer;
            return true;
        }
        if (this.dropTimer < this.maxDropTime) {
            return true;
        }
        this.attacker.incrementSuccessfulDrops();
        return false;
    }

    public void startExecuting() {
        EntityLivingBase target = this.attacker.getAttackTarget();
        if (target != null) {
            this.makeNewHoverSpot(target);
        }
    }

    public void resetTask() {
        this.hoverTimer = 0;
        this.dropTimer = 0;
    }

    public void updateTask() {
        if (this.hoverTimer > 0) {
            ++this.hoverTimer;
        } else {
            ++this.seekTimer;
        }
        if (this.hoverTimer < this.maxHoverTime) {
            double offsetX = this.hoverPosX - this.attacker.posX;
            double offsetY = this.hoverPosY - this.attacker.posY;
            double offsetZ = this.hoverPosZ - this.attacker.posZ;
            double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
            distanceDesired = MathHelper.sqrt_double((double)distanceDesired);
            double velX = offsetX / distanceDesired * 0.05;
            double velY = offsetY / distanceDesired * 0.1;
            double velZ = offsetZ / distanceDesired * 0.05;
            this.attacker.addVelocity(velX, velY += (double)0.05f, velZ);
            EntityLivingBase target = this.attacker.getAttackTarget();
            if (target != null) {
                this.attacker.faceEntity((Entity)target, 30.0f, 30.0f);
                this.attacker.getLookHelper().setLookPositionWithEntity((Entity)target, 30.0f, 30.0f);
            }
        } else {
            ++this.dropTimer;
            if (this.attacker.posY > this.dropY) {
                this.attacker.destroyBlocksInAABB(this.attacker.boundingBox.expand(1.0, 0.5, 1.0));
            }
        }
    }

    private void makeNewHoverSpot(EntityLivingBase target) {
        double hx = 0.0;
        double hy = 0.0;
        double hz = 0.0;
        int tries = 100;
        for (int i = 0; !(i >= tries || !this.isPositionOccupied(hx = target.posX + (double)((this.attacker.getRNG().nextFloat() - this.attacker.getRNG().nextFloat()) * 0.0f), hy = target.posY + 6.0, hz = target.posZ + (double)((this.attacker.getRNG().nextFloat() - this.attacker.getRNG().nextFloat()) * 0.0f)) && this.canEntitySee((Entity)this.attacker, hx, hy, hz) && this.canEntitySee((Entity)target, hx, hy, hz)); ++i) {
        }
        if (tries == 99) {
            System.out.println("Found no spots, giving up");
        }
        this.hoverPosX = hx;
        this.hoverPosY = hy;
        this.hoverPosZ = hz;
        this.dropY = target.posY - 1.0;
        this.seekTimer = 0;
    }

    private boolean isPositionOccupied(double hx, double hy, double hz) {
        float radius = this.attacker.width / 2.0f;
        AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox((double)(hx - (double)radius), (double)hy, (double)(hz - (double)radius), (double)(hx + (double)radius), (double)(hy + (double)this.attacker.height), (double)(hz + (double)radius));
        boolean isOccupied = this.attacker.worldObj.getCollidingBoundingBoxes((Entity)this.attacker, aabb).isEmpty();
        return isOccupied;
    }

    protected boolean canEntitySee(Entity entity, double dx, double dy, double dz) {
        return entity.worldObj.rayTraceBlocks(Vec3.createVectorHelper((double)entity.posX, (double)(entity.posY + (double)entity.getEyeHeight()), (double)entity.posZ), Vec3.createVectorHelper((double)dx, (double)dy, (double)dz)) == null;
    }
}

