/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.Vec3;
import twilightforest.entity.EntityTFKobold;

public class EntityAITFPanicOnFlockDeath
extends EntityAIBase {
    private EntityCreature flockCreature;
    private float speed;
    private double fleeX;
    private double fleeY;
    private double fleeZ;
    int fleeTimer;

    public EntityAITFPanicOnFlockDeath(EntityCreature par1EntityCreature, float par2) {
        this.flockCreature = par1EntityCreature;
        this.speed = par2;
        this.setMutexBits(1);
        this.fleeTimer = 0;
    }

    public boolean shouldExecute() {
        boolean yikes = this.fleeTimer > 0;
        List flockList = this.flockCreature.worldObj.getEntitiesWithinAABB(this.flockCreature.getClass(), this.flockCreature.boundingBox.expand(4.0, 2.0, 4.0));
        for (EntityLiving flocker : flockList) {
            if (flocker.deathTime <= 0) continue;
            yikes = true;
            break;
        }
        if (!yikes) {
            return false;
        }
        Vec3 var1 = RandomPositionGenerator.findRandomTarget((EntityCreature)this.flockCreature, (int)5, (int)4);
        if (var1 == null) {
            return false;
        }
        this.fleeX = var1.xCoord;
        this.fleeY = var1.yCoord;
        this.fleeZ = var1.zCoord;
        return true;
    }

    public void startExecuting() {
        this.fleeTimer = 40;
        this.flockCreature.getNavigator().tryMoveToXYZ(this.fleeX, this.fleeY, this.fleeZ, (double)this.speed);
        if (this.flockCreature instanceof EntityTFKobold) {
            ((EntityTFKobold)this.flockCreature).setPanicked(true);
        }
    }

    public boolean continueExecuting() {
        return this.fleeTimer > 0 && !this.flockCreature.getNavigator().noPath();
    }

    public void updateTask() {
        --this.fleeTimer;
    }

    public void resetTask() {
        this.fleeTimer -= 20;
        if (this.flockCreature instanceof EntityTFKobold) {
            ((EntityTFKobold)this.flockCreature).setPanicked(false);
        }
    }
}

