/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import twilightforest.entity.EntityTFRedcap;
import twilightforest.entity.ai.EntityAITFRedcapBase;

public class EntityAITFRedcapShy
extends EntityAITFRedcapBase {
    EntityLivingBase entityTarget;
    float speed;
    boolean lefty;
    double xPosition;
    double yPosition;
    double zPosition;
    double minDistance = 3.0;
    double maxDistance = 6.0;

    public EntityAITFRedcapShy(EntityTFRedcap entityTFRedcap, float moveSpeed) {
        this.entityObj = entityTFRedcap;
        this.speed = moveSpeed;
        this.lefty = new Random().nextBoolean();
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        EntityLivingBase attackTarget = this.entityObj.getAttackTarget();
        if (attackTarget == null || !this.entityObj.isShy() || (double)attackTarget.getDistanceToEntity((Entity)this.entityObj) > this.maxDistance || (double)attackTarget.getDistanceToEntity((Entity)this.entityObj) < this.minDistance || !this.isTargetLookingAtMe(attackTarget)) {
            return false;
        }
        this.entityTarget = attackTarget;
        Vec3 avoidPos = this.findCirclePoint((Entity)this.entityObj, (Entity)this.entityTarget, 5.0, this.lefty ? 1.0 : -1.0);
        if (avoidPos == null) {
            return false;
        }
        this.xPosition = avoidPos.xCoord;
        this.yPosition = avoidPos.yCoord;
        this.zPosition = avoidPos.zCoord;
        return true;
    }

    public void startExecuting() {
        this.entityObj.getNavigator().tryMoveToXYZ(this.xPosition, this.yPosition, this.zPosition, (double)this.speed);
    }

    public boolean continueExecuting() {
        EntityLivingBase attackTarget = this.entityObj.getAttackTarget();
        if (attackTarget == null) {
            return false;
        }
        if (!this.entityTarget.isEntityAlive()) {
            return false;
        }
        if (this.entityObj.getNavigator().noPath()) {
            return false;
        }
        boolean shouldContinue = this.entityObj.isShy() && (double)attackTarget.getDistanceToEntity((Entity)this.entityObj) < this.maxDistance && (double)attackTarget.getDistanceToEntity((Entity)this.entityObj) > this.minDistance && this.isTargetLookingAtMe(attackTarget);
        return shouldContinue;
    }

    public void updateTask() {
        this.entityObj.getLookHelper().setLookPositionWithEntity((Entity)this.entityTarget, 30.0f, 30.0f);
    }

    public void resetTask() {
        this.entityTarget = null;
        this.entityObj.getNavigator().clearPathEntity();
    }

    protected Vec3 findCirclePoint(Entity circler, Entity toCircle, double radius, double rotation) {
        double vecx = circler.posX - toCircle.posX;
        double vecz = circler.posZ - toCircle.posZ;
        float rangle = (float)Math.atan2(vecz, vecx);
        rangle = (float)((double)rangle + rotation);
        double dx = (double)MathHelper.cos((float)rangle) * radius;
        double dz = (double)MathHelper.sin((float)rangle) * radius;
        return Vec3.createVectorHelper((double)(toCircle.posX + dx), (double)circler.boundingBox.minY, (double)(toCircle.posZ + dz));
    }
}

