/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.Vec3;
import twilightforest.TFGenericPacketHandler;
import twilightforest.TwilightForestMod;

public class EntityAITFThrowRider
extends EntityAIBase {
    private EntityCreature theEntityCreature;
    private int throwTimer;

    public EntityAITFThrowRider(EntityCreature par1EntityCreature, float par2) {
        this.theEntityCreature = par1EntityCreature;
        this.setMutexBits(1);
    }

    public boolean shouldExecute() {
        return this.theEntityCreature.riddenByEntity != null && this.theEntityCreature.getRNG().nextInt(5) <= 0;
    }

    public void startExecuting() {
        EntityLivingBase rider = (EntityLivingBase)this.theEntityCreature.riddenByEntity;
        rider.mountEntity(null);
        Vec3 throwVec = this.theEntityCreature.getLookVec();
        throwVec.xCoord *= 2.0;
        throwVec.yCoord *= 2.0;
        throwVec.zCoord *= 2.0;
        throwVec.yCoord = 0.9;
        rider.addVelocity(throwVec.xCoord, throwVec.yCoord, throwVec.zCoord);
        if (rider instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)rider;
            FMLProxyPacket message = TFGenericPacketHandler.makeThrowPlayerPacket((float)throwVec.xCoord, (float)throwVec.yCoord, (float)throwVec.zCoord);
            TwilightForestMod.genericChannel.sendTo(message, player);
        }
        System.out.println("throw!");
        this.throwTimer = 0;
    }

    public boolean continueExecuting() {
        if (this.theEntityCreature.riddenByEntity == null) {
            ++this.throwTimer;
        }
        return this.throwTimer <= 40;
    }
}

