/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import twilightforest.entity.boss.EntityTFYetiAlpha;

public class EntityAITFYetiRampage
extends EntityAIBase {
    private EntityTFYetiAlpha yeti;
    private int currentTimeOut;
    private int currentDuration;
    private int maxTantrumTimeOut;
    private int tantrumDuration;

    public EntityAITFYetiRampage(EntityTFYetiAlpha entityTFYetiAlpha, int timeout, int duration) {
        this.yeti = entityTFYetiAlpha;
        this.currentTimeOut = timeout;
        this.maxTantrumTimeOut = timeout;
        this.tantrumDuration = duration;
        this.setMutexBits(5);
    }

    public boolean shouldExecute() {
        if (this.yeti.getAttackTarget() != null && this.yeti.canRampage()) {
            --this.currentTimeOut;
        }
        return this.currentTimeOut <= 0;
    }

    public void startExecuting() {
        this.currentDuration = this.tantrumDuration;
        this.yeti.setRampaging(true);
    }

    public boolean continueExecuting() {
        return this.currentDuration > 0;
    }

    public void updateTask() {
        --this.currentDuration;
        if (this.yeti.getAttackTarget() != null) {
            this.yeti.getLookHelper().setLookPositionWithEntity((Entity)this.yeti.getAttackTarget(), 10.0f, (float)this.yeti.getVerticalFaceSpeed());
        }
        if (this.yeti.onGround) {
            this.yeti.motionX = 0.0;
            this.yeti.motionZ = 0.0;
            this.yeti.motionY = 0.4f;
        }
        this.yeti.destroyBlocksInAABB(this.yeti.boundingBox.expand(1.0, 2.0, 1.0).offset(0.0, 2.0, 0.0));
        if (this.currentDuration % 20 == 0) {
            this.yeti.makeRandomBlockFall();
        }
        if (this.currentDuration % 40 == 0) {
            this.yeti.makeBlockAboveTargetFall();
        }
        if (this.currentDuration < 40 && this.currentDuration % 10 == 0) {
            this.yeti.makeNearbyBlockFall();
        }
    }

    public void resetTask() {
        this.currentTimeOut = this.maxTantrumTimeOut;
        this.yeti.setRampaging(false);
        this.yeti.setTired(true);
    }
}

