/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.entity.boss.EntityTFHydraHead;
import twilightforest.entity.boss.EntityTFHydraPart;
import twilightforest.entity.boss.HydraHeadContainer;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class EntityTFHydra
extends EntityLiving
implements IBossDisplayData,
IEntityMultiPart,
IMob {
    private static int TICKS_BEFORE_HEALING = 1000;
    private static int HEAD_RESPAWN_TICKS = 100;
    private static int HEAD_MAX_DAMAGE = 120;
    private static float ARMOR_MULTIPLIER = 8.0f;
    private static int MAX_HEALTH = 360;
    private static float HEADS_ACTIVITY_FACTOR = 0.3f;
    private static int SECONDARY_FLAME_CHANCE = 10;
    private static int SECONDARY_MORTAR_CHANCE = 16;
    private static final int DATA_SPAWNHEADS = 17;
    private static final int DATA_BOSSHEALTH = 18;
    public Entity[] partArray;
    public EntityDragonPart body;
    public HydraHeadContainer[] hc;
    public int numHeads = 7;
    public EntityDragonPart leftLeg;
    public EntityDragonPart rightLeg;
    public EntityDragonPart tail;
    Entity currentTarget = null;
    public int ticksSinceDamaged = 0;

    public EntityTFHydra(World world) {
        super(world);
        Entity[] entityArray = new Entity[4];
        this.body = new EntityDragonPart((IEntityMultiPart)this, "body", 4.0f, 4.0f);
        entityArray[0] = this.body;
        this.leftLeg = new EntityDragonPart((IEntityMultiPart)this, "leg", 2.0f, 3.0f);
        entityArray[1] = this.leftLeg;
        this.rightLeg = new EntityDragonPart((IEntityMultiPart)this, "leg", 2.0f, 3.0f);
        entityArray[2] = this.rightLeg;
        this.tail = new EntityDragonPart((IEntityMultiPart)this, "tail", 4.0f, 4.0f);
        entityArray[3] = this.tail;
        this.partArray = entityArray;
        this.hc = new HydraHeadContainer[this.numHeads];
        for (int i = 0; i < this.numHeads; ++i) {
            this.hc[i] = new HydraHeadContainer(this, i, i < 3);
        }
        ArrayList partList = new ArrayList();
        Collections.addAll(partList, this.partArray);
        for (int i = 0; i < this.numHeads; ++i) {
            Collections.addAll(partList, this.hc[i].getNeckArray());
        }
        this.partArray = partList.toArray(this.partArray);
        this.setSize(16.0f, 12.0f);
        this.ignoreFrustumCheck = true;
        this.isImmuneToFire = true;
        this.experienceValue = 511;
        this.setSpawnHeads(true);
    }

    public EntityTFHydra(World world, double x, double y, double z) {
        this(world);
        this.setPosition(x, y, z);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)MAX_HEALTH);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.28);
    }

    public void onLivingUpdate() {
        int i;
        if ((this.hc[0].headEntity == null || this.hc[1].headEntity == null || this.hc[2].headEntity == null) && this.shouldSpawnHeads() && !this.worldObj.isRemote) {
            for (i = 0; i < this.numHeads; ++i) {
                this.hc[i].headEntity = new EntityTFHydraHead(this, "head" + i, 3.0f, 3.0f);
                this.hc[i].headEntity.setPosition(this.posX, this.posY, this.posZ);
                this.worldObj.spawnEntityInWorld((Entity)this.hc[i].headEntity);
            }
            this.setSpawnHeads(false);
        }
        this.body.onUpdate();
        for (i = 0; i < this.numHeads; ++i) {
            this.hc[i].onUpdate();
        }
        if (!this.worldObj.isRemote) {
            this.dataWatcher.updateObject(18, (Object)((int)this.getHealth()));
        } else if (this.getHealth() > 0.0f) {
            this.deathTime = 0;
        }
        if (this.hurtTime > 0) {
            for (i = 0; i < this.numHeads; ++i) {
                this.hc[i].setHurtTime(this.hurtTime);
            }
        }
        ++this.ticksSinceDamaged;
        if (!this.worldObj.isRemote && this.ticksSinceDamaged > TICKS_BEFORE_HEALING && this.ticksSinceDamaged % 5 == 0) {
            this.heal(1.0f);
        }
        this.setDifficultyVariables();
        if (this.newPosRotationIncrements > 0) {
            double var1 = this.posX + (this.newPosX - this.posX) / (double)this.newPosRotationIncrements;
            double var3 = this.posY + (this.newPosY - this.posY) / (double)this.newPosRotationIncrements;
            double var5 = this.posZ + (this.newPosZ - this.posZ) / (double)this.newPosRotationIncrements;
            double var7 = MathHelper.wrapAngleTo180_double((double)(this.newRotationYaw - (double)this.rotationYaw));
            this.rotationYaw = (float)((double)this.rotationYaw + var7 / (double)this.newPosRotationIncrements);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.newRotationPitch - (double)this.rotationPitch) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.setPosition(var1, var3, var5);
            this.setRotation(this.rotationYaw, this.rotationPitch);
        }
        if (Math.abs(this.motionX) < 0.005) {
            this.motionX = 0.0;
        }
        if (Math.abs(this.motionY) < 0.005) {
            this.motionY = 0.0;
        }
        if (Math.abs(this.motionZ) < 0.005) {
            this.motionZ = 0.0;
        }
        this.worldObj.theProfiler.startSection("ai");
        if (this.isMovementBlocked()) {
            this.isJumping = false;
            this.moveStrafing = 0.0f;
            this.moveForward = 0.0f;
            this.randomYawVelocity = 0.0f;
        } else if (this.isClientWorld()) {
            this.worldObj.theProfiler.startSection("oldAi");
            this.updateEntityActionState();
            this.worldObj.theProfiler.endSection();
            this.rotationYawHead = this.rotationYaw;
        }
        this.worldObj.theProfiler.endSection();
        this.worldObj.theProfiler.startSection("jump");
        if (this.isJumping) {
            if (!this.isInWater() && !this.handleLavaMovement()) {
                if (this.onGround) {
                    this.jump();
                }
            } else {
                this.motionY += (double)0.04f;
            }
        }
        this.worldObj.theProfiler.endSection();
        this.worldObj.theProfiler.startSection("travel");
        this.moveStrafing *= 0.98f;
        this.moveForward *= 0.98f;
        this.randomYawVelocity *= 0.9f;
        this.moveEntityWithHeading(this.moveStrafing, this.moveForward);
        this.worldObj.theProfiler.endSection();
        this.body.height = 6.0f;
        this.body.width = 6.0f;
        this.tail.width = 6.0f;
        this.tail.height = 2.0f;
        float angle = (this.renderYawOffset + 180.0f) * 3.141593f / 180.0f;
        double dx = this.posX - (double)MathHelper.sin((float)angle) * 3.0;
        double dy = this.posY + 0.1;
        double dz = this.posZ + (double)MathHelper.cos((float)angle) * 3.0;
        this.body.setPosition(dx, dy, dz);
        dx = this.posX - (double)MathHelper.sin((float)angle) * 10.5;
        dy = this.posY + 0.1;
        dz = this.posZ + (double)MathHelper.cos((float)angle) * 10.5;
        this.tail.setPosition(dx, dy, dz);
        this.worldObj.theProfiler.startSection("push");
        if (!this.worldObj.isRemote && this.hurtTime == 0) {
            this.collideWithEntities(this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.body.boundingBox), (Entity)this.body);
            this.collideWithEntities(this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.tail.boundingBox), (Entity)this.tail);
        }
        this.worldObj.theProfiler.endSection();
        if (!this.worldObj.isRemote) {
            this.destroyBlocksInAABB(this.body.boundingBox);
            this.destroyBlocksInAABB(this.tail.boundingBox);
            for (int i2 = 0; i2 < this.numHeads; ++i2) {
                if (this.hc[i2].headEntity == null || !this.hc[i2].isActive()) continue;
                this.destroyBlocksInAABB(this.hc[i2].headEntity.boundingBox);
            }
            if (this.ticksExisted % 20 == 0 && this.isUnsteadySurfaceBeneath()) {
                this.destroyBlocksInAABB(this.boundingBox.offset(0.0, -1.0, 0.0));
            }
        }
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)0);
        this.dataWatcher.addObject(18, (Object)new Integer(MAX_HEALTH));
    }

    public boolean shouldSpawnHeads() {
        return this.dataWatcher.getWatchableObjectByte(17) != 0;
    }

    public void setSpawnHeads(boolean flag) {
        if (flag) {
            this.dataWatcher.updateObject(17, (Object)127);
        } else {
            this.dataWatcher.updateObject(17, (Object)0);
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setBoolean("SpawnHeads", this.shouldSpawnHeads());
        nbttagcompound.setByte("NumHeads", (byte)this.countActiveHeads());
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setSpawnHeads(nbttagcompound.getBoolean("SpawnHeads"));
        this.activateNumberOfHeads(nbttagcompound.getByte("NumHeads"));
    }

    protected void updateEntityActionState() {
        int i;
        ++this.entityAge;
        this.despawnEntity();
        this.moveStrafing = 0.0f;
        this.moveForward = 0.0f;
        float f = 48.0f;
        for (i = 0; i < this.numHeads; ++i) {
            if (!this.hc[i].isActive() || this.hc[i].getDamageTaken() <= HEAD_MAX_DAMAGE) continue;
            this.hc[i].setNextState(11);
            this.hc[i].endCurrentAction();
            this.hc[i].setRespawnCounter(HEAD_RESPAWN_TICKS);
            int otherHead = this.getRandomDeadHead();
            if (otherHead == -1) continue;
            this.hc[otherHead].setRespawnCounter(HEAD_RESPAWN_TICKS);
        }
        if (this.rand.nextFloat() < 0.7f) {
            EntityPlayer entityplayer1 = this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, (double)f);
            if (entityplayer1 != null) {
                this.currentTarget = entityplayer1;
                this.numTicksToChaseTarget = 100 + this.rand.nextInt(20);
            } else {
                this.randomYawVelocity = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
        }
        if (this.currentTarget != null) {
            this.faceEntity(this.currentTarget, 10.0f, this.getVerticalFaceSpeed());
            for (i = 0; i < this.numHeads; ++i) {
                if (this.isHeadAttacking(this.hc[i]) || this.hc[i].isSecondaryAttacking) continue;
                this.hc[i].setTargetEntity(this.currentTarget);
            }
            if (this.currentTarget.isEntityAlive()) {
                float distance = this.currentTarget.getDistanceToEntity((Entity)this);
                if (this.canEntityBeSeen(this.currentTarget)) {
                    this.attackEntity(this.currentTarget, distance);
                }
            }
            if (this.numTicksToChaseTarget-- <= 0 || this.currentTarget.isDead || this.currentTarget.getDistanceSqToEntity((Entity)this) > (double)(f * f)) {
                this.currentTarget = null;
            }
        } else {
            if (this.rand.nextFloat() < 0.05f) {
                this.randomYawVelocity = (this.rand.nextFloat() - 0.5f) * 20.0f;
            }
            this.rotationYaw += this.randomYawVelocity;
            this.rotationPitch = this.defaultPitch;
            for (i = 0; i < this.numHeads; ++i) {
                if (this.hc[i].currentState != 0) continue;
                this.hc[i].setTargetEntity(null);
            }
        }
        this.secondaryAttacks();
        boolean flag = this.isInWater();
        boolean flag1 = this.handleLavaMovement();
        if (flag || flag1) {
            this.isJumping = this.rand.nextFloat() < 0.8f;
        }
    }

    private void setDifficultyVariables() {
        HEADS_ACTIVITY_FACTOR = this.worldObj.difficultySetting != EnumDifficulty.HARD ? 0.3f : 0.5f;
    }

    private int getRandomDeadHead() {
        for (int i = 0; i < this.numHeads; ++i) {
            if (this.hc[i].currentState != 12 || this.hc[i].respawnCounter != -1) continue;
            return i;
        }
        return -1;
    }

    private void activateNumberOfHeads(int howMany) {
        int moreHeads = howMany - this.countActiveHeads();
        for (int i = 0; i < moreHeads; ++i) {
            int otherHead = this.getRandomDeadHead();
            if (otherHead == -1) continue;
            this.hc[otherHead].currentState = 0;
            this.hc[otherHead].setNextState(0);
            this.hc[otherHead].endCurrentAction();
        }
    }

    private void attackEntity(Entity target, float distance) {
        int i;
        int BITE_CHANCE = 10;
        int FLAME_CHANCE = 100;
        int MORTAR_CHANCE = 160;
        boolean targetAbove = target.boundingBox.minY > this.boundingBox.maxY;
        for (i = 0; i < 3; ++i) {
            if (this.hc[i].currentState != 0 || this.areTooManyHeadsAttacking(target, i)) continue;
            if (distance > 4.0f && distance < 10.0f && this.rand.nextInt(BITE_CHANCE) == 0 && this.countActiveHeads() > 2 && !this.areOtherHeadsBiting(target, i)) {
                this.hc[i].setNextState(1);
                continue;
            }
            if (distance > 0.0f && distance < 20.0f && this.rand.nextInt(FLAME_CHANCE) == 0) {
                this.hc[i].setNextState(5);
                continue;
            }
            if (!(distance > 8.0f) || !(distance < 32.0f) || targetAbove || this.rand.nextInt(MORTAR_CHANCE) != 0) continue;
            this.hc[i].setNextState(8);
        }
        for (i = 3; i < this.numHeads; ++i) {
            if (this.hc[i].currentState != 0 || this.areTooManyHeadsAttacking(target, i)) continue;
            if (distance > 0.0f && distance < 20.0f && this.rand.nextInt(FLAME_CHANCE) == 0) {
                this.hc[i].setNextState(5);
                continue;
            }
            if (!(distance > 8.0f) || !(distance < 32.0f) || targetAbove || this.rand.nextInt(MORTAR_CHANCE) != 0) continue;
            this.hc[i].setNextState(8);
        }
    }

    protected boolean areTooManyHeadsAttacking(Entity target, int testHead) {
        int otherAttacks = 0;
        for (int i = 0; i < this.numHeads; ++i) {
            if (i == testHead || !this.isHeadAttacking(this.hc[i])) continue;
            ++otherAttacks;
            if (!this.isHeadBiting(this.hc[i])) continue;
            otherAttacks += 2;
        }
        return (float)otherAttacks >= 1.0f + (float)this.countActiveHeads() * HEADS_ACTIVITY_FACTOR;
    }

    public int countActiveHeads() {
        int count = 0;
        for (int i = 0; i < this.numHeads; ++i) {
            if (!this.hc[i].isActive()) continue;
            ++count;
        }
        return count;
    }

    private boolean isHeadAttacking(HydraHeadContainer head) {
        return head.currentState == 1 || head.currentState == 2 || head.currentState == 3 || head.currentState == 5 || head.currentState == 6 || head.currentState == 8 || head.currentState == 9;
    }

    protected boolean areOtherHeadsBiting(Entity target, int testHead) {
        for (int i = 0; i < this.numHeads; ++i) {
            if (i == testHead || !this.isHeadBiting(this.hc[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isHeadBiting(HydraHeadContainer head) {
        return head.currentState == 1 || head.currentState == 2 || head.currentState == 3 || head.nextState == 1;
    }

    private void secondaryAttacks() {
        for (int i = 0; i < this.numHeads; ++i) {
            if (this.hc[i].headEntity != null) continue;
            return;
        }
        EntityLivingBase secondaryTarget = this.findSecondaryTarget(20.0);
        if (secondaryTarget != null) {
            float distance = secondaryTarget.getDistanceToEntity((Entity)this);
            for (int i = 1; i < this.numHeads; ++i) {
                if (!this.hc[i].isActive() || this.hc[i].currentState != 0 || !this.isTargetOnThisSide(i, (Entity)secondaryTarget)) continue;
                if (distance > 0.0f && distance < 20.0f && this.rand.nextInt(SECONDARY_FLAME_CHANCE) == 0) {
                    this.hc[i].setTargetEntity((Entity)secondaryTarget);
                    this.hc[i].isSecondaryAttacking = true;
                    this.hc[i].setNextState(5);
                    continue;
                }
                if (!(distance > 8.0f) || !(distance < 32.0f) || this.rand.nextInt(SECONDARY_MORTAR_CHANCE) != 0) continue;
                this.hc[i].setTargetEntity((Entity)secondaryTarget);
                this.hc[i].isSecondaryAttacking = true;
                this.hc[i].setNextState(8);
            }
        }
    }

    public boolean isTargetOnThisSide(int headNum, Entity target) {
        double middleDist;
        double headDist = this.distanceSqXZ((Entity)this.hc[headNum].headEntity, target);
        return headDist < (middleDist = this.distanceSqXZ((Entity)this, target));
    }

    private double distanceSqXZ(Entity headEntity, Entity target) {
        double distX = headEntity.posX - target.posX;
        double distZ = headEntity.posZ - target.posZ;
        return distX * distX + distZ * distZ;
    }

    public EntityLivingBase findSecondaryTarget(double range) {
        double closestRange = -1.0;
        EntityLivingBase closestEntity = null;
        List nearbyEntities = this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(range, range, range));
        for (EntityLivingBase nearbyLiving : nearbyEntities) {
            if (nearbyLiving instanceof EntityTFHydra || nearbyLiving instanceof EntityTFHydraPart || nearbyLiving == this.currentTarget || this.isAnyHeadTargeting((Entity)nearbyLiving) || !this.canEntityBeSeen((Entity)nearbyLiving)) continue;
            double curDist = nearbyLiving.getDistanceSq(this.posX, this.posY, this.posZ);
            if (!(range < 0.0) && !(curDist < range * range) || closestRange != -1.0 && !(curDist < closestRange)) continue;
            closestRange = curDist;
            closestEntity = nearbyLiving;
        }
        return closestEntity;
    }

    boolean isAnyHeadTargeting(Entity targetEntity) {
        for (int i = 0; i < this.numHeads; ++i) {
            if (this.hc[i].targetEntity == null || !this.hc[i].targetEntity.equals((Object)targetEntity)) continue;
            return true;
        }
        return false;
    }

    private void collideWithEntities(List<Entity> par1List, Entity part) {
        double pushPower = 4.0;
        double centerX = (part.boundingBox.minX + part.boundingBox.maxX) / 2.0;
        double centerY = (part.boundingBox.minZ + part.boundingBox.maxZ) / 2.0;
        for (Entity entity : par1List) {
            if (!(entity instanceof EntityLivingBase)) continue;
            double distX = entity.posX - centerX;
            double distZ = entity.posZ - centerY;
            double sqDist = distX * distX + distZ * distZ;
            entity.addVelocity(distX / sqDist * pushPower, (double)0.2f, distZ / sqDist * pushPower);
        }
    }

    private boolean isUnsteadySurfaceBeneath() {
        int minX = MathHelper.floor_double((double)this.boundingBox.minX);
        int minZ = MathHelper.floor_double((double)this.boundingBox.minZ);
        int maxX = MathHelper.floor_double((double)this.boundingBox.maxX);
        int maxZ = MathHelper.floor_double((double)this.boundingBox.maxZ);
        int minY = MathHelper.floor_double((double)this.boundingBox.minY);
        int solid = 0;
        int total = 0;
        int dy = minY - 1;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dz = minZ; dz <= maxZ; ++dz) {
                ++total;
                if (!this.worldObj.getBlock(dx, dy, dz).getMaterial().isSolid()) continue;
                ++solid;
            }
        }
        return (float)solid / (float)total < 0.6f;
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB par1AxisAlignedBB) {
        int minX = MathHelper.floor_double((double)par1AxisAlignedBB.minX);
        int minY = MathHelper.floor_double((double)par1AxisAlignedBB.minY);
        int minZ = MathHelper.floor_double((double)par1AxisAlignedBB.minZ);
        int maxX = MathHelper.floor_double((double)par1AxisAlignedBB.maxX);
        int maxY = MathHelper.floor_double((double)par1AxisAlignedBB.maxY);
        int maxZ = MathHelper.floor_double((double)par1AxisAlignedBB.maxZ);
        boolean wasBlocked = false;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dy = minY; dy <= maxY; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    Block currentID = this.worldObj.getBlock(dx, dy, dz);
                    if (currentID == Blocks.air) continue;
                    int currentMeta = this.worldObj.getBlockMetadata(dx, dy, dz);
                    if (currentID != Blocks.obsidian && currentID != Blocks.end_stone && currentID != Blocks.bedrock) {
                        this.worldObj.setBlock(dx, dy, dz, Blocks.air, 0, 2);
                        this.worldObj.playAuxSFX(2001, dx, dy, dz, Block.getIdFromBlock((Block)currentID) + (currentMeta << 12));
                        continue;
                    }
                    wasBlocked = true;
                }
            }
        }
        return wasBlocked;
    }

    public int getVerticalFaceSpeed() {
        return 500;
    }

    public boolean attackEntityFromPart(EntityDragonPart dragonpart, DamageSource damagesource, float i) {
        double range = this.calculateRange(damagesource);
        if (range > 400.0) {
            return false;
        }
        return this.superAttackFrom(damagesource, Math.round(i / 8.0f));
    }

    protected boolean superAttackFrom(DamageSource par1DamageSource, float par2) {
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    public boolean attackEntityFromPart(EntityTFHydraPart part, DamageSource damagesource, float damageAmount) {
        boolean tookDamage;
        if (!this.worldObj.isRemote && damagesource == DamageSource.inWall && part.getBoundingBox() != null) {
            this.destroyBlocksInAABB(part.getBoundingBox());
        }
        HydraHeadContainer headCon = null;
        for (int i = 0; i < this.numHeads; ++i) {
            if (this.hc[i].headEntity != part) continue;
            headCon = this.hc[i];
        }
        double range = this.calculateRange(damagesource);
        if (range > 400.0) {
            return false;
        }
        if (headCon != null && !headCon.isActive()) {
            return false;
        }
        if (headCon != null && (double)headCon.getCurrentMouthOpen() > 0.5) {
            tookDamage = this.superAttackFrom(damagesource, damageAmount);
            headCon.addDamage(damageAmount);
        } else {
            int armoredDamage = Math.round(damageAmount / ARMOR_MULTIPLIER);
            tookDamage = this.superAttackFrom(damagesource, armoredDamage);
            if (headCon != null) {
                headCon.addDamage(armoredDamage);
            }
        }
        if (tookDamage) {
            this.ticksSinceDamaged = 0;
        }
        return tookDamage;
    }

    protected double calculateRange(DamageSource damagesource) {
        double range = -1.0;
        if (damagesource.getSourceOfDamage() != null) {
            range = this.getDistanceSqToEntity(damagesource.getSourceOfDamage());
        }
        if (damagesource.getEntity() != null) {
            range = this.getDistanceSqToEntity(damagesource.getEntity());
        }
        return range;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        return false;
    }

    public Entity[] getParts() {
        return this.partArray;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canBePushed() {
        return false;
    }

    public void knockBack(Entity entity, float i, double d, double d1) {
    }

    protected String getLivingSound() {
        return "TwilightForest:mob.hydra.growl";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.hydra.hurt";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.hydra.death";
    }

    protected float getSoundVolume() {
        return 2.0f;
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightKillHydra);
        }
        if (!this.worldObj.isRemote && this.worldObj.provider instanceof WorldProviderTwilightForest) {
            int dx = MathHelper.floor_double((double)this.posX);
            int dy = MathHelper.floor_double((double)this.posY);
            int dz = MathHelper.floor_double((double)this.posZ);
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)this.worldObj.provider).getChunkProvider();
            TFFeature nearbyFeature = ((TFWorldChunkManager)this.worldObj.provider.worldChunkMgr).getFeatureAt(dx, dz, this.worldObj);
            if (nearbyFeature == TFFeature.hydraLair) {
                chunkProvider.setStructureConquered(dx, dy, dz, true);
            }
        }
    }

    protected void dropFewItems(boolean par1, int par2) {
        int i;
        int totalDrops = this.rand.nextInt(3 + par2) + 5;
        for (i = 0; i < totalDrops; ++i) {
            this.dropItem(TFItems.hydraChop, 5);
        }
        totalDrops = this.rand.nextInt(4 + par2) + 7;
        for (i = 0; i < totalDrops; ++i) {
            this.dropItem(TFItems.fieryBlood, 1);
        }
        this.dropItem(TFItems.trophy, 1);
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean isBurning() {
        return false;
    }

    protected void onDeathUpdate() {
        int var1;
        int headToDie;
        ++this.deathTime;
        if (this.deathTime == 1) {
            for (int i = 0; i < this.numHeads; ++i) {
                this.hc[i].setRespawnCounter(-1);
                if (!this.hc[i].isActive()) continue;
                this.hc[i].setNextState(0);
                this.hc[i].endCurrentAction();
                this.hc[i].setHurtTime(200);
            }
        }
        if (this.deathTime <= 140 && this.deathTime % 20 == 0 && this.hc[headToDie = this.deathTime / 20 - 1].isActive()) {
            this.hc[headToDie].setNextState(11);
            this.hc[headToDie].endCurrentAction();
        }
        if (this.deathTime == 200) {
            if (!(this.worldObj.isRemote || this.recentlyHit <= 0 && !this.isPlayer() || this.isChild())) {
                int var2;
                for (var1 = this.getExperiencePoints(this.attackingPlayer); var1 > 0; var1 -= var2) {
                    var2 = EntityXPOrb.getXPSplit((int)var1);
                    this.worldObj.spawnEntityInWorld((Entity)new EntityXPOrb(this.worldObj, this.posX, this.posY, this.posZ, var2));
                }
            }
            this.setDead();
        }
        for (var1 = 0; var1 < 20; ++var1) {
            double var8 = this.rand.nextGaussian() * 0.02;
            double var4 = this.rand.nextGaussian() * 0.02;
            double var6 = this.rand.nextGaussian() * 0.02;
            String particle = this.rand.nextInt(2) == 0 ? "largeexplode" : "explode";
            this.worldObj.spawnParticle(particle, this.posX + (double)(this.rand.nextFloat() * this.body.width * 2.0f) - (double)this.body.width, this.posY + (double)(this.rand.nextFloat() * this.body.height), this.posZ + (double)(this.rand.nextFloat() * this.body.width * 2.0f) - (double)this.body.width, var8, var4, var6);
        }
    }

    public World func_82194_d() {
        return this.worldObj;
    }
}

