/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.entity.boss.EntityTFHydra;

public class EntityTFHydraPart
extends EntityLiving {
    public EntityTFHydra hydraObj;

    public EntityTFHydraPart(World world) {
        super(world);
        this.isImmuneToFire = true;
    }

    public EntityTFHydraPart(EntityTFHydra hydra, String s, float f, float f1) {
        super(hydra.worldObj);
        this.setSize(f, f1);
        this.hydraObj = hydra;
        this.setPartName(s);
        this.isImmuneToFire = true;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)"");
    }

    public String getPartName() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public void setPartName(String name) {
        this.dataWatcher.updateObject(17, (Object)name);
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        nbttagcompound.setString("PartName", this.getPartName());
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setPartName(nbttagcompound.getString("PartName"));
    }

    public void onUpdate() {
        if (this.hydraObj != null && this.hydraObj.deathTime > 190) {
            this.setDead();
        }
        if (this.hydraObj == null && this.ticksExisted > 1200) {
            this.setDead();
        }
        super.onEntityUpdate();
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        if (this.newPosRotationIncrements > 0) {
            double var1 = this.posX + (this.newPosX - this.posX) / (double)this.newPosRotationIncrements;
            double var3 = this.posY + (this.newPosY - this.posY) / (double)this.newPosRotationIncrements;
            double var5 = this.posZ + (this.newPosZ - this.posZ) / (double)this.newPosRotationIncrements;
            double var7 = MathHelper.wrapAngleTo180_double((double)(this.newRotationYaw - (double)this.rotationYaw));
            this.rotationYaw = (float)((double)this.rotationYaw + var7 / (double)this.newPosRotationIncrements);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.newRotationPitch - (double)this.rotationPitch) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.setPosition(var1, var3, var5);
            this.setRotation(this.rotationYaw, this.rotationPitch);
        }
        this.rotationYawHead = this.rotationYaw;
        this.prevRotationYawHead = this.prevRotationYaw;
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset < -180.0f) {
            this.prevRenderYawOffset -= 360.0f;
        }
        while (this.renderYawOffset - this.prevRenderYawOffset >= 180.0f) {
            this.prevRenderYawOffset += 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYawHead - this.prevRotationYawHead < -180.0f) {
            this.prevRotationYawHead -= 360.0f;
        }
        while (this.rotationYawHead - this.prevRotationYawHead >= 180.0f) {
            this.prevRotationYawHead += 360.0f;
        }
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(1000.0);
    }

    public boolean attackEntityFrom(DamageSource damagesource, float i) {
        if (this.hydraObj != null) {
            return this.hydraObj.attackEntityFromPart(this, damagesource, i);
        }
        return false;
    }

    public boolean isEntityEqual(Entity entity) {
        return this == entity || this.hydraObj == entity;
    }

    protected void setRotation(float par1, float par2) {
        this.rotationYaw = par1 % 360.0f;
        this.rotationPitch = par2 % 360.0f;
    }
}

