/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TFTreasure;
import twilightforest.entity.boss.EntityTFThrownAxe;
import twilightforest.entity.boss.EntityTFThrownPick;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class EntityTFKnightPhantom
extends EntityFlying
implements IMob {
    private static final float CIRCLE_SMALL_RADIUS = 2.5f;
    private static final float CIRCLE_LARGE_RADIUS = 8.5f;
    private static final int FLAG_CHARGING = 17;
    int number;
    int ticksProgress;
    Formation currentFormation;
    private ChunkCoordinates homePosition = new ChunkCoordinates(0, 0, 0);
    private float maximumHomeDistance = -1.0f;
    private int chargePosX;
    private int chargePosY;
    private int chargePosZ;

    public EntityTFKnightPhantom(World par1World) {
        super(par1World);
        this.setSize(1.5f, 3.0f);
        this.noClip = true;
        this.isImmuneToFire = true;
        this.currentFormation = Formation.HOVER;
        this.experienceValue = 93;
        this.setCurrentItemOrArmor(0, new ItemStack(TFItems.knightlySword));
        this.setCurrentItemOrArmor(3, new ItemStack(TFItems.phantomPlate));
        this.setCurrentItemOrArmor(4, new ItemStack(TFItems.phantomHelm));
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(17, (Object)0);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(35.0);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(1.0);
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        if (par1DamageSource == DamageSource.inWall) {
            return false;
        }
        return super.attackEntityFrom(par1DamageSource, par2);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.isChargingAtPlayer()) {
            for (int i = 0; i < 4; ++i) {
                Item particleID = this.rand.nextBoolean() ? TFItems.phantomHelm : TFItems.knightlySword;
                this.worldObj.spawnParticle("iconcrack_" + Item.getIdFromItem((Item)particleID), this.posX + ((double)(this.rand.nextFloat() * this.rand.nextFloat()) - 0.5) * (double)this.width, this.posY + (double)this.rand.nextFloat() * ((double)this.height - 0.75) + 0.5, this.posZ + ((double)(this.rand.nextFloat() * this.rand.nextFloat()) - 0.5) * (double)this.width, 0.0, -0.1, 0.0);
                this.worldObj.spawnParticle("smoke", this.posX + ((double)(this.rand.nextFloat() * this.rand.nextFloat()) - 0.5) * (double)this.width, this.posY + (double)this.rand.nextFloat() * ((double)this.height - 0.75) + 0.5, this.posZ + ((double)(this.rand.nextFloat() * this.rand.nextFloat()) - 0.5) * (double)this.width, 0.0, 0.1, 0.0);
            }
        }
    }

    protected void onDeathUpdate() {
        super.onDeathUpdate();
        for (int i = 0; i < 20; ++i) {
            double d0 = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            this.worldObj.spawnParticle("explode", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d0, d1, d2);
        }
    }

    public void onDeath(DamageSource damageSource) {
        List<EntityTFKnightPhantom> nearbyKnights;
        super.onDeath(damageSource);
        if (damageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)damageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
            ((EntityPlayer)damageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightProgressKnights);
        }
        if (!this.worldObj.isRemote && this.worldObj.provider instanceof WorldProviderTwilightForest) {
            int dx = this.getHomePosition().posX;
            int dy = this.getHomePosition().posY;
            int dz = this.getHomePosition().posZ;
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)this.worldObj.provider).getChunkProvider();
            TFFeature nearbyFeature = ((TFWorldChunkManager)this.worldObj.provider.worldChunkMgr).getFeatureAt(dx, dz, this.worldObj);
            if (nearbyFeature == TFFeature.tfStronghold) {
                chunkProvider.setStructureConquered(dx, dy, dz, true);
            }
        }
        if (!this.worldObj.isRemote && (nearbyKnights = this.getNearbyKnights()).size() <= 1) {
            this.makeATreasure();
        }
    }

    private void makeATreasure() {
        if (this.getHomePosition().posX != 0) {
            TFTreasure.stronghold_boss.generate(this.worldObj, null, this.getHomePosition().posX, this.getHomePosition().posY - 1, this.getHomePosition().posZ);
        } else {
            int px = MathHelper.floor_double((double)this.lastTickPosX);
            int py = MathHelper.floor_double((double)this.lastTickPosY);
            int pz = MathHelper.floor_double((double)this.lastTickPosZ);
            TFTreasure.stronghold_boss.generate(this.worldObj, null, px, py, pz);
        }
    }

    protected void updateEntityActionState() {
        float seekRange;
        EntityPlayer target;
        if (!this.worldObj.isRemote && this.worldObj.difficultySetting == EnumDifficulty.PEACEFUL) {
            this.setDead();
        }
        this.despawnEntity();
        this.noClip = this.ticksProgress % 20 != 0;
        ++this.ticksProgress;
        if (this.ticksProgress >= this.getMaxTicksForFormation()) {
            this.switchToNextFormation();
        }
        if ((target = this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, (double)(seekRange = this.isChargingAtPlayer() ? 24.0f : 9.0f))) != null && this.currentFormation == Formation.ATTACK_PLAYER_START) {
            int targetZ;
            int targetY;
            int targetX = MathHelper.floor_double((double)target.lastTickPosX);
            if (this.isWithinHomeArea(targetX, targetY = MathHelper.floor_double((double)target.lastTickPosY), targetZ = MathHelper.floor_double((double)target.lastTickPosZ))) {
                this.chargePosX = targetX;
                this.chargePosY = targetY;
                this.chargePosZ = targetZ;
            } else {
                this.chargePosX = this.getHomePosition().posX;
                this.chargePosY = this.getHomePosition().posY;
                this.chargePosZ = this.getHomePosition().posZ;
            }
        }
        Vec3 dest = this.getDestination();
        double moveX = dest.xCoord - this.posX;
        double moveY = dest.yCoord - this.posY;
        double moveZ = dest.zCoord - this.posZ;
        double factor = moveX * moveX + moveY * moveY + moveZ * moveZ;
        factor = MathHelper.sqrt_double((double)factor);
        double speed = 0.1;
        this.motionX += moveX / factor * speed;
        this.motionY += moveY / factor * speed;
        this.motionZ += moveZ / factor * speed;
        if (target != null) {
            this.faceEntity((Entity)target, 10.0f, 500.0f);
            if (target.isEntityAlive()) {
                float f1 = target.getDistanceToEntity((Entity)this);
                if (this.canEntityBeSeen((Entity)target)) {
                    this.attackEntity((Entity)target, f1);
                }
            }
            if (this.isAxeKnight() && this.currentFormation == Formation.ATTACK_PLAYER_ATTACK && this.ticksProgress % 4 == 0) {
                this.launchAxeAt((Entity)target);
            }
            if (this.isPickKnight() && this.currentFormation == Formation.ATTACK_PLAYER_ATTACK && this.ticksProgress % 4 == 0) {
                this.launchPicks();
            }
        }
    }

    protected void attackEntity(Entity par1Entity, float par2) {
        if (this.attackTime <= 0 && par2 < 2.0f && par1Entity.boundingBox.maxY > this.boundingBox.minY && par1Entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            this.attackEntityAsMob(par1Entity);
        }
    }

    public boolean attackEntityAsMob(Entity entity) {
        boolean flag;
        float f = this.getAttackDamage();
        int i = 0;
        if (entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)entity));
        }
        if (flag = entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                entity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this)) > 0) {
                entity.setFire(j * 4);
            }
        }
        return flag;
    }

    private float getAttackDamage() {
        float damage = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        if (this.isChargingAtPlayer()) {
            damage += 7.0f;
        }
        return damage;
    }

    protected void launchAxeAt(Entity targetedEntity) {
        float bodyFacingAngle = this.renderYawOffset * 3.141593f / 180.0f;
        double sx = this.posX + (double)(MathHelper.cos((float)bodyFacingAngle) * 1.0f);
        double sy = this.posY + (double)this.height * 0.82;
        double sz = this.posZ + (double)(MathHelper.sin((float)bodyFacingAngle) * 1.0f);
        double tx = targetedEntity.posX - sx;
        double ty = targetedEntity.boundingBox.minY + (double)(targetedEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
        double tz = targetedEntity.posZ - sz;
        this.worldObj.playSoundAtEntity((Entity)this, "random.bow", this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.4f);
        EntityTFThrownAxe projectile = new EntityTFThrownAxe(this.worldObj, (EntityLivingBase)this);
        float speed = 0.75f;
        projectile.setThrowableHeading(tx, ty, tz, speed, 1.0f);
        projectile.setLocationAndAngles(sx, sy, sz, this.rotationYaw, this.rotationPitch);
        this.worldObj.spawnEntityInWorld((Entity)projectile);
    }

    protected void launchPicks() {
        this.worldObj.playSoundAtEntity((Entity)this, "random.bow", this.getSoundVolume(), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.4f);
        for (int i = 0; i < 8; ++i) {
            float throwAngle = (float)i * 3.1415915f / 4.0f;
            double sx = this.posX + (double)(MathHelper.cos((float)throwAngle) * 1.0f);
            double sy = this.posY + (double)this.height * 0.82;
            double sz = this.posZ + (double)(MathHelper.sin((float)throwAngle) * 1.0f);
            double vx = MathHelper.cos((float)throwAngle);
            double vy = 0.0;
            double vz = MathHelper.sin((float)throwAngle);
            EntityTFThrownPick projectile = new EntityTFThrownPick(this.worldObj, (EntityLivingBase)this);
            projectile.setLocationAndAngles(sx, sy, sz, (float)i * 45.0f, this.rotationPitch);
            float speed = 0.5f;
            projectile.setThrowableHeading(vx, vy, vz, speed, 1.0f);
            this.worldObj.spawnEntityInWorld((Entity)projectile);
        }
    }

    public boolean canBePushed() {
        return true;
    }

    public void knockBack(Entity entity, float damage, double par3, double par5) {
        this.isAirBorne = true;
        float f = MathHelper.sqrt_double((double)(par3 * par3 + par5 * par5));
        float distance = 0.2f;
        this.motionX /= 2.0;
        this.motionY /= 2.0;
        this.motionZ /= 2.0;
        this.motionX -= par3 / (double)f * (double)distance;
        this.motionY += (double)distance;
        this.motionZ -= par5 / (double)f * (double)distance;
        if (this.motionY > (double)0.4f) {
            this.motionY = 0.4f;
        }
    }

    public void switchToNextFormation() {
        List<EntityTFKnightPhantom> nearbyKnights = this.getNearbyKnights();
        if (this.currentFormation == Formation.ATTACK_PLAYER_START) {
            this.switchToFormation(Formation.ATTACK_PLAYER_ATTACK);
        } else if (this.currentFormation == Formation.ATTACK_PLAYER_ATTACK) {
            if (nearbyKnights.size() > 1) {
                this.switchToFormation(Formation.WAITING_FOR_LEADER);
            } else {
                switch (this.rand.nextInt(3)) {
                    case 0: {
                        this.setCurrentItemOrArmor(0, new ItemStack(TFItems.knightlySword));
                        break;
                    }
                    case 1: {
                        this.setCurrentItemOrArmor(0, new ItemStack(TFItems.knightlyAxe));
                        break;
                    }
                    case 2: {
                        this.setCurrentItemOrArmor(0, new ItemStack(TFItems.knightlyPick));
                    }
                }
                this.switchToFormation(Formation.ATTACK_PLAYER_START);
            }
        } else if (this.currentFormation == Formation.WAITING_FOR_LEADER) {
            if (nearbyKnights.size() > 1) {
                this.switchToFormation(nearbyKnights.get((int)1).currentFormation);
                this.ticksProgress = nearbyKnights.get((int)1).ticksProgress;
            } else {
                this.switchToFormation(Formation.ATTACK_PLAYER_START);
            }
        } else if (this.isThisTheLeader(nearbyKnights)) {
            this.pickRandomFormation();
            this.broadcastMyFormation(nearbyKnights);
            if (this.isNobodyCharging(nearbyKnights)) {
                this.makeARandomKnightCharge(nearbyKnights);
            }
        }
    }

    private List<EntityTFKnightPhantom> getNearbyKnights() {
        List nearbyKnights = this.worldObj.getEntitiesWithinAABB(EntityTFKnightPhantom.class, AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)).expand(32.0, 8.0, 32.0));
        return nearbyKnights;
    }

    protected void pickRandomFormation() {
        switch (this.rand.nextInt(8)) {
            case 0: {
                this.currentFormation = Formation.SMALL_CLOCKWISE;
                break;
            }
            case 1: {
                this.currentFormation = Formation.SMALL_ANTICLOCKWISE;
                break;
            }
            case 2: {
                this.currentFormation = Formation.SMALL_ANTICLOCKWISE;
                break;
            }
            case 3: {
                this.currentFormation = Formation.CHARGE_PLUSX;
                break;
            }
            case 4: {
                this.currentFormation = Formation.CHARGE_MINUSX;
                break;
            }
            case 5: {
                this.currentFormation = Formation.CHARGE_PLUSZ;
                break;
            }
            case 6: {
                this.currentFormation = Formation.CHARGE_MINUSZ;
                break;
            }
            case 7: {
                this.currentFormation = Formation.SMALL_CLOCKWISE;
            }
        }
        this.switchToFormation(this.currentFormation);
    }

    private boolean isThisTheLeader(List<EntityTFKnightPhantom> nearbyKnights) {
        boolean iAmTheLowest = true;
        for (EntityTFKnightPhantom knight : nearbyKnights) {
            if (knight.getNumber() >= this.getNumber()) continue;
            iAmTheLowest = false;
            break;
        }
        return iAmTheLowest;
    }

    private boolean isNobodyCharging(List<EntityTFKnightPhantom> nearbyKnights) {
        boolean noCharge = true;
        for (EntityTFKnightPhantom knight : nearbyKnights) {
            if (!knight.isChargingAtPlayer()) continue;
            noCharge = false;
            break;
        }
        return noCharge;
    }

    private void makeARandomKnightCharge(List<EntityTFKnightPhantom> nearbyKnights) {
        int randomNum = this.rand.nextInt(nearbyKnights.size());
        nearbyKnights.get(randomNum).switchToFormation(Formation.ATTACK_PLAYER_START);
    }

    private void broadcastMyFormation(List<EntityTFKnightPhantom> nearbyKnights) {
        for (EntityTFKnightPhantom knight : nearbyKnights) {
            if (knight.isChargingAtPlayer()) continue;
            knight.switchToFormation(this.currentFormation);
        }
    }

    public boolean isChargingAtPlayer() {
        return this.dataWatcher.getWatchableObjectByte(17) != 0;
    }

    public void setChargingAtPlayer(boolean flag) {
        if (flag) {
            this.dataWatcher.updateObject(17, (Object)127);
        } else {
            this.dataWatcher.updateObject(17, (Object)0);
        }
    }

    protected String getLivingSound() {
        return "TwilightForest:mob.wraith.wraith";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.wraith.wraith";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.wraith.wraith";
    }

    private void switchToFormationByNumber(int formationNumber) {
        this.currentFormation = Formation.values()[formationNumber];
        this.ticksProgress = 0;
    }

    public void switchToFormation(Formation formation) {
        this.currentFormation = formation;
        this.ticksProgress = 0;
        this.setChargingAtPlayer(this.currentFormation == Formation.ATTACK_PLAYER_START || this.currentFormation == Formation.ATTACK_PLAYER_ATTACK);
    }

    public int getFormationAsNumber() {
        return this.currentFormation.ordinal();
    }

    public int getTicksProgress() {
        return this.ticksProgress;
    }

    public void setTicksProgress(int ticksProgress) {
        this.ticksProgress = ticksProgress;
    }

    public int getMaxTicksForFormation() {
        switch (this.currentFormation) {
            default: {
                return 90;
            }
            case LARGE_CLOCKWISE: {
                return 180;
            }
            case SMALL_CLOCKWISE: {
                return 90;
            }
            case LARGE_ANTICLOCKWISE: {
                return 180;
            }
            case SMALL_ANTICLOCKWISE: {
                return 90;
            }
            case CHARGE_PLUSX: 
            case CHARGE_MINUSX: 
            case CHARGE_PLUSZ: 
            case CHARGE_MINUSZ: {
                return 180;
            }
            case ATTACK_PLAYER_START: 
            case ATTACK_PLAYER_ATTACK: {
                return 50;
            }
            case WAITING_FOR_LEADER: 
        }
        return 10;
    }

    private Vec3 getDestination() {
        switch (this.currentFormation) {
            case LARGE_CLOCKWISE: {
                return this.getCirclePosition(8.5f, true);
            }
            case SMALL_CLOCKWISE: {
                return this.getCirclePosition(2.5f, true);
            }
            case LARGE_ANTICLOCKWISE: {
                return this.getCirclePosition(8.5f, false);
            }
            case SMALL_ANTICLOCKWISE: {
                return this.getCirclePosition(2.5f, false);
            }
            case CHARGE_PLUSX: {
                return this.getMoveAcrossPosition(true, true);
            }
            case CHARGE_MINUSX: {
                return this.getMoveAcrossPosition(false, true);
            }
            case CHARGE_PLUSZ: {
                return this.getMoveAcrossPosition(true, false);
            }
            case HOVER: 
            case ATTACK_PLAYER_START: {
                return this.getHoverPosition(8.5f);
            }
            case CHARGE_MINUSZ: {
                return this.getMoveAcrossPosition(false, false);
            }
            case WAITING_FOR_LEADER: {
                return this.getLoiterPosition();
            }
            case ATTACK_PLAYER_ATTACK: {
                return this.getAttackPlayerPosition();
            }
        }
        return this.getLoiterPosition();
    }

    private Vec3 getMoveAcrossPosition(boolean plus, boolean alongX) {
        float offset0 = (float)this.getNumber() * 3.0f - 7.5f;
        float offset1 = this.ticksProgress < 60 ? -7.0f : -7.0f + (float)(this.ticksProgress - 60) / 120.0f * 14.0f;
        if (!plus) {
            offset1 *= -1.0f;
        }
        double dx = (float)this.getHomePosition().posX + (alongX ? offset0 : offset1);
        double dy = (double)this.getHomePosition().posY + Math.cos((float)this.ticksProgress / 7.0f + (float)this.getNumber());
        double dz = (float)this.getHomePosition().posZ + (alongX ? offset1 : offset0);
        return Vec3.createVectorHelper((double)dx, (double)dy, (double)dz);
    }

    protected Vec3 getCirclePosition(float distance, boolean clockwise) {
        float angle = (float)this.ticksProgress * 2.0f;
        if (!clockwise) {
            angle *= -1.0f;
        }
        double dx = (double)this.getHomePosition().posX + Math.cos((double)(angle += 60.0f * (float)this.getNumber()) * Math.PI / 180.0) * (double)distance;
        double dy = (double)this.getHomePosition().posY + Math.cos((float)this.ticksProgress / 7.0f + (float)this.getNumber());
        double dz = (double)this.getHomePosition().posZ + Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return Vec3.createVectorHelper((double)dx, (double)dy, (double)dz);
    }

    private Vec3 getHoverPosition(float distance) {
        double dx = this.lastTickPosX;
        double dy = (double)this.getHomePosition().posY + Math.cos((float)this.ticksProgress / 7.0f + (float)this.getNumber());
        double ox = (double)this.getHomePosition().posX - dx;
        double dz = this.lastTickPosZ;
        double oz = (double)this.getHomePosition().posZ - dz;
        double dDist = Math.sqrt(ox * ox + oz * oz);
        if (dDist > (double)distance) {
            dx = (double)this.getHomePosition().posX + ox / dDist * (double)distance;
            dz = (double)this.getHomePosition().posZ + oz / dDist * (double)distance;
        }
        return Vec3.createVectorHelper((double)dx, (double)dy, (double)dz);
    }

    private Vec3 getLoiterPosition() {
        double dx = this.getHomePosition().posX;
        double dy = (double)this.getHomePosition().posY + Math.cos((float)this.ticksProgress / 7.0f + (float)this.getNumber());
        double dz = this.getHomePosition().posZ;
        return Vec3.createVectorHelper((double)dx, (double)dy, (double)dz);
    }

    private Vec3 getAttackPlayerPosition() {
        if (this.isSwordKnight()) {
            return Vec3.createVectorHelper((double)this.chargePosX, (double)this.chargePosY, (double)this.chargePosZ);
        }
        return this.getHoverPosition(8.5f);
    }

    public boolean isSwordKnight() {
        return this.getEquipmentInSlot(0) != null && this.getEquipmentInSlot(0).getItem() == TFItems.knightlySword;
    }

    public boolean isAxeKnight() {
        return this.getEquipmentInSlot(0) != null && this.getEquipmentInSlot(0).getItem() == TFItems.knightlyAxe;
    }

    public boolean isPickKnight() {
        return this.getEquipmentInSlot(0) != null && this.getEquipmentInSlot(0).getItem() == TFItems.knightlyPick;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        switch (number % 3) {
            case 0: {
                this.setCurrentItemOrArmor(0, new ItemStack(TFItems.knightlySword));
                break;
            }
            case 1: {
                this.setCurrentItemOrArmor(0, new ItemStack(TFItems.knightlyAxe));
                break;
            }
            case 2: {
                this.setCurrentItemOrArmor(0, new ItemStack(TFItems.knightlyPick));
            }
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
        ChunkCoordinates home = this.getHomePosition();
        nbttagcompound.setTag("Home", (NBTBase)this.newDoubleNBTList(new double[]{home.posX, home.posY, home.posZ}));
        nbttagcompound.setBoolean("HasHome", this.hasHome());
        nbttagcompound.setInteger("MyNumber", this.getNumber());
        nbttagcompound.setInteger("Formation", this.getFormationAsNumber());
        nbttagcompound.setInteger("TicksProgress", this.getTicksProgress());
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("Home", 9)) {
            NBTTagList nbttaglist = nbttagcompound.getTagList("Home", 6);
            int hx = (int)nbttaglist.func_150309_d(0);
            int hy = (int)nbttaglist.func_150309_d(1);
            int hz = (int)nbttaglist.func_150309_d(2);
            this.setHomeArea(hx, hy, hz, 20);
        }
        if (!nbttagcompound.getBoolean("HasHome")) {
            this.detachHome();
        }
        this.setNumber(nbttagcompound.getInteger("MyNumber"));
        this.switchToFormationByNumber(nbttagcompound.getInteger("Formation"));
        this.setTicksProgress(nbttagcompound.getInteger("TicksProgress"));
    }

    public boolean isWithinHomeArea(int par1, int par2, int par3) {
        return this.maximumHomeDistance == -1.0f ? true : this.homePosition.getDistanceSquared(par1, par2, par3) < this.maximumHomeDistance * this.maximumHomeDistance;
    }

    public void setHomeArea(int par1, int par2, int par3, int par4) {
        this.homePosition.set(par1, par2, par3);
        this.maximumHomeDistance = par4;
    }

    public ChunkCoordinates getHomePosition() {
        return this.homePosition;
    }

    public float getMaximumHomeDistance() {
        return this.maximumHomeDistance;
    }

    public void detachHome() {
        this.maximumHomeDistance = -1.0f;
    }

    public boolean hasHome() {
        return this.maximumHomeDistance != -1.0f;
    }

    public static enum Formation {
        HOVER,
        LARGE_CLOCKWISE,
        SMALL_CLOCKWISE,
        LARGE_ANTICLOCKWISE,
        SMALL_ANTICLOCKWISE,
        CHARGE_PLUSX,
        CHARGE_MINUSX,
        CHARGE_PLUSZ,
        CHARGE_MINUSZ,
        WAITING_FOR_LEADER,
        ATTACK_PLAYER_START,
        ATTACK_PLAYER_ATTACK;

    }
}

