/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.entity.boss.EntityTFLich;
import twilightforest.entity.boss.EntityTFLichBomb;

public class EntityTFLichBolt
extends EntityThrowable {
    public EntityLivingBase playerReflects = null;

    public EntityTFLichBolt(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
    }

    public EntityTFLichBolt(World par1World, EntityLivingBase par2EntityLiving) {
        super(par1World, par2EntityLiving);
    }

    public EntityTFLichBolt(World par1World) {
        super(par1World);
    }

    protected float func_70182_d() {
        return 0.5f;
    }

    public void onUpdate() {
        super.onUpdate();
        this.makeTrail();
    }

    public void makeTrail() {
        for (int i = 0; i < 5; ++i) {
            double dx = this.posX + 0.5 * (this.rand.nextDouble() - this.rand.nextDouble());
            double dy = this.posY + 0.5 * (this.rand.nextDouble() - this.rand.nextDouble());
            double dz = this.posZ + 0.5 * (this.rand.nextDouble() - this.rand.nextDouble());
            double s1 = (this.rand.nextFloat() * 0.5f + 0.5f) * 0.17f;
            double s2 = (this.rand.nextFloat() * 0.5f + 0.5f) * 0.8f;
            double s3 = (this.rand.nextFloat() * 0.5f + 0.5f) * 0.69f;
            this.worldObj.spawnParticle("mobSpell", dx, dy, dz, s1, s2, s3);
        }
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public float getCollisionBorderSize() {
        return 1.0f;
    }

    public boolean attackEntityFrom(DamageSource damagesource, float i) {
        this.setBeenAttacked();
        if (damagesource.getEntity() != null) {
            Vec3 vec3d = damagesource.getEntity().getLookVec();
            if (vec3d != null) {
                this.setThrowableHeading(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord, 1.5f, 0.1f);
            }
            if (damagesource.getEntity() instanceof EntityLivingBase) {
                this.playerReflects = (EntityLivingBase)damagesource.getEntity();
            }
            return true;
        }
        return false;
    }

    public EntityLivingBase getThrower() {
        if (this.playerReflects != null) {
            return this.playerReflects;
        }
        return super.getThrower();
    }

    protected float getGravityVelocity() {
        return 0.001f;
    }

    protected void onImpact(MovingObjectPosition par1MovingObjectPosition) {
        boolean passThrough = false;
        if (par1MovingObjectPosition.entityHit != null && (par1MovingObjectPosition.entityHit instanceof EntityTFLichBolt || par1MovingObjectPosition.entityHit instanceof EntityTFLichBomb)) {
            passThrough = true;
        }
        if (par1MovingObjectPosition.entityHit != null && par1MovingObjectPosition.entityHit instanceof EntityLivingBase) {
            EntityTFLich lich;
            if (par1MovingObjectPosition.entityHit instanceof EntityTFLich && (lich = (EntityTFLich)par1MovingObjectPosition.entityHit).isShadowClone()) {
                passThrough = true;
            }
            if (passThrough || par1MovingObjectPosition.entityHit.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)this, (Entity)this.getThrower()), 6.0f)) {
                // empty if block
            }
        }
        if (!passThrough) {
            for (int i = 0; i < 8; ++i) {
                this.worldObj.spawnParticle("iconcrack_" + Item.getIdFromItem((Item)Items.ender_pearl), this.posX, this.posY, this.posZ, this.rand.nextGaussian() * 0.05, this.rand.nextDouble() * 0.2, this.rand.nextGaussian() * 0.05);
            }
            if (!this.worldObj.isRemote) {
                this.setDead();
            }
        }
    }
}

