/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.entity.boss.EntityTFNagaSegment;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class EntityTFNaga
extends EntityMob
implements IMob,
IBossDisplayData,
IEntityMultiPart {
    private static int TICKS_BEFORE_HEALING = 600;
    private static int MAX_SEGMENTS = 12;
    int currentSegments = 0;
    float segmentHealth;
    int LEASH_X = 46;
    int LEASH_Y = 7;
    int LEASH_Z = 46;
    EntityTFNagaSegment[] body;
    protected PathEntity pathToEntity;
    protected Entity targetEntity;
    int circleCount;
    int intimidateTimer;
    int crumblePlayerTimer;
    int chargeCount;
    boolean clockwise;
    public int ticksSinceDamaged = 0;

    public EntityTFNaga(World world) {
        super(world);
        this.setSize(1.75f, 3.0f);
        this.stepHeight = 2.0f;
        this.setHealth(this.getMaxHealth());
        this.segmentHealth = this.getMaxHealth() / 10.0f;
        this.setSegmentsPerHealth();
        this.experienceValue = 217;
        this.ignoreFrustumCheck = true;
        this.circleCount = 15;
        this.body = new EntityTFNagaSegment[MAX_SEGMENTS];
        for (int i = 0; i < this.body.length; ++i) {
            this.body[i] = new EntityTFNagaSegment(this, i);
            world.spawnEntityInWorld((Entity)this.body[i]);
        }
        this.goNormal();
    }

    protected void entityInit() {
        super.entityInit();
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public float getMaxHealthPerDifficulty() {
        if (this.worldObj != null) {
            if (this.worldObj.difficultySetting == EnumDifficulty.EASY) {
                return 120.0f;
            }
            if (this.worldObj.difficultySetting == EnumDifficulty.NORMAL) {
                return 200.0f;
            }
            if (this.worldObj.difficultySetting == EnumDifficulty.HARD) {
                return 250.0f;
            }
            return 200.0f;
        }
        return 200.0f;
    }

    protected boolean canDespawn() {
        return false;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)this.getMaxHealthPerDifficulty());
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(2.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(6.0);
    }

    protected int setSegmentsPerHealth() {
        int oldSegments = this.currentSegments;
        int newSegments = (int)(this.getHealth() / this.segmentHealth + (float)(this.getHealth() > 0.0f ? 2 : 0));
        if (newSegments < 0) {
            newSegments = 0;
        }
        if (newSegments > MAX_SEGMENTS) {
            newSegments = MAX_SEGMENTS;
        }
        if (newSegments != oldSegments) {
            if (newSegments < oldSegments) {
                for (int i = newSegments; i < oldSegments; ++i) {
                    if (this.body == null || this.body[i] == null) continue;
                    this.body[i].selfDestruct();
                }
            } else {
                this.spawnBodySegments();
            }
        }
        this.currentSegments = newSegments;
        this.setMovementFactorPerSegments();
        return this.currentSegments;
    }

    protected void setMovementFactorPerSegments() {
        float movementFactor = 0.6f - (float)this.currentSegments / 12.0f * 0.2f;
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)movementFactor);
    }

    public boolean canTriggerWalking() {
        return false;
    }

    public boolean handleLavaMovement() {
        return false;
    }

    public void onUpdate() {
        this.despawnIfInvalid();
        if (this.deathTime > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                String explosionType = this.rand.nextBoolean() ? "hugeexplosion" : "explode";
                this.worldObj.spawnParticle(explosionType, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
            }
        }
        ++this.ticksSinceDamaged;
        if (!this.worldObj.isRemote && this.ticksSinceDamaged > TICKS_BEFORE_HEALING && this.ticksSinceDamaged % 20 == 0) {
            this.heal(1.0f);
        }
        this.setSegmentsPerHealth();
        super.onUpdate();
        this.moveSegments();
        for (int i = 0; i < this.body.length; ++i) {
            if (this.body[i].addedToChunk || this.worldObj.isRemote) continue;
            this.worldObj.spawnEntityInWorld((Entity)this.body[i]);
        }
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (this.isCollidedHorizontally && this.hasTarget()) {
            this.breakNearbyBlocks();
        }
        if (this.targetEntity != null && !this.isEntityWithinHomeArea(this.targetEntity)) {
            this.targetEntity = null;
        }
        if (this.targetEntity == null) {
            this.targetEntity = this.findTarget();
            if (this.targetEntity != null) {
                this.acquireNewPath();
            }
        } else if (!this.targetEntity.isEntityAlive()) {
            this.targetEntity = null;
        } else {
            float targetDistance = this.targetEntity.getDistanceToEntity((Entity)this);
            if (targetDistance > 80.0f) {
                this.targetEntity = null;
            } else if (this.canEntityBeSeen(this.targetEntity)) {
                this.attackEntity(this.targetEntity, targetDistance);
            }
        }
        if (!this.hasPath()) {
            this.acquireNewPath();
        }
        boolean inWater = this.isInWater();
        boolean inLava = this.handleLavaMovement();
        Vec3 vec3d = this.hasPath() ? this.pathToEntity.getPosition((Entity)this) : null;
        double d = this.width * 4.0f;
        while (vec3d != null && vec3d.squareDistanceTo(this.posX, vec3d.yCoord, this.posZ) < d * d) {
            this.pathToEntity.incrementPathIndex();
            if (this.pathToEntity.isFinished()) {
                vec3d = null;
                this.pathToEntity = null;
                continue;
            }
            vec3d = this.pathToEntity.getPosition((Entity)this);
        }
        this.isJumping = false;
        if (vec3d != null) {
            double d1 = vec3d.xCoord - this.posX;
            double d2 = vec3d.zCoord - this.posZ;
            double dist = MathHelper.sqrt_double((double)(d1 * d1 + d2 * d2));
            int i = MathHelper.floor_double((double)(this.boundingBox.minY + 0.5));
            double d3 = vec3d.yCoord - (double)i;
            float f2 = (float)(Math.atan2(d2, d1) * 180.0 / 3.1415927410125732) - 90.0f;
            float f3 = f2 - this.rotationYaw;
            this.moveForward = this.getMoveSpeed();
            this.setAIMoveSpeed(0.5f);
            if (dist > 4.0 && this.chargeCount == 0) {
                this.moveStrafing = MathHelper.cos((float)((float)this.ticksExisted * 0.3f)) * this.getMoveSpeed() * 0.6f;
            }
            while (f3 < -180.0f) {
                f3 += 360.0f;
            }
            while (f3 >= 180.0f) {
                f3 -= 360.0f;
            }
            if (f3 > 30.0f) {
                f3 = 30.0f;
            }
            if (f3 < -30.0f) {
                f3 = -30.0f;
            }
            this.rotationYaw += f3;
            if (d3 > 0.6) {
                this.isJumping = true;
            }
        }
        if (this.intimidateTimer > 0 && this.hasTarget()) {
            this.faceEntity(this.targetEntity, 30.0f, 30.0f);
            this.moveForward = 0.1f;
        }
        if (this.intimidateTimer > 0 && this.hasTarget()) {
            this.faceEntity(this.targetEntity, 30.0f, 30.0f);
            this.moveForward = 0.1f;
        }
        if (this.rand.nextFloat() < 0.8f && (inWater || inLava)) {
            this.isJumping = true;
        }
    }

    private float getMoveSpeed() {
        return 0.5f;
    }

    private void setMoveSpeed(float f) {
        this.setAIMoveSpeed(f);
    }

    protected void breakNearbyBlocks() {
        int maxz;
        int maxy;
        int maxx;
        int minz;
        int miny;
        int minx = MathHelper.floor_double((double)(this.boundingBox.minX - 0.5));
        if (this.worldObj.checkChunksExist(minx, miny = MathHelper.floor_double((double)(this.boundingBox.minY + 1.01)), minz = MathHelper.floor_double((double)(this.boundingBox.minZ - 0.5)), maxx = MathHelper.floor_double((double)(this.boundingBox.maxX + 0.5)), maxy = MathHelper.floor_double((double)(this.boundingBox.maxY + 0.001)), maxz = MathHelper.floor_double((double)(this.boundingBox.maxZ + 0.5)))) {
            for (int dx = minx; dx <= maxx; ++dx) {
                for (int dy = miny; dy <= maxy; ++dy) {
                    for (int dz = minz; dz <= maxz; ++dz) {
                        Block i5 = this.worldObj.getBlock(dx, dy, dz);
                        if (i5 == Blocks.air) continue;
                        this.breakBlock(dx, dy, dz);
                    }
                }
            }
        }
    }

    protected String getLivingSound() {
        return this.rand.nextInt(3) != 0 ? "TwilightForest:mob.naga.hiss" : "TwilightForest:mob.naga.rattle";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.naga.hurt";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.naga.hurt";
    }

    protected void acquireNewPath() {
        if (!this.hasTarget()) {
            this.wanderRandomly();
            return;
        }
        if (this.intimidateTimer > 0) {
            this.pathToEntity = null;
            --this.intimidateTimer;
            if (this.intimidateTimer == 0) {
                boolean bl = this.clockwise = !this.clockwise;
                if (this.targetEntity.boundingBox.minY > this.boundingBox.maxY) {
                    this.doCrumblePlayer();
                } else {
                    this.doCharge();
                }
            }
            return;
        }
        if (this.crumblePlayerTimer > 0) {
            this.pathToEntity = null;
            --this.crumblePlayerTimer;
            this.crumbleBelowTarget(2);
            this.crumbleBelowTarget(3);
            if (this.crumblePlayerTimer == 0) {
                this.doCharge();
            }
        }
        if (this.chargeCount > 0) {
            --this.chargeCount;
            Vec3 tpoint = this.findCirclePoint(this.targetEntity, 14.0, Math.PI);
            this.pathToEntity = this.worldObj.getEntityPathToXYZ((Entity)this, MathHelper.floor_double((double)tpoint.xCoord), MathHelper.floor_double((double)tpoint.yCoord), MathHelper.floor_double((double)tpoint.zCoord), 40.0f, true, true, true, true);
            if (this.chargeCount == 0) {
                this.doCircle();
            }
        }
        if (this.circleCount > 0) {
            --this.circleCount;
            double radius = this.circleCount % 2 == 0 ? 12.0 : 14.0;
            double rotation = 1.0;
            if (this.circleCount > 1 && this.circleCount < 3) {
                radius = 16.0;
            }
            if (this.circleCount == 1) {
                rotation = 0.1;
            }
            Vec3 tpoint = this.findCirclePoint(this.targetEntity, radius, rotation);
            this.pathToEntity = this.worldObj.getEntityPathToXYZ((Entity)this, (int)tpoint.xCoord, (int)tpoint.yCoord, (int)tpoint.zCoord, 40.0f, true, true, true, true);
            if (this.circleCount == 0) {
                this.doIntimidate();
            }
        }
    }

    protected void crumbleBelowTarget(int range) {
        int targetY = (int)this.targetEntity.boundingBox.minY;
        int floor = (int)this.boundingBox.minY;
        if (targetY > floor) {
            int dx = (int)this.targetEntity.posX + this.rand.nextInt(range) - this.rand.nextInt(range);
            int dz = (int)this.targetEntity.posZ + this.rand.nextInt(range) - this.rand.nextInt(range);
            int dy = targetY - this.rand.nextInt(range) + this.rand.nextInt(range > 1 ? range - 1 : range);
            if (dy <= floor) {
                dy = targetY;
            }
            if (this.worldObj.getBlock(dx, dy, dz) != Blocks.air) {
                this.breakBlock(dx, dy, dz);
                for (int k = 0; k < 20; ++k) {
                    double d = this.rand.nextGaussian() * 0.02;
                    double d1 = this.rand.nextGaussian() * 0.02;
                    double d2 = this.rand.nextGaussian() * 0.02;
                    this.worldObj.spawnParticle("crit", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
                }
            }
        }
    }

    protected void breakBlock(int dx, int dy, int dz) {
        Block whatsThere = this.worldObj.getBlock(dx, dy, dz);
        int whatsMeta = this.worldObj.getBlockMetadata(dx, dy, dz);
        if (whatsThere != Blocks.air) {
            whatsThere.dropBlockAsItem(this.worldObj, dx, dy, dz, whatsMeta, 0);
            this.worldObj.setBlock(dx, dy, dz, Blocks.air, 0, 2);
            this.worldObj.playAuxSFX(2001, dx, dy, dz, Block.getIdFromBlock((Block)whatsThere) + (whatsMeta << 12));
        }
    }

    protected void doCircle() {
        this.circleCount += 10 + this.rand.nextInt(10);
        this.goNormal();
    }

    protected void doCrumblePlayer() {
        this.crumblePlayerTimer = 20 + this.rand.nextInt(20);
        this.goSlow();
    }

    protected void doCharge() {
        this.chargeCount = 4;
        this.goFast();
    }

    protected void doIntimidate() {
        this.intimidateTimer += 15 + this.rand.nextInt(10);
        this.goSlow();
    }

    protected void goSlow() {
        this.moveStrafing = 0.0f;
        this.setMoveSpeed(0.1f);
        this.pathToEntity = null;
    }

    protected void goNormal() {
        this.setMoveSpeed(0.6f);
    }

    protected void goFast() {
        this.setMoveSpeed(1.0f);
    }

    public boolean canBePushed() {
        return false;
    }

    protected Vec3 findCirclePoint(Entity toCircle, double radius, double rotation) {
        double vecx = this.posX - toCircle.posX;
        double vecz = this.posZ - toCircle.posZ;
        float rangle = (float)Math.atan2(vecz, vecx);
        rangle = (float)((double)rangle + (this.clockwise ? rotation : -rotation));
        double dx = (double)MathHelper.cos((float)rangle) * radius;
        double dz = (double)MathHelper.sin((float)rangle) * radius;
        double dy = Math.min(this.boundingBox.minY, toCircle.posY);
        return Vec3.createVectorHelper((double)(toCircle.posX + dx), (double)dy, (double)(toCircle.posZ + dz));
    }

    public boolean hasTarget() {
        return this.targetEntity != null;
    }

    protected Entity findTarget() {
        EntityPlayer entityplayer = this.worldObj.getClosestVulnerablePlayerToEntity((Entity)this, 32.0);
        if (entityplayer != null && this.canEntityBeSeen((Entity)entityplayer) && this.isEntityWithinHomeArea((Entity)entityplayer)) {
            return entityplayer;
        }
        return null;
    }

    public boolean attackEntityFrom(DamageSource damagesource, float i) {
        if (damagesource.getSourceOfDamage() != null && !this.isEntityWithinHomeArea(damagesource.getSourceOfDamage())) {
            return false;
        }
        if (damagesource.getEntity() != null && !this.isEntityWithinHomeArea(damagesource.getEntity())) {
            return false;
        }
        if (super.attackEntityFrom(damagesource, i)) {
            this.setSegmentsPerHealth();
            Entity entity = damagesource.getEntity();
            if (entity != this) {
                this.targetEntity = entity;
            }
            this.ticksSinceDamaged = 0;
            return true;
        }
        return false;
    }

    protected void attackEntity(Entity toAttack, float f) {
        if (this.attackTime <= 0 && f < 4.0f && toAttack.boundingBox.maxY > this.boundingBox.minY - 2.5 && toAttack.boundingBox.minY < this.boundingBox.maxY + 2.5) {
            this.attackTime = 20;
            this.attackEntityAsMob(toAttack);
            if ((double)this.getMoveSpeed() > 0.8) {
                toAttack.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * 3.141593f / 180.0f)) * 1.0f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * 3.141593f / 180.0f)) * 1.0f));
            }
        }
    }

    protected void wanderRandomly() {
        this.goNormal();
        boolean flag = false;
        int tx = -1;
        int ty = -1;
        int tz = -1;
        float worstweight = -99999.0f;
        for (int l = 0; l < 10; ++l) {
            float weight;
            int dz;
            int dy;
            int dx = MathHelper.floor_double((double)(this.posX + (double)this.rand.nextInt(21) - 6.0));
            if (!this.isWithinHomeDistance(dx, dy = MathHelper.floor_double((double)(this.posY + (double)this.rand.nextInt(7) - 3.0)), dz = MathHelper.floor_double((double)(this.posZ + (double)this.rand.nextInt(21) - 6.0)))) {
                dx = this.getHomePosition().posX + this.rand.nextInt(21) - this.rand.nextInt(21);
                dy = this.getHomePosition().posY + this.rand.nextInt(7) - this.rand.nextInt(7);
                dz = this.getHomePosition().posZ + this.rand.nextInt(21) - this.rand.nextInt(21);
            }
            if (!((weight = this.getBlockPathWeight(dx, dy, dz)) > worstweight)) continue;
            worstweight = weight;
            tx = dx;
            ty = dy;
            tz = dz;
            flag = true;
        }
        if (flag) {
            this.pathToEntity = this.worldObj.getEntityPathToXYZ((Entity)this, tx, ty, tz, 80.0f, true, true, true, true);
        }
    }

    public float getBlockPathWeight(int i, int j, int k) {
        if (!this.isWithinHomeDistance(i, j, k)) {
            return Float.MIN_VALUE;
        }
        return 0.0f;
    }

    public boolean hasPath() {
        return this.pathToEntity != null;
    }

    protected Item getDropItem() {
        return TFItems.nagaScale;
    }

    protected void dropFewItems(boolean flag, int z) {
        Item i = this.getDropItem();
        if (i != null) {
            int j = 6 + this.rand.nextInt(6);
            for (int k = 0; k < j; ++k) {
                this.dropItem(i, 1);
            }
        }
        this.entityDropItem(new ItemStack(TFItems.trophy, 1, 1), 0.0f);
    }

    protected void despawnIfInvalid() {
        if (!this.worldObj.isRemote && this.worldObj.difficultySetting == EnumDifficulty.PEACEFUL) {
            this.despawnMe();
        }
    }

    protected void despawnMe() {
        if (this.isLeashed()) {
            ChunkCoordinates home = this.getHomePosition();
            this.worldObj.setBlock(home.posX, home.posY, home.posZ, TFBlocks.bossSpawner, 0, 2);
        }
        this.setDead();
    }

    public boolean isLeashed() {
        return this.getMaximumHomeDistance() > -1.0f;
    }

    public boolean isWithinHomeDistance(int x, int y, int z) {
        if (this.getMaximumHomeDistance() == -1.0f) {
            return true;
        }
        int distX = Math.abs(this.getHomePosition().posX - x);
        int distY = Math.abs(this.getHomePosition().posY - y);
        int distZ = Math.abs(this.getHomePosition().posZ - z);
        return distX <= this.LEASH_X && distY <= this.LEASH_Y && distZ <= this.LEASH_Z;
    }

    public boolean isEntityWithinHomeArea(Entity entity) {
        return this.isWithinHomeDistance(MathHelper.floor_double((double)entity.posX), MathHelper.floor_double((double)entity.posY), MathHelper.floor_double((double)entity.posZ));
    }

    protected void spawnBodySegments() {
        if (!this.worldObj.isRemote) {
            if (this.body == null) {
                this.body = new EntityTFNagaSegment[MAX_SEGMENTS];
            }
            for (int i = 0; i < this.currentSegments; ++i) {
                if (this.body[i] != null && !this.body[i].isDead) continue;
                this.body[i] = new EntityTFNagaSegment(this, i);
                this.body[i].setLocationAndAngles(this.posX + 0.1 * (double)i, this.posY + 0.5, this.posZ + 0.1 * (double)i, this.rand.nextFloat() * 360.0f, 0.0f);
                this.worldObj.spawnEntityInWorld((Entity)this.body[i]);
            }
        }
    }

    protected void moveSegments() {
        for (int i = 0; i < this.currentSegments; ++i) {
            Object leader = i == 0 ? this : this.body[i - 1];
            double followX = ((Entity)leader).posX;
            double followY = ((Entity)leader).posY;
            double followZ = ((Entity)leader).posZ;
            float angle = (((Entity)leader).rotationYaw + 180.0f) * 3.141593f / 180.0f;
            double straightenForce = 0.05 + 1.0 / (double)(i + 1) * 0.5;
            double idealX = (double)(-MathHelper.sin((float)angle)) * straightenForce;
            double idealZ = (double)MathHelper.cos((float)angle) * straightenForce;
            Vec3 diff = Vec3.createVectorHelper((double)(this.body[i].posX - followX), (double)(this.body[i].posY - followY), (double)(this.body[i].posZ - followZ));
            diff = diff.normalize();
            diff = diff.addVector(idealX, 0.0, idealZ);
            diff = diff.normalize();
            double f = 2.0;
            double destX = followX + f * diff.xCoord;
            double destY = followY + f * diff.yCoord;
            double destZ = followZ + f * diff.zCoord;
            this.body[i].setPosition(destX, destY, destZ);
            this.body[i].motionX = f * diff.xCoord;
            this.body[i].motionY = f * diff.yCoord;
            this.body[i].motionZ = f * diff.zCoord;
            double distance = MathHelper.sqrt_double((double)(diff.xCoord * diff.xCoord + diff.zCoord * diff.zCoord));
            if (i == 0) {
                diff.yCoord -= 0.15;
            }
            this.body[i].setRotation((float)(Math.atan2(diff.zCoord, diff.xCoord) * 180.0 / Math.PI) + 90.0f, -((float)(Math.atan2(diff.yCoord, distance) * 180.0 / Math.PI)));
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        ChunkCoordinates home = this.getHomePosition();
        nbttagcompound.setTag("Home", (NBTBase)this.newDoubleNBTList(new double[]{home.posX, home.posY, home.posZ}));
        nbttagcompound.setBoolean("HasHome", this.hasHome());
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("Home", 9)) {
            NBTTagList nbttaglist = nbttagcompound.getTagList("Home", 6);
            int hx = (int)nbttaglist.func_150309_d(0);
            int hy = (int)nbttaglist.func_150309_d(1);
            int hz = (int)nbttaglist.func_150309_d(2);
            this.setHomeArea(hx, hy, hz, 20);
        }
        if (!nbttagcompound.getBoolean("HasHome")) {
            this.detachHome();
        }
        this.setSegmentsPerHealth();
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightKillNaga);
        }
        if (!this.worldObj.isRemote && this.worldObj.provider instanceof WorldProviderTwilightForest) {
            int dx = MathHelper.floor_double((double)this.posX);
            int dy = MathHelper.floor_double((double)this.posY);
            int dz = MathHelper.floor_double((double)this.posZ);
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)this.worldObj.provider).getChunkProvider();
            TFFeature nearbyFeature = ((TFWorldChunkManager)this.worldObj.provider.worldChunkMgr).getFeatureAt(dx, dz, this.worldObj);
            if (nearbyFeature == TFFeature.nagaCourtyard) {
                chunkProvider.setStructureConquered(dx, dy, dz, true);
            }
        }
    }

    public World func_82194_d() {
        return this.worldObj;
    }

    public boolean attackEntityFromPart(EntityDragonPart entitydragonpart, DamageSource damagesource, float i) {
        return false;
    }

    public Entity[] getParts() {
        return this.body;
    }

    public float getMaximumHomeDistance() {
        return this.func_110174_bM();
    }
}

