/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.entity.boss.EntityTFNaga;

public class EntityTFNagaSegment
extends Entity {
    EntityTFNaga naga;
    int segment;
    String texture;
    private int deathCounter;

    public EntityTFNagaSegment(World par1World) {
        super(par1World);
        this.setSize(1.8f, 1.8f);
        this.stepHeight = 2.0f;
    }

    public EntityTFNagaSegment(EntityTFNaga myNaga, int segNum) {
        this(myNaga.func_82194_d());
        this.naga = myNaga;
        this.segment = segNum;
    }

    public boolean attackEntityFrom(DamageSource damagesource, float damage) {
        if (damagesource.isExplosion() || damagesource.isFireDamage()) {
            return false;
        }
        if (this.naga != null) {
            return this.naga.attackEntityFrom(damagesource, Math.round(damage * 2.0f / 3.0f));
        }
        return false;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.naga == null || this.naga.isDead) {
            this.setDead();
        }
        ++this.ticksExisted;
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        if (!this.onGround) {
            this.motionY -= 0.08;
        } else {
            this.motionX *= (double)0.8f;
            this.motionZ *= (double)0.8f;
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.collideWithOthers();
        if (this.deathCounter > 0) {
            --this.deathCounter;
            if (this.deathCounter == 0) {
                for (int k = 0; k < 20; ++k) {
                    double d = this.rand.nextGaussian() * 0.02;
                    double d1 = this.rand.nextGaussian() * 0.02;
                    double d2 = this.rand.nextGaussian() * 0.02;
                    String explosionType = this.rand.nextBoolean() ? "largeexplode" : "explode";
                    this.worldObj.spawnParticle(explosionType, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
                }
                this.setDead();
                this.worldObj.removeEntity((Entity)this);
            }
        }
    }

    protected void collideWithOthers() {
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.expand((double)0.2f, 0.0, (double)0.2f));
        for (Entity entity : list) {
            if (!entity.canBePushed()) continue;
            this.collideWithEntity(entity);
        }
    }

    private void collideWithEntity(Entity entity) {
        entity.applyEntityCollision((Entity)this);
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityTFNaga) && !(entity instanceof EntityTFNagaSegment)) {
            this.naga.attackTime = 10;
            int attackStrength = 2;
            if (entity instanceof EntityAnimal) {
                attackStrength *= 3;
            }
            entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this.naga), (float)attackStrength);
        }
    }

    public void setRotation(float par1, float par2) {
        this.rotationYaw = MathHelper.wrapAngleTo180_float((float)(par1 % 360.0f));
        this.rotationPitch = par2 % 360.0f;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean canBePushed() {
        return false;
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean isEntityEqual(Entity entity) {
        return this == entity || this.naga == entity;
    }

    protected void entityInit() {
    }

    protected void readEntityFromNBT(NBTTagCompound nbttagcompound) {
    }

    protected void writeEntityToNBT(NBTTagCompound nbttagcompound) {
    }

    protected void func_145780_a(int par1, int par2, int par3, Block par4) {
    }

    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        return this.texture;
    }

    public void selfDestruct() {
        this.deathCounter = 30;
    }
}

