/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TFTreasure;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFMiniGhast;
import twilightforest.entity.EntityTFTowerGhast;
import twilightforest.entity.boss.EntityTFUrGhastFireball;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class EntityTFUrGhast
extends EntityTFTowerGhast
implements IBossDisplayData {
    private static final int DATA_TANTRUM = 18;
    private static final int HOVER_ALTITUDE = 20;
    public double courseX;
    public double courseY;
    public double courseZ;
    ArrayList<ChunkCoordinates> trapLocations;
    ArrayList<ChunkCoordinates> travelCoords;
    int currentTravelCoordIndex;
    int travelPathRepetitions;
    int desiredRepetitions;
    int nextTantrumCry;
    float damageUntilNextPhase;
    boolean noTrapMode;

    public EntityTFUrGhast(World par1World) {
        super(par1World);
        this.setSize(14.0f, 18.0f);
        this.aggroRange = 128.0f;
        this.wanderFactor = 32.0f;
        this.noClip = true;
        this.trapLocations = new ArrayList();
        this.travelCoords = new ArrayList();
        this.setInTantrum(false);
        this.damageUntilNextPhase = 45.0f;
        this.experienceValue = 317;
        this.noTrapMode = false;
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(250.0);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(18, (Object)0);
    }

    protected boolean canDespawn() {
        return false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.deathTime > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.rand.nextGaussian() * 0.02;
                double d1 = this.rand.nextGaussian() * 0.02;
                double d2 = this.rand.nextGaussian() * 0.02;
                String explosionType = this.rand.nextBoolean() ? "hugeexplosion" : "explode";
                this.worldObj.spawnParticle(explosionType, this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, d, d1, d2);
            }
        }
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (source == DamageSource.inWall) {
            return false;
        }
        boolean attackSuccessful = false;
        if (this.isInTantrum()) {
            damage /= 4.0f;
        }
        attackSuccessful = "fireball".equals(source.getDamageType()) && source.getEntity() instanceof EntityPlayer ? super.attackEntityFrom(DamageSource.causeThrownDamage((Entity)source.getSourceOfDamage(), (Entity)source.getEntity()), damage) : super.attackEntityFrom(source, damage);
        if (!this.worldObj.isRemote) {
            if (this.hurtTime == this.maxHurtTime) {
                this.damageUntilNextPhase -= this.getLastDamage();
                FMLLog.info((String)"[Urghast] Attack successful, %f damage until phase switch.", (Object[])new Object[]{Float.valueOf(this.damageUntilNextPhase)});
                if (this.damageUntilNextPhase <= 0.0f) {
                    this.switchPhase();
                }
            } else {
                FMLLog.info((String)"[Urghast] Attack fail with %s type attack for %f damage", (Object[])new Object[]{source.damageType, Float.valueOf(damage)});
            }
        }
        return attackSuccessful;
    }

    private float getLastDamage() {
        return this.prevHealth - this.getHealth();
    }

    private void switchPhase() {
        if (this.isInTantrum()) {
            this.stopTantrum();
        } else {
            this.startTantrum();
        }
        this.damageUntilNextPhase = 48.0f;
    }

    protected void startTantrum() {
        this.setInTantrum(true);
        int rainTime = 6000;
        WorldInfo worldInfo = MinecraftServer.getServer().worldServers[0].getWorldInfo();
        worldInfo.setRaining(true);
        worldInfo.setThundering(true);
        worldInfo.setRainTime(rainTime);
        worldInfo.setThunderTime(rainTime);
        this.spawnGhastsAtTraps();
    }

    protected void spawnGhastsAtTraps() {
        ArrayList<ChunkCoordinates> ghastSpawns = new ArrayList<ChunkCoordinates>(this.trapLocations);
        int numSpawns = Math.min(2, ghastSpawns.size());
        for (int i = 0; i < numSpawns; ++i) {
            int index = this.rand.nextInt(ghastSpawns.size());
            ChunkCoordinates spawnCoord = ghastSpawns.get(index);
            ghastSpawns.remove(index);
            this.spawnMinionGhastsAt(spawnCoord.posX, spawnCoord.posY, spawnCoord.posZ);
        }
    }

    public void stopTantrum() {
        this.setInTantrum(false);
    }

    private void spawnMinionGhastsAt(int x, int y, int z) {
        int tries = 24;
        int spawns = 0;
        int maxSpawns = 6;
        int rangeXZ = 4;
        int rangeY = 8;
        this.worldObj.addWeatherEffect((Entity)new EntityLightningBolt(this.worldObj, (double)x, (double)(y + 4), (double)z));
        for (int i = 0; i < tries; ++i) {
            EntityTFMiniGhast minion = new EntityTFMiniGhast(this.worldObj);
            double sx = (double)x + (this.rand.nextDouble() - this.rand.nextDouble()) * (double)rangeXZ;
            double sy = (double)y + this.rand.nextDouble() * (double)rangeY;
            double sz = (double)z + (this.rand.nextDouble() - this.rand.nextDouble()) * (double)rangeXZ;
            minion.setLocationAndAngles(sx, sy, sz, this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
            minion.makeBossMinion();
            if (minion.getCanSpawnHere()) {
                this.worldObj.spawnEntityInWorld((Entity)minion);
                minion.spawnExplosionParticle();
            }
            if (++spawns >= maxSpawns) break;
        }
    }

    @Override
    protected void updateEntityActionState() {
        byte newAggroStatus;
        byte currentAggroStatus;
        double targetRange;
        if (!this.worldObj.isRemote && this.worldObj.difficultySetting == EnumDifficulty.PEACEFUL) {
            this.setDead();
        }
        this.despawnEntity();
        List nearbyGhasts = this.worldObj.getEntitiesWithinAABB(EntityTFMiniGhast.class, this.boundingBox.expand(1.0, 1.0, 1.0));
        for (EntityTFMiniGhast ghast : nearbyGhasts) {
            ghast.setDead();
            this.heal(2.0f);
        }
        if (this.trapLocations.isEmpty() && !this.noTrapMode) {
            this.scanForTrapsTwice();
        }
        if (this.trapLocations.isEmpty() && !this.noTrapMode) {
            FMLLog.info((String)"[TwilightForest] Ur-ghast cannot find traps nearby, entering trap-less mode", (Object[])new Object[0]);
            this.noTrapMode = true;
        }
        if (this.inTrapCounter > 0) {
            --this.inTrapCounter;
            this.targetedEntity = null;
            return;
        }
        this.prevAttackCounter = this.attackCounter;
        if (this.targetedEntity != null && this.targetedEntity.isDead) {
            this.targetedEntity = null;
        }
        if (this.targetedEntity == null) {
            this.targetedEntity = this.findPlayerInRange();
        } else if (!this.isAggressive && this.targetedEntity instanceof EntityPlayer) {
            this.checkToIncreaseAggro((EntityPlayer)this.targetedEntity);
        }
        if (this.isInTantrum()) {
            this.shedTear();
            this.targetedEntity = null;
            if (--this.nextTantrumCry <= 0) {
                this.playSound(this.getHurtSound(), this.getSoundVolume(), this.getSoundPitch());
                this.nextTantrumCry = 20 + this.rand.nextInt(30);
            }
            if (this.ticksExisted % 10 == 0) {
                this.doTantrumDamageEffects();
            }
        }
        this.checkAndChangeCourse();
        double offsetX = this.waypointX - this.posX;
        double offsetY = this.waypointY - this.posY;
        double offsetZ = this.waypointZ - this.posZ;
        double distanceToWaypoint = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        if (distanceToWaypoint < 1.0 || distanceToWaypoint > 3600.0) {
            this.makeNewWaypoint();
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.rand.nextInt(5) + 0;
            distanceToWaypoint = MathHelper.sqrt_double((double)distanceToWaypoint);
            double speed = 0.05;
            this.motionX += offsetX / distanceToWaypoint * speed;
            this.motionY += offsetY / distanceToWaypoint * speed;
            this.motionZ += offsetZ / distanceToWaypoint * speed;
        }
        double d = targetRange = this.aggroCounter > 0 || this.isAggressive ? (double)this.aggroRange : (double)this.stareRange;
        if (this.targetedEntity != null && this.targetedEntity.getDistanceSqToEntity((Entity)this) < targetRange * targetRange && this.canEntityBeSeen((Entity)this.targetedEntity)) {
            this.faceEntity((Entity)this.targetedEntity, 10.0f, this.getVerticalFaceSpeed());
            if (this.isAggressive) {
                if (this.attackCounter == 10) {
                    this.playSound("mob.ghast.charge", this.getSoundVolume(), this.getSoundPitch());
                }
                ++this.attackCounter;
                if (this.attackCounter == 20) {
                    this.spitFireball();
                    this.attackCounter = -40;
                }
            }
        } else {
            this.isAggressive = false;
            this.targetedEntity = null;
            this.rotationYaw = -((float)Math.atan2(this.motionX, this.motionZ)) * 180.0f / (float)Math.PI;
            this.rotationPitch = 0.0f;
        }
        if (this.attackCounter > 0 && !this.isAggressive) {
            --this.attackCounter;
        }
        if ((currentAggroStatus = this.dataWatcher.getWatchableObjectByte(16)) != (newAggroStatus = (byte)(this.attackCounter > 10 ? 2 : (this.aggroCounter > 0 || this.isAggressive ? 1 : 0)))) {
            this.dataWatcher.updateObject(16, (Object)newAggroStatus);
        }
    }

    private void doTantrumDamageEffects() {
        AxisAlignedBB below = this.boundingBox.getOffsetBoundingBox(0.0, -16.0, 0.0).expand(0.0, 16.0, 0.0);
        List playersBelow = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, below);
        for (EntityPlayer player : playersBelow) {
            int dz;
            int dy;
            int dx = MathHelper.floor_double((double)player.posX);
            if (!this.worldObj.canBlockSeeTheSky(dx, dy = MathHelper.floor_double((double)player.posY), dz = MathHelper.floor_double((double)player.posZ))) continue;
            player.attackEntityFrom(DamageSource.anvil, 3.0f);
        }
        List ghastsBelow = this.worldObj.getEntitiesWithinAABB(EntityTFMiniGhast.class, below);
        for (EntityTFMiniGhast ghast : ghastsBelow) {
            ghast.motionY += 1.0;
        }
    }

    private void shedTear() {
        TwilightForestMod.proxy.spawnParticle(this.worldObj, "bosstear", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height - 0.25, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, 0.0, 0.0, 0.0);
    }

    protected void makeNewWaypoint() {
        double closestDistance = this.getDistanceSq(this.courseX, this.courseY, this.courseZ);
        for (int i = 0; i < 50; ++i) {
            double potentialZ;
            double offsetZ;
            double potentialY;
            double offsetY;
            double potentialX = this.posX + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * this.wanderFactor);
            double offsetX = this.courseX - potentialX;
            double potentialDistanceToCourse = offsetX * offsetX + (offsetY = this.courseY - (potentialY = this.courseY + (double)(this.rand.nextFloat() * 8.0f) - 4.0)) * offsetY + (offsetZ = this.courseZ - (potentialZ = this.posZ + (double)((this.rand.nextFloat() * 2.0f - 1.0f) * this.wanderFactor))) * offsetZ;
            if (!(potentialDistanceToCourse < closestDistance)) continue;
            this.waypointX = potentialX;
            this.waypointY = potentialY;
            this.waypointZ = potentialZ;
            closestDistance = potentialDistanceToCourse;
        }
    }

    protected void checkAndChangeCourse() {
        double offsetZ;
        double offsetY;
        double offsetX;
        double distanceToCourse;
        if (this.courseX == 0.0 && this.courseY == 0.0 && this.courseZ == 0.0) {
            this.changeCourse();
        }
        if ((distanceToCourse = (offsetX = this.courseX - this.posX) * offsetX + (offsetY = this.courseY - this.posY) * offsetY + (offsetZ = this.courseZ - this.posZ) * offsetZ) < 100.0) {
            this.changeCourse();
        }
    }

    private void changeCourse() {
        if (this.travelCoords.isEmpty()) {
            this.makeTravelPath();
        }
        if (!this.travelCoords.isEmpty()) {
            if (this.currentTravelCoordIndex >= this.travelCoords.size()) {
                this.currentTravelCoordIndex = 0;
                ++this.travelPathRepetitions;
                if (!this.checkGhastsAtTraps()) {
                    this.spawnGhastsAtTraps();
                }
            }
            this.courseX = this.travelCoords.get((int)this.currentTravelCoordIndex).posX;
            this.courseY = this.travelCoords.get((int)this.currentTravelCoordIndex).posY + 20;
            this.courseZ = this.travelCoords.get((int)this.currentTravelCoordIndex).posZ;
            ++this.currentTravelCoordIndex;
        }
    }

    private boolean checkGhastsAtTraps() {
        int trapsWithEnoughGhasts = 0;
        for (ChunkCoordinates trap : this.trapLocations) {
            AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox((double)trap.posX, (double)trap.posY, (double)trap.posZ, (double)(trap.posX + 1), (double)(trap.posY + 1), (double)(trap.posZ + 1)).expand(8.0, 16.0, 8.0);
            List nearbyGhasts = this.worldObj.getEntitiesWithinAABB(EntityTFMiniGhast.class, aabb);
            if (nearbyGhasts.size() < 4) continue;
            ++trapsWithEnoughGhasts;
        }
        return trapsWithEnoughGhasts >= 1;
    }

    private void makeTravelPath() {
        ArrayList<Object> potentialPoints;
        int px = MathHelper.floor_double((double)this.posX);
        int py = MathHelper.floor_double((double)this.posY);
        int pz = MathHelper.floor_double((double)this.posZ);
        if (!this.noTrapMode) {
            potentialPoints = new ArrayList<ChunkCoordinates>(this.trapLocations);
        } else {
            potentialPoints = new ArrayList<ChunkCoordinates>();
            potentialPoints.add(new ChunkCoordinates(px + 20, py - 20, pz));
            potentialPoints.add(new ChunkCoordinates(px, py - 20, pz - 20));
            potentialPoints.add(new ChunkCoordinates(px - 20, py - 20, pz));
            potentialPoints.add(new ChunkCoordinates(px, py - 20, pz + 20));
        }
        this.travelCoords.clear();
        while (!potentialPoints.isEmpty()) {
            int index = this.rand.nextInt(potentialPoints.size());
            this.travelCoords.add((ChunkCoordinates)potentialPoints.get(index));
            potentialPoints.remove(index);
        }
        if (this.noTrapMode) {
            this.travelCoords.add(new ChunkCoordinates(px, py - 20, pz));
        }
    }

    @Override
    protected void spitFireball() {
        double offsetX = this.targetedEntity.posX - this.posX;
        double offsetY = this.targetedEntity.boundingBox.minY + (double)(this.targetedEntity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
        double offsetZ = this.targetedEntity.posZ - this.posZ;
        this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1008, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
        EntityTFUrGhastFireball entityFireball = new EntityTFUrGhastFireball(this.worldObj, this, offsetX, offsetY, offsetZ);
        entityFireball.field_92057_e = 1;
        double shotSpawnDistance = 8.5;
        Vec3 lookVec = this.getLook(1.0f);
        entityFireball.posX = this.posX + lookVec.xCoord * shotSpawnDistance;
        entityFireball.posY = this.posY + (double)(this.height / 2.0f) + lookVec.yCoord * shotSpawnDistance;
        entityFireball.posZ = this.posZ + lookVec.zCoord * shotSpawnDistance;
        this.worldObj.spawnEntityInWorld((Entity)entityFireball);
        for (int i = 0; i < 2; ++i) {
            entityFireball = new EntityTFUrGhastFireball(this.worldObj, this, offsetX + (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 8.0f), offsetY, offsetZ + (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 8.0f));
            entityFireball.field_92057_e = 1;
            entityFireball.posX = this.posX + lookVec.xCoord * shotSpawnDistance;
            entityFireball.posY = this.posY + (double)(this.height / 2.0f) + lookVec.yCoord * shotSpawnDistance;
            entityFireball.posZ = this.posZ + lookVec.zCoord * shotSpawnDistance;
            this.worldObj.spawnEntityInWorld((Entity)entityFireball);
        }
    }

    private void scanForTrapsTwice() {
        int scanRangeXZ = 48;
        int scanRangeY = 32;
        int px = MathHelper.floor_double((double)this.posX);
        int py = MathHelper.floor_double((double)this.posY);
        int pz = MathHelper.floor_double((double)this.posZ);
        this.scanForTraps(scanRangeXZ, scanRangeY, px, py, pz);
        if (this.trapLocations.size() > 0) {
            int ax = 0;
            int ay = 0;
            int az = 0;
            for (ChunkCoordinates trapCoords : this.trapLocations) {
                ax += trapCoords.posX;
                ay += trapCoords.posY;
                az += trapCoords.posZ;
            }
            this.scanForTraps(scanRangeXZ, scanRangeY, ax /= this.trapLocations.size(), ay /= this.trapLocations.size(), az /= this.trapLocations.size());
        }
    }

    protected void scanForTraps(int scanRangeXZ, int scanRangeY, int px, int py, int pz) {
        for (int sx = -scanRangeXZ; sx <= scanRangeXZ; ++sx) {
            for (int sz = -scanRangeXZ; sz <= scanRangeXZ; ++sz) {
                for (int sy = -scanRangeY; sy <= scanRangeY; ++sy) {
                    ChunkCoordinates trapCoords;
                    if (!this.isTrapAt(px + sx, py + sy, pz + sz) || this.trapLocations.contains(trapCoords = new ChunkCoordinates(px + sx, py + sy, pz + sz))) continue;
                    this.trapLocations.add(trapCoords);
                }
            }
        }
    }

    private boolean isTrapAt(int x, int y, int z) {
        return this.worldObj.blockExists(x, y, z) && this.worldObj.getBlock(x, y, z) == TFBlocks.towerDevice && (this.worldObj.getBlockMetadata(x, y, z) == 10 || this.worldObj.getBlockMetadata(x, y, z) == 11);
    }

    public boolean isBurning() {
        return false;
    }

    public boolean canBePushed() {
        return false;
    }

    public boolean isInTantrum() {
        return this.dataWatcher.getWatchableObjectByte(18) != 0;
    }

    public void setInTantrum(boolean par1) {
        this.dataWatcher.updateObject(18, (Object)(par1 ? (byte)-1 : 0));
        this.damageUntilNextPhase = 48.0f;
    }

    @Override
    protected float getSoundVolume() {
        return 16.0f;
    }

    protected float getSoundPitch() {
        return (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.5f;
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setBoolean("inTantrum", this.isInTantrum());
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        this.setInTantrum(nbttagcompound.getBoolean("inTantrum"));
    }

    protected void onDeathUpdate() {
        super.onDeathUpdate();
        if (this.deathTime == 20 && !this.worldObj.isRemote) {
            ChunkCoordinates chestCoords = this.findChestCoords();
            TFTreasure.darktower_boss.generate(this.worldObj, null, chestCoords.posX, chestCoords.posY, chestCoords.posZ);
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightProgressUrghast);
        }
        if (!this.worldObj.isRemote && this.worldObj.provider instanceof WorldProviderTwilightForest) {
            ChunkCoordinates chestCoords = this.findChestCoords();
            int dx = chestCoords.posX;
            int dy = chestCoords.posY;
            int dz = chestCoords.posZ;
            ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)this.worldObj.provider).getChunkProvider();
            TFFeature nearbyFeature = ((TFWorldChunkManager)this.worldObj.provider.worldChunkMgr).getFeatureAt(dx, dz, this.worldObj);
            if (nearbyFeature == TFFeature.darkTower) {
                chunkProvider.setStructureConquered(dx, dy, dz, true);
            }
        }
    }

    private ChunkCoordinates findChestCoords() {
        if (this.trapLocations.size() > 0) {
            int ax = 0;
            int ay = 0;
            int az = 0;
            for (ChunkCoordinates trapCoords : this.trapLocations) {
                ax += trapCoords.posX;
                ay += trapCoords.posY;
                az += trapCoords.posZ;
            }
            return new ChunkCoordinates(ax /= this.trapLocations.size(), (ay /= this.trapLocations.size()) + 2, az /= this.trapLocations.size());
        }
        return new ChunkCoordinates(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ));
    }
}

