/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.entity.ai.EntityAIStayNearHome;
import twilightforest.entity.ai.EntityAITFThrowRider;
import twilightforest.entity.ai.EntityAITFYetiRampage;
import twilightforest.entity.ai.EntityAITFYetiTired;
import twilightforest.entity.boss.EntityTFFallingIce;
import twilightforest.entity.boss.EntityTFIceBomb;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkProviderTwilightForest;
import twilightforest.world.TFWorldChunkManager;
import twilightforest.world.WorldProviderTwilightForest;

public class EntityTFYetiAlpha
extends EntityMob
implements IRangedAttackMob {
    private static final int RAMPAGE_FLAG = 16;
    private static final int TIRED_FLAG = 17;
    private int collisionCounter;
    private boolean canRampage;

    public EntityTFYetiAlpha(World par1World) {
        super(par1World);
        this.setSize(3.8f, 5.0f);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(1, (EntityAIBase)new EntityAITFYetiTired(this, 100));
        this.tasks.addTask(2, (EntityAIBase)new EntityAITFThrowRider((EntityCreature)this, 1.0f));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIStayNearHome((EntityCreature)this, 2.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAITFYetiRampage(this, 10, 180));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 40, 40, 40.0f));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 2.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false));
        this.experienceValue = 317;
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(17, (Object)0);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(200.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.38);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(1.0);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(40.0);
    }

    public void onLivingUpdate() {
        if (this.riddenByEntity != null && this.riddenByEntity.isSneaking()) {
            this.riddenByEntity.setSneaking(false);
        }
        super.onLivingUpdate();
        if (this.riddenByEntity != null) {
            this.getLookHelper().setLookPositionWithEntity(this.riddenByEntity, 100.0f, 100.0f);
        }
        if (this.isCollided) {
            ++this.collisionCounter;
        }
        if (this.collisionCounter >= 15) {
            if (!this.worldObj.isRemote) {
                this.destroyBlocksInAABB(this.boundingBox);
            }
            this.collisionCounter = 0;
        }
        if (this.isRampaging()) {
            float rotation = (float)this.ticksExisted / 10.0f;
            for (int i = 0; i < 20; ++i) {
                this.addSnowEffect(rotation + (float)(i * 50), (float)i + rotation);
            }
            this.limbSwingAmount = (float)((double)this.limbSwingAmount + 0.6);
        }
        if (this.isTired()) {
            for (int i = 0; i < 20; ++i) {
                this.worldObj.spawnParticle("splash", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width * 0.5, this.posY + (double)this.getEyeHeight(), this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width * 0.5, (double)((this.rand.nextFloat() - 0.5f) * 0.75f), 0.0, (double)((this.rand.nextFloat() - 0.5f) * 0.75f));
            }
        }
    }

    private void addSnowEffect(float rotation, float hgt) {
        double px = 3.0 * Math.cos(rotation);
        double py = hgt % 5.0f;
        double pz = 3.0 * Math.sin(rotation);
        TwilightForestMod.proxy.spawnParticle(this.worldObj, "snowstuff", this.lastTickPosX + px, this.lastTickPosY + py, this.lastTickPosZ + pz, 0.0, 0.0, 0.0);
    }

    public boolean interact(EntityPlayer par1EntityPlayer) {
        if (super.interact(par1EntityPlayer)) {
            return true;
        }
        if (!(this.worldObj.isRemote || this.riddenByEntity != null && this.riddenByEntity != par1EntityPlayer)) {
            par1EntityPlayer.mountEntity((Entity)this);
            return true;
        }
        return false;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        if (this.riddenByEntity == null && par1Entity.ridingEntity == null) {
            par1Entity.mountEntity((Entity)this);
        }
        return super.attackEntityAsMob(par1Entity);
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (!this.canRampage && !this.isTired() && par1DamageSource.isProjectile()) {
            return false;
        }
        boolean success = super.attackEntityFrom(par1DamageSource, par2);
        this.canRampage = true;
        return success;
    }

    protected void dropFewItems(boolean flag, int looting) {
        Item fur = this.getDropItem();
        if (fur != null) {
            int drops = 6 + this.rand.nextInt(6 + looting);
            for (int d = 0; d < drops; ++d) {
                this.dropItem(fur, 1);
            }
        }
        Item bombs = TFItems.iceBomb;
        int drops = 6 + this.rand.nextInt(6 + looting);
        for (int d = 0; d < drops; ++d) {
            this.dropItem(bombs, 1);
        }
    }

    protected Item getDropItem() {
        return TFItems.alphaFur;
    }

    public void updateRiderPosition() {
        if (this.riddenByEntity != null) {
            Vec3 riderPos = this.getRiderPosition();
            this.riddenByEntity.setPosition(riderPos.xCoord, riderPos.yCoord, riderPos.zCoord);
        }
    }

    public double getMountedYOffset() {
        return 5.75;
    }

    public Vec3 getRiderPosition() {
        if (this.riddenByEntity != null) {
            float distance = 0.4f;
            double var1 = Math.cos((double)(this.rotationYaw + 90.0f) * Math.PI / 180.0) * (double)distance;
            double var3 = Math.sin((double)(this.rotationYaw + 90.0f) * Math.PI / 180.0) * (double)distance;
            return Vec3.createVectorHelper((double)(this.posX + var1), (double)(this.posY + this.getMountedYOffset() + this.riddenByEntity.getYOffset()), (double)(this.posZ + var3));
        }
        return Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean destroyBlocksInAABB(AxisAlignedBB par1AxisAlignedBB) {
        int minX = MathHelper.floor_double((double)par1AxisAlignedBB.minX);
        int minY = MathHelper.floor_double((double)par1AxisAlignedBB.minY);
        int minZ = MathHelper.floor_double((double)par1AxisAlignedBB.minZ);
        int maxX = MathHelper.floor_double((double)par1AxisAlignedBB.maxX);
        int maxY = MathHelper.floor_double((double)par1AxisAlignedBB.maxY);
        int maxZ = MathHelper.floor_double((double)par1AxisAlignedBB.maxZ);
        boolean wasBlocked = false;
        for (int dx = minX; dx <= maxX; ++dx) {
            for (int dy = minY; dy <= maxY; ++dy) {
                for (int dz = minZ; dz <= maxZ; ++dz) {
                    Block currentID = this.worldObj.getBlock(dx, dy, dz);
                    if (currentID == Blocks.air) continue;
                    int currentMeta = this.worldObj.getBlockMetadata(dx, dy, dz);
                    if (currentID != Blocks.obsidian && currentID != Blocks.end_stone && currentID != Blocks.bedrock) {
                        this.worldObj.setBlock(dx, dy, dz, Blocks.air, 0, 2);
                        this.worldObj.playAuxSFX(2001, dx, dy, dz, Block.getIdFromBlock((Block)currentID) + (currentMeta << 12));
                        continue;
                    }
                    wasBlocked = true;
                }
            }
        }
        return wasBlocked;
    }

    public void makeRandomBlockFall() {
        this.makeRandomBlockFall(30);
    }

    private void makeRandomBlockFall(int range) {
        int bx = MathHelper.floor_double((double)this.posX) + this.getRNG().nextInt(range) - this.getRNG().nextInt(range);
        int bz = MathHelper.floor_double((double)this.posZ) + this.getRNG().nextInt(range) - this.getRNG().nextInt(range);
        int by = MathHelper.floor_double((double)(this.posY + (double)this.getEyeHeight()));
        this.makeBlockFallAbove(bx, bz, by);
    }

    private void makeBlockFallAbove(int bx, int bz, int by) {
        if (this.worldObj.isAirBlock(bx, by, bz)) {
            for (int i = 1; i < 30; ++i) {
                if (this.worldObj.isAirBlock(bx, by + i, bz)) continue;
                this.makeBlockFall(bx, by + i, bz);
                break;
            }
        }
    }

    public void makeNearbyBlockFall() {
        this.makeRandomBlockFall(15);
    }

    public void makeBlockAboveTargetFall() {
        if (this.getAttackTarget() != null) {
            int bx = MathHelper.floor_double((double)this.getAttackTarget().posX);
            int bz = MathHelper.floor_double((double)this.getAttackTarget().posZ);
            int by = MathHelper.floor_double((double)(this.getAttackTarget().posY + (double)this.getAttackTarget().getEyeHeight()));
            this.makeBlockFallAbove(bx, bz, by);
        }
    }

    private void makeBlockFall(int bx, int by, int bz) {
        Block currentID = this.worldObj.getBlock(bx, by, bz);
        int currentMeta = this.worldObj.getBlockMetadata(bx, by, bz);
        this.worldObj.setBlock(bx, by, bz, Blocks.packed_ice);
        this.worldObj.playAuxSFX(2001, bx, by, bz, Block.getIdFromBlock((Block)currentID) + (currentMeta << 12));
        EntityTFFallingIce ice = new EntityTFFallingIce(this.worldObj, bx, by - 3, bz);
        this.worldObj.spawnEntityInWorld((Entity)ice);
    }

    public void attackEntityWithRangedAttack(EntityLivingBase target, float par2) {
        if (!this.canRampage) {
            EntityTFIceBomb ice = new EntityTFIceBomb(this.worldObj, (EntityLivingBase)this);
            double d0 = target.posX - this.posX;
            double d1 = target.posY + (double)target.getEyeHeight() - (double)1.1f - target.posY;
            double d2 = target.posZ - this.posZ;
            float f1 = MathHelper.sqrt_double((double)(d0 * d0 + d2 * d2)) * 0.2f;
            ice.setThrowableHeading(d0, d1 + (double)f1, d2, 0.75f, 12.0f);
            this.playSound("random.bow", 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
            this.worldObj.spawnEntityInWorld((Entity)ice);
        }
    }

    public boolean canDespawn() {
        return false;
    }

    public boolean canRampage() {
        return this.canRampage;
    }

    public void setRampaging(boolean par1) {
        this.getDataWatcher().updateObject(16, (Object)((byte)(par1 ? 1 : 0)));
    }

    public boolean isRampaging() {
        return this.getDataWatcher().getWatchableObjectByte(16) == 1;
    }

    public void setTired(boolean par1) {
        this.getDataWatcher().updateObject(17, (Object)((byte)(par1 ? 1 : 0)));
        this.canRampage = false;
    }

    public boolean isTired() {
        return this.getDataWatcher().getWatchableObjectByte(17) == 1;
    }

    protected void fall(float par1) {
        super.fall(par1);
        if (this.isRampaging()) {
            this.playSound("random.bow", 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
            int i = MathHelper.floor_double((double)this.posX);
            int j = MathHelper.floor_double((double)(this.posY - (double)0.2f - (double)this.yOffset));
            int k = MathHelper.floor_double((double)this.posZ);
            this.worldObj.playAuxSFX(2006, i, j, k, 20);
            this.worldObj.playAuxSFX(2006, i, j, k, 30);
            if (!this.worldObj.isRemote) {
                this.hitNearbyEntities();
            }
        }
    }

    private void hitNearbyEntities() {
        ArrayList nearby = new ArrayList(this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.expand(5.0, 0.0, 5.0)));
        for (Entity entity : nearby) {
            boolean hit;
            if (!(entity instanceof EntityLivingBase) || !(hit = entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), 5.0f))) continue;
            entity.motionY += (double)0.4f;
        }
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightProgressYeti);
        }
        if (!this.worldObj.isRemote) {
            int dx = MathHelper.floor_double((double)this.posX);
            int dy = MathHelper.floor_double((double)this.posY);
            int dz = MathHelper.floor_double((double)this.posZ);
            if (this.worldObj.provider instanceof WorldProviderTwilightForest) {
                ChunkProviderTwilightForest chunkProvider = ((WorldProviderTwilightForest)this.worldObj.provider).getChunkProvider();
                TFFeature nearbyFeature = ((TFWorldChunkManager)this.worldObj.provider.worldChunkMgr).getFeatureAt(dx, dz, this.worldObj);
                if (nearbyFeature == TFFeature.yetiCave) {
                    chunkProvider.setStructureConquered(dx, dy, dz, true);
                }
            }
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        ChunkCoordinates home = this.getHomePosition();
        nbttagcompound.setTag("Home", (NBTBase)this.newDoubleNBTList(new double[]{home.posX, home.posY, home.posZ}));
        nbttagcompound.setBoolean("HasHome", this.hasHome());
        super.writeEntityToNBT(nbttagcompound);
    }

    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
        if (nbttagcompound.hasKey("Home", 9)) {
            NBTTagList nbttaglist = nbttagcompound.getTagList("Home", 6);
            int hx = (int)nbttaglist.func_150309_d(0);
            int hy = (int)nbttaglist.func_150309_d(1);
            int hz = (int)nbttaglist.func_150309_d(2);
            this.setHomeArea(hx, hy, hz, 30);
        }
        if (!nbttagcompound.getBoolean("HasHome")) {
            this.detachHome();
        }
    }
}

