/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityTFMobileFirefly
extends EntityAmbientCreature {
    private ChunkCoordinates currentFlightTarget;

    public EntityTFMobileFirefly(World par1World) {
        super(par1World);
        this.setSize(0.5f, 0.5f);
    }

    protected float getSoundVolume() {
        return 0.1f;
    }

    protected float getSoundPitch() {
        return super.getSoundPitch() * 0.95f;
    }

    protected String getHurtSound() {
        return "mob.bat.hurt";
    }

    protected String getDeathSound() {
        return "mob.bat.death";
    }

    public boolean canBePushed() {
        return false;
    }

    protected void collideWithEntity(Entity par1Entity) {
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(6.0);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public void onUpdate() {
        super.onUpdate();
        this.motionY *= (double)0.6f;
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (!(this.currentFlightTarget == null || this.worldObj.isAirBlock(this.currentFlightTarget.posX, this.currentFlightTarget.posY, this.currentFlightTarget.posZ) && this.currentFlightTarget.posY >= 1)) {
            this.currentFlightTarget = null;
        }
        if (this.currentFlightTarget == null || this.rand.nextInt(30) == 0 || this.currentFlightTarget.getDistanceSquared((int)this.posX, (int)this.posY, (int)this.posZ) < 4.0f) {
            this.currentFlightTarget = new ChunkCoordinates((int)this.posX + this.rand.nextInt(7) - this.rand.nextInt(7), (int)this.posY + this.rand.nextInt(6) - 2, (int)this.posZ + this.rand.nextInt(7) - this.rand.nextInt(7));
        }
        double var1 = (double)this.currentFlightTarget.posX + 0.5 - this.posX;
        double var3 = (double)this.currentFlightTarget.posY + 0.1 - this.posY;
        double var5 = (double)this.currentFlightTarget.posZ + 0.5 - this.posZ;
        double speed = 0.05000000149011612;
        this.motionX += (Math.signum(var1) * 0.5 - this.motionX) * speed;
        this.motionY += (Math.signum(var3) * (double)0.7f - this.motionY) * speed * 2.0;
        this.motionZ += (Math.signum(var5) * 0.5 - this.motionZ) * speed;
        float var7 = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) - 90.0f;
        float var8 = MathHelper.wrapAngleTo180_float((float)(var7 - this.rotationYaw));
        this.moveForward = 0.5f;
        this.rotationYaw += var8;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected void fall(float par1) {
    }

    protected void updateFallState(double par1, boolean par3) {
    }

    public boolean doesEntityNotTriggerPressurePlate() {
        return true;
    }

    public boolean getCanSpawnHere() {
        int var5;
        int var3;
        int var1 = MathHelper.floor_double((double)this.boundingBox.minY);
        if (var1 >= 63) {
            return false;
        }
        int var2 = MathHelper.floor_double((double)this.posX);
        int var4 = this.worldObj.getBlockLightValue(var2, var1, var3 = MathHelper.floor_double((double)this.posZ));
        return var4 > this.rand.nextInt(var5 = 4) ? false : super.getCanSpawnHere();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float par1) {
        return 0xF000F0;
    }

    public float getGlowBrightness() {
        return (float)Math.sin((double)this.ticksExisted / 7.0) + 1.0f;
    }
}

