/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import twilightforest.TFAchievementPage;
import twilightforest.TFFeature;
import twilightforest.entity.ai.EntityAITFEatLoose;
import twilightforest.entity.ai.EntityAITFFindLoose;
import twilightforest.item.TFItems;

public class EntityTFQuestRam
extends EntityAnimal {
    private int randomTickDivider;

    public EntityTFQuestRam(World world) {
        super(world);
        this.setSize(1.25f, 2.9f);
        this.randomTickDivider = 0;
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, (double)1.38f));
        this.tasks.addTask(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Item.getItemFromBlock((Block)Blocks.wool), false));
        this.tasks.addTask(3, (EntityAIBase)new EntityAITFEatLoose(this, Item.getItemFromBlock((Block)Blocks.wool)));
        this.tasks.addTask(4, (EntityAIBase)new EntityAITFFindLoose(this, 1.0f, Item.getItemFromBlock((Block)Blocks.wool)));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public EntityAnimal createChild(EntityAgeable entityAnimal) {
        return null;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(70.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue((double)0.23f);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(17, (Object)0);
    }

    public boolean isAIEnabled() {
        return true;
    }

    protected boolean canDespawn() {
        return false;
    }

    protected void updateAITick() {
        if (--this.randomTickDivider <= 0) {
            int chunkZ;
            this.randomTickDivider = 70 + this.rand.nextInt(50);
            int chunkX = MathHelper.floor_double((double)this.posX) / 16;
            TFFeature nearFeature = TFFeature.getNearestFeature(chunkX, chunkZ = MathHelper.floor_double((double)this.posZ) / 16, this.worldObj);
            if (nearFeature != TFFeature.questGrove) {
                this.detachHome();
            } else {
                ChunkCoordinates cc = TFFeature.getNearestCenterXYZ(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posZ), this.worldObj);
                this.setHomeArea(cc.posX, cc.posY, cc.posZ, 13);
            }
            if (this.countColorsSet() > 15 && !this.getRewarded()) {
                this.rewardQuest();
                this.setRewarded(true);
            }
        }
        super.updateAITick();
    }

    private void rewardQuest() {
        this.func_145778_a(Item.getItemFromBlock((Block)Blocks.diamond_block), 1, 1.0f);
        this.func_145778_a(Item.getItemFromBlock((Block)Blocks.iron_block), 1, 1.0f);
        this.func_145778_a(Item.getItemFromBlock((Block)Blocks.emerald_block), 1, 1.0f);
        this.func_145778_a(Item.getItemFromBlock((Block)Blocks.gold_block), 1, 1.0f);
        this.func_145778_a(Item.getItemFromBlock((Block)Blocks.lapis_block), 1, 1.0f);
        this.func_145778_a(TFItems.crumbleHorn, 1, 1.0f);
        this.rewardNearbyPlayers(this.worldObj, this.posX, this.posY, this.posZ);
    }

    private void rewardNearbyPlayers(World world, double posX, double posY, double posZ) {
        List nearbyPlayers = world.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBox((double)posX, (double)posY, (double)posZ, (double)(posX + 1.0), (double)(posY + 1.0), (double)(posZ + 1.0)).expand(16.0, 16.0, 16.0));
        for (EntityPlayer player : nearbyPlayers) {
            player.triggerAchievement((StatBase)TFAchievementPage.twilightQuestRam);
        }
    }

    public boolean interact(EntityPlayer par1EntityPlayer) {
        ItemStack currentItem = par1EntityPlayer.inventory.getCurrentItem();
        if (currentItem != null && currentItem.getItem() == Item.getItemFromBlock((Block)Blocks.wool) && !this.isColorPresent(currentItem.getItemDamage())) {
            this.setColorPresent(currentItem.getItemDamage());
            this.animateAddColor(currentItem.getItemDamage(), 50);
            if (!par1EntityPlayer.capabilities.isCreativeMode) {
                --currentItem.stackSize;
                if (currentItem.stackSize <= 0) {
                    par1EntityPlayer.inventory.setInventorySlotContents(par1EntityPlayer.inventory.currentItem, (ItemStack)null);
                }
            }
            return true;
        }
        return super.interact(par1EntityPlayer);
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        this.checkAndAnimateColors();
    }

    public void checkAndAnimateColors() {
        if (this.countColorsSet() > 15 && !this.getRewarded()) {
            this.animateAddColor(this.rand.nextInt(16), 5);
        }
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("ColorFlags", this.getColorFlags());
        par1NBTTagCompound.setBoolean("Rewarded", this.getRewarded());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setColorFlags(par1NBTTagCompound.getInteger("ColorFlags"));
        this.setRewarded(par1NBTTagCompound.getBoolean("Rewarded"));
    }

    public int getColorFlags() {
        return this.dataWatcher.getWatchableObjectInt(16);
    }

    public void setColorFlags(int par1) {
        this.dataWatcher.updateObject(16, (Object)par1);
    }

    public boolean isColorPresent(int color) {
        int flags = this.getColorFlags();
        return (flags & (int)Math.pow(2.0, color)) > 0;
    }

    public void setColorPresent(int color) {
        int flags = this.getColorFlags();
        this.setColorFlags(flags | (int)Math.pow(2.0, color));
    }

    public boolean getRewarded() {
        return this.dataWatcher.getWatchableObjectByte(17) != 0;
    }

    public void setRewarded(boolean par1) {
        this.dataWatcher.updateObject(17, (Object)(par1 ? (byte)1 : 0));
    }

    public void animateAddColor(int color, int iterations) {
        for (int i = 0; i < iterations; ++i) {
            this.worldObj.spawnParticle("mobSpell", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width * 1.5, this.posY + this.rand.nextDouble() * (double)this.height * 1.5, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width * 1.5, (double)EntitySheep.fleeceColorTable[color][0], (double)EntitySheep.fleeceColorTable[color][1], (double)EntitySheep.fleeceColorTable[color][2]);
        }
        this.playLivingSound();
    }

    public int countColorsSet() {
        int count = 0;
        for (int i = 0; i < 16; ++i) {
            if (!this.isColorPresent(i)) continue;
            ++count;
        }
        return count;
    }

    public void playLivingSound() {
        this.worldObj.playSoundAtEntity((Entity)this, "mob.sheep.say", this.getSoundVolume(), this.getSoundPitch());
    }

    protected float getSoundVolume() {
        return 5.0f;
    }

    protected float getSoundPitch() {
        return (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 0.7f;
    }

    protected String getLivingSound() {
        return "mob.sheep.say";
    }

    protected String getHurtSound() {
        return "mob.sheep.say";
    }

    protected String getDeathSound() {
        return "mob.sheep.say";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.playSound("mob.sheep.step", 0.15f, 1.0f);
    }

    public float getMaximumHomeDistance() {
        return this.func_110174_bM();
    }
}

