/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import twilightforest.entity.ai.EntityTFRavenLookHelper;
import twilightforest.entity.passive.EntityTFTinyBird;
import twilightforest.item.TFItems;

public class EntityTFRaven
extends EntityTFTinyBird {
    EntityTFRavenLookHelper ravenLook = new EntityTFRavenLookHelper((EntityLiving)this);

    public EntityTFRaven(World par1World) {
        super(par1World);
        this.setSize(0.3f, 0.7f);
        this.stepHeight = 1.0f;
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.5));
        this.tasks.addTask(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, (double)0.85f, Items.wheat_seeds, true));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(10.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.20000001192092895);
    }

    @Override
    protected void updateAITasks() {
        super.updateAITasks();
        this.ravenLook.onUpdateLook();
    }

    public EntityLookHelper getLookHelper() {
        return this.ravenLook;
    }

    @Override
    protected String getLivingSound() {
        return "TwilightForest:mob.raven.caw";
    }

    @Override
    protected String getHurtSound() {
        return "TwilightForest:mob.raven.squawk";
    }

    @Override
    protected String getDeathSound() {
        return "TwilightForest:mob.raven.squawk";
    }

    @Override
    protected Item getDropItem() {
        return TFItems.feather;
    }

    @Override
    public float getRenderSizeModifier() {
        return 0.3f;
    }

    @Override
    public boolean isSpooked() {
        return this.hurtTime > 0;
    }
}

