/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import twilightforest.TFAchievementPage;
import twilightforest.entity.ai.EntityAITFBirdFly;
import twilightforest.entity.passive.EntityTFBird;

public class EntityTFTinyBird
extends EntityTFBird {
    private static final int DATA_BIRDTYPE = 16;
    private static final int DATA_BIRDFLAGS = 17;
    private ChunkCoordinates currentFlightTarget;
    private int currentFlightTime;

    public EntityTFTinyBird(World par1World) {
        super(par1World);
        this.setSize(0.5f, 0.9f);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(0, (EntityAIBase)new EntityAITFBirdFly(this));
        this.tasks.addTask(1, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.wheat_seeds, true));
        this.tasks.addTask(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.setBirdType(this.rand.nextInt(4));
        this.setIsBirdLanded(true);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(17, (Object)0);
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(1.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.20000001192092895);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("BirdType", this.getBirdType());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setBirdType(par1NBTTagCompound.getInteger("BirdType"));
    }

    public int getBirdType() {
        return this.dataWatcher.getWatchableObjectByte(16);
    }

    public void setBirdType(int par1) {
        this.dataWatcher.updateObject(16, (Object)((byte)par1));
    }

    protected String getLivingSound() {
        return "TwilightForest:mob.tinybird.chirp";
    }

    protected String getHurtSound() {
        return "TwilightForest:mob.tinybird.hurt";
    }

    protected String getDeathSound() {
        return "TwilightForest:mob.tinybird.hurt";
    }

    public float getRenderSizeModifier() {
        return 0.3f;
    }

    protected boolean canDespawn() {
        return false;
    }

    public float getBlockPathWeight(int par1, int par2, int par3) {
        Material underMaterial = this.worldObj.getBlock(par1, par2 - 1, par3).getMaterial();
        if (underMaterial == Material.leaves) {
            return 200.0f;
        }
        if (underMaterial == Material.wood) {
            return 15.0f;
        }
        if (underMaterial == Material.grass) {
            return 9.0f;
        }
        return this.worldObj.getLightBrightness(par1, par2, par3) - 0.5f;
    }

    public void onDeath(DamageSource par1DamageSource) {
        super.onDeath(par1DamageSource);
        if (par1DamageSource.getSourceOfDamage() instanceof EntityPlayer) {
            ((EntityPlayer)par1DamageSource.getSourceOfDamage()).triggerAchievement((StatBase)TFAchievementPage.twilightHunter);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.isBirdLanded()) {
            this.motionY *= (double)0.6f;
        }
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (this.isBirdLanded()) {
            this.currentFlightTime = 0;
            if (this.rand.nextInt(200) == 0 && !this.isLandableBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)(this.posY - 1.0)), MathHelper.floor_double((double)this.posZ))) {
                this.setIsBirdLanded(false);
                this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1015, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
                this.motionY = 0.4;
            } else if (this.isSpooked()) {
                this.setIsBirdLanded(false);
                this.motionY = 0.4;
                this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1015, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
            }
        } else {
            ++this.currentFlightTime;
            if (!(this.currentFlightTarget == null || this.worldObj.isAirBlock(this.currentFlightTarget.posX, this.currentFlightTarget.posY, this.currentFlightTarget.posZ) && this.currentFlightTarget.posY >= 1)) {
                this.currentFlightTarget = null;
            }
            if (this.currentFlightTarget == null || this.rand.nextInt(30) == 0 || this.currentFlightTarget.getDistanceSquared((int)this.posX, (int)this.posY, (int)this.posZ) < 4.0f) {
                int yTarget = this.currentFlightTime < 100 ? 2 : 4;
                this.currentFlightTarget = new ChunkCoordinates((int)this.posX + this.rand.nextInt(7) - this.rand.nextInt(7), (int)this.posY + this.rand.nextInt(6) - yTarget, (int)this.posZ + this.rand.nextInt(7) - this.rand.nextInt(7));
            }
            double d0 = (double)this.currentFlightTarget.posX + 0.5 - this.posX;
            double d1 = (double)this.currentFlightTarget.posY + 0.1 - this.posY;
            double d2 = (double)this.currentFlightTarget.posZ + 0.5 - this.posZ;
            this.motionX += (Math.signum(d0) * 0.5 - this.motionX) * (double)0.1f;
            this.motionY += (Math.signum(d1) * (double)0.7f - this.motionY) * (double)0.1f;
            this.motionZ += (Math.signum(d2) * 0.5 - this.motionZ) * (double)0.1f;
            float f = (float)(Math.atan2(this.motionZ, this.motionX) * 180.0 / Math.PI) - 90.0f;
            float f1 = MathHelper.wrapAngleTo180_float((float)(f - this.rotationYaw));
            this.moveForward = 0.5f;
            this.rotationYaw += f1;
            if (this.rand.nextInt(10) == 0 && this.isLandableBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)(this.posY - 1.0)), MathHelper.floor_double((double)this.posZ))) {
                this.setIsBirdLanded(true);
                this.motionY = 0.0;
            }
        }
    }

    public boolean isSpooked() {
        EntityPlayer closestPlayer = this.worldObj.getClosestPlayerToEntity((Entity)this, 4.0);
        return this.hurtTime > 0 || closestPlayer != null && (closestPlayer.inventory.getCurrentItem() == null || closestPlayer.inventory.getCurrentItem().getItem() != Items.wheat_seeds);
    }

    public boolean isLandableBlock(int x, int y, int z) {
        Block block = this.worldObj.getBlock(x, y, z);
        if (block == Blocks.air) {
            return false;
        }
        return block.isLeaves((IBlockAccess)this.worldObj, x, y, z) || block.isSideSolid((IBlockAccess)this.worldObj, x, y, z, ForgeDirection.UP);
    }

    @Override
    public boolean isBirdLanded() {
        return (this.dataWatcher.getWatchableObjectByte(17) & 1) != 0;
    }

    public void setIsBirdLanded(boolean par1) {
        byte b0 = this.dataWatcher.getWatchableObjectByte(17);
        if (par1) {
            this.dataWatcher.updateObject(17, (Object)((byte)(b0 | 1)));
        } else {
            this.dataWatcher.updateObject(17, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean canBePushed() {
        return false;
    }

    protected void collideWithEntity(Entity par1Entity) {
    }

    protected void func_85033_bc() {
    }
}

