/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import twilightforest.block.BlockTFPlant;
import twilightforest.block.TFBlocks;

public class ItemBlockTFPlant
extends ItemBlock {
    public ItemBlockTFPlant(Block block) {
        super(block);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    public IIcon getIconFromDamage(int par1) {
        return TFBlocks.plant.getIcon(2, par1);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack par1ItemStack, int par2) {
        return TFBlocks.plant.getRenderColor(par1ItemStack.getItemDamage());
    }

    public String getUnlocalizedName(ItemStack itemstack) {
        int meta = itemstack.getItemDamage();
        return super.getUnlocalizedName() + "." + meta;
    }

    public int getMetadata(int i) {
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_150936_a(World par1World, int x, int y, int z, int direction, EntityPlayer par6EntityPlayer, ItemStack par7ItemStack) {
        int meta = par7ItemStack.getItemDamage();
        if ((meta == 14 || meta == 13) && direction == 0 && BlockTFPlant.canPlaceRootBelow(par1World, x, y, z)) {
            return true;
        }
        return super.func_150936_a(par1World, x, y, z, direction, par6EntityPlayer, par7ItemStack);
    }

    public boolean onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int direction, float par8, float par9, float par10) {
        int meta = itemStack.getItemDamage();
        if (meta == 14 || meta == 13) {
            return this.onItemUseRoot(itemStack, player, world, x, y, z, direction);
        }
        return super.onItemUse(itemStack, player, world, x, y, z, direction, par8, par9, par10);
    }

    public boolean onItemUseRoot(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int direction) {
        Block plantBlock;
        Block blockThereId = world.getBlock(x, y, z);
        if (blockThereId == Blocks.snow) {
            direction = 1;
        } else if (!blockThereId.getMaterial().isReplaceable()) {
            x += Facing.offsetsXForSide[direction];
            y += Facing.offsetsYForSide[direction];
            z += Facing.offsetsZForSide[direction];
        }
        if (!player.canPlayerEdit(x, y, z, direction, itemStack)) {
            return false;
        }
        if (itemStack.stackSize == 0) {
            return false;
        }
        if (BlockTFPlant.canPlaceRootBelow(world, x, y + 1, z) && world.setBlock(x, y, z, plantBlock = TFBlocks.plant, itemStack.getItem().getMetadata(itemStack.getItemDamage()), 3)) {
            if (world.getBlock(x, y, z) == plantBlock) {
                plantBlock.onBlockPlacedBy(world, x, y, z, (EntityLivingBase)player, itemStack);
            }
            world.playSoundEffect((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), plantBlock.stepSound.getBreakSound(), (plantBlock.stepSound.getVolume() + 1.0f) / 2.0f, plantBlock.stepSound.getPitch() * 0.8f);
            --itemStack.stackSize;
        }
        return true;
    }
}

