/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;

public abstract class ItemTFBowBase
extends ItemBow {
    private IIcon[] iconArray;

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon(this.getIconString() + "_standby");
        this.iconArray = new IIcon[bowPullIconNameArray.length];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = par1IconRegister.registerIcon(this.getIconString() + "_" + bowPullIconNameArray[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getItemIconForUseDuration(int par1) {
        return this.iconArray[par1];
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (usingItem != null) {
            int j = usingItem.getMaxItemUseDuration() - useRemaining;
            if (j >= 18) {
                return this.getItemIconForUseDuration(2);
            }
            if (j > 13) {
                return this.getItemIconForUseDuration(1);
            }
            if (j > 0) {
                return this.getItemIconForUseDuration(0);
            }
        }
        return this.getIcon(stack, renderPass);
    }

    public void onPlayerStoppedUsing(ItemStack itemstack, World world, EntityPlayer entityPlayer, int itemInUseCount) {
        boolean isNoPickup;
        int charge = this.getMaxItemUseDuration(itemstack) - itemInUseCount;
        ArrowLooseEvent event = new ArrowLooseEvent(entityPlayer, itemstack, charge);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        charge = event.charge;
        boolean bl = isNoPickup = entityPlayer.capabilities.isCreativeMode || EnchantmentHelper.getEnchantmentLevel((int)Enchantment.infinity.effectId, (ItemStack)itemstack) > 0;
        if (isNoPickup || entityPlayer.inventory.hasItem(Items.arrow)) {
            int punchLevel;
            int powerLevel;
            float velocity = (float)charge / 20.0f;
            if ((double)(velocity = (velocity * velocity + velocity * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (velocity > 1.0f) {
                velocity = 1.0f;
            }
            EntityArrow entityarrow = this.getArrow(world, entityPlayer, velocity * 2.0f);
            if (velocity == 1.0f) {
                entityarrow.setIsCritical(true);
            }
            if ((powerLevel = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)itemstack)) > 0) {
                entityarrow.setDamage(entityarrow.getDamage() + (double)powerLevel * 0.5 + 0.5);
            }
            if ((punchLevel = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)itemstack)) > 0) {
                entityarrow.setKnockbackStrength(punchLevel);
            }
            if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)itemstack) > 0) {
                entityarrow.setFire(100);
            }
            itemstack.damageItem(1, (EntityLivingBase)entityPlayer);
            world.playSoundAtEntity((Entity)entityPlayer, "random.bow", 1.0f, 1.0f / (itemRand.nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
            if (isNoPickup) {
                entityarrow.canBePickedUp = 2;
            } else {
                entityPlayer.inventory.consumeInventoryItem(Items.arrow);
            }
            if (!world.isRemote) {
                world.spawnEntityInWorld((Entity)entityarrow);
            }
        }
    }

    protected EntityArrow getArrow(World world, EntityPlayer entityPlayer, float velocity) {
        return new EntityArrow(world, (EntityLivingBase)entityPlayer, velocity);
    }
}

